<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/New.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/New.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: New.m3                                                
 Last Modified On Tue Dec 20 14:25:01 PST 1994 By kalsow     
      Modified On Fri Jan 25 08:10:52 1991 By muller         

<P><PRE>MODULE <module><implements><A HREF="New.i3">New</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/Error.i3">Error</A>;
IMPORT <A HREF="../types/RefType.i3">RefType</A>, <A HREF="../types/ObjectType.i3">ObjectType</A>, <A HREF="../types/OpaqueType.i3">OpaqueType</A>, <A HREF="../exprs/KeywordExpr.i3">KeywordExpr</A>, <A HREF="../values/Value.i3">Value</A>;
IMPORT <A HREF="../values/Field.i3">Field</A>, <A HREF="../values/Method.i3">Method</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../types/ProcType.i3">ProcType</A>, <A HREF="../stmts/AssignStmt.i3">AssignStmt</A>, <A HREF="../types/OpenArrayType.i3">OpenArrayType</A>;
IMPORT <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../types/RecordType.i3">RecordType</A>, <A HREF="../exprs/TypeExpr.i3">TypeExpr</A>, <A HREF="../builtinTypes/Null.i3">Null</A>, <A HREF="../values/Revelation.i3">Revelation</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>, <A HREF="../misc/Runtime.i3">Runtime</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (ce: CallExpr.T): Type.T =
  VAR t: Type.T;
  BEGIN
    IF NOT TypeExpr.Split (ce.args[0], t) THEN  t := Null.T;
    ELSIF RefType.Is (t)    THEN (* ok *)
    ELSIF ObjectType.Is (t) THEN (* sleazy bug!!  ignore method overrides *)
    ELSIF OpaqueType.Is (t) THEN (* sleazy bug!!  ignore method overrides *)
    ELSE  t := Null.T;
    END;
    RETURN t;
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR t, r: Type.T;
  BEGIN
    IF KeywordExpr.Is (ce.args[0]) THEN
      Error.Msg (&quot;NEW: keyword bindings not allowed for type&quot;);
    END;
    IF NOT TypeExpr.Split (ce.args[0], t) THEN
      Error.Msg (&quot;NEW must be applied to a reference type&quot;);
      t := Null.T;
    ELSIF (RefType.Split (t, r)) THEN
      CheckRef (r, ce, cs);
    ELSIF (ObjectType.Is (t)) THEN
      r := CheckObject (t, ce, cs);
      IF (r # t) THEN
        ce.args[0] := TypeExpr.New (r);
        Expr.TypeCheck (ce.args[0], cs);
        t := r;
      END;
    ELSIF (OpaqueType.Is (t)) THEN
      r := CheckOpaque (t, ce, cs);
      IF (r # t) THEN
        ce.args[0] := TypeExpr.New (r);
        Expr.TypeCheck (ce.args[0], cs);
        t := r;
      END;
    ELSE
      Error.Msg (&quot;NEW must be applied to a reference type&quot;);
    END;
    ce.type := t;
  END Check;

PROCEDURE <A NAME="CheckRef"><procedure>CheckRef</procedure></A> (r: Type.T;  ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR
    base: Type.T;
    fields: Value.T;
    info : Type.Info;
  BEGIN
    r := Type.CheckInfo (r, info);
    base := Type.Base (r);
    IF (r = NIL) THEN
     Error.Msg(&quot;cannot NEW an open reference type (REFANY, ADDRESS, or NULL)&quot;);
    ELSIF (info.isEmpty) THEN
      Error.Msg (&quot;cannot allocate variables of empty types&quot;);
    ELSIF (info.class = Type.Class.OpenArray) THEN
      CheckOpenArray (r, ce);
    ELSIF (info.class = Type.Class.Record) THEN
      CheckRecord (base, ce, cs);
    ELSIF RecordType.Split (base, fields) THEN
      CheckRecord (base, ce, cs);
    ELSIF (NUMBER (ce.args^) &gt; 1) THEN
      Error.Msg (&quot;too many arguments to NEW&quot;);
    END;
  END CheckRef;

PROCEDURE <A NAME="CheckOpenArray"><procedure>CheckOpenArray</procedure></A> (r: Type.T;  ce: CallExpr.T) =
  VAR x, elt: Type.T;
  BEGIN
    FOR i := 1 TO LAST (ce.args^) DO
      x := Type.Base (Expr.TypeOf (ce.args[i]));
      IF KeywordExpr.Is (ce.args[i]) THEN
        Error.Msg (&quot;NEW: not a procedure; keyword bindings not allowed for array dimensions&quot;);
      END;
      IF  NOT Type.IsEqual (x, Int.T, NIL) THEN
        Error.Int (i, &quot;argument must be an integer&quot;);
      ELSIF (NOT OpenArrayType.Split (r, elt)) THEN
        Error.Int (i, &quot;too many dimensions specified&quot;);
      ELSE (* ok *)
        r := elt;
      END;
    END;
    IF OpenArrayType.Is (r) THEN
      Error.Msg (&quot;not enough dimensions specified&quot;);
    END;
  END CheckOpenArray;

PROCEDURE <A NAME="CheckRecord"><procedure>CheckRecord</procedure></A> (t: Type.T;  ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR
    x: Type.T;
    key: M3ID.T;
    value: Expr.T;
    field: Value.T;
  BEGIN
    FOR i := 1 TO LAST (ce.args^) DO
      x := Expr.TypeOf (ce.args[i]);
      IF  NOT KeywordExpr.Split (ce.args[i], key, value) THEN
        Error.Msg (&quot;extra arguments must include keywords&quot;);
      ELSIF NOT RecordType.LookUp (t, key, field) THEN
        Error.ID (key, &quot;unknown record field&quot;);
      ELSIF NOT Field.Is (field) THEN
        Error.ID (key, &quot;undefined field?&quot;);
      ELSIF NOT Type.IsAssignable (Value.TypeOf (field), x) THEN
        Error.ID (key, &quot;value is not assignable to field&quot;);
      ELSE
        AssignStmt.Check (Value.TypeOf (field), value, cs);
      END;
    END;
  END CheckRecord;

PROCEDURE <A NAME="CheckObject"><procedure>CheckObject</procedure></A> (t: Type.T;  ce: CallExpr.T;  VAR cs: Expr.CheckState): Type.T =
  VAR
    x: Type.T;
    key: M3ID.T;
    value: Expr.T;
    v: Value.T;
    visible: Type.T;
    newType: Type.T := NIL;
    fields: Scope.T;
    overrides: Scope.T;
    n_overrides: INTEGER := 0;
    zz: Scope.T;
    method: Method.Info;
    field: Field.Info;
    info: Type.Info;
  BEGIN
    t := Type.CheckInfo (t, info);

    (* first pass, remove the method overrides &amp; build a new object type *)
    FOR i := 1 TO LAST (ce.args^) DO
      x := Expr.TypeOf (ce.args[i]);
      IF KeywordExpr.Split (ce.args[i], key, value)
        AND ObjectType.LookUp (t, key, v, visible)
        AND Method.Split (v, method) THEN
        IF (newType = NIL) THEN
          fields := Scope.PushNew (FALSE, M3ID.NoID); Scope.PopNew ();
          overrides := Scope.PushNew (FALSE, M3ID.NoID); Scope.PopNew ();
          newType := ObjectType.New (t, info.isTraced, NIL, fields, overrides);
        END;
        zz := Scope.Push (overrides);
          method.name      := key;
          method.offset    := n_overrides * Target.Address.size;
          method.parent    := newType;
          method.signature := NIL;
          method.dfault    := value;
          method.override  := TRUE;
          Method.NoteOverride (Method.New (method), v);
          INC (n_overrides);
        Scope.Pop (zz);
      END;
    END;

    IF (newType # NIL) THEN
      newType := Type.Check (newType);
      t := newType;
    END;

    (* second pass, do the checking *)
    FOR i := 1 TO LAST (ce.args^) DO
      x := Expr.TypeOf (ce.args[i]);
      IF NOT KeywordExpr.Split (ce.args[i], key, value) THEN
        Error.Msg (&quot;extra arguments must include keywords&quot;);
      ELSIF NOT ObjectType.LookUp (t, key, v, visible) THEN
        Error.ID (key, &quot;unknown object field or method&quot;);
      ELSIF Method.Split (v, method) THEN
        IF NOT ProcType.IsCompatible (x, t, method.signature) THEN
          Error.ID (key, &quot;procedure is not compatible with method&quot;);
        END;
        ce.args[i] := NIL;
      ELSIF Field.Is (v) THEN
        Field.Split (v, field);
        IF NOT Type.IsAssignable (field.type, x)
          THEN Error.ID (key, &quot;value is not assignable to field&quot;);
          ELSE AssignStmt.Check (field.type, value, cs);
        END;
      ELSE
        Error.ID (key, &quot;undefined?&quot;);
      END;
    END;

    RETURN t;
  END CheckObject;

PROCEDURE <A NAME="CheckOpaque"><procedure>CheckOpaque</procedure></A> (t: Type.T; ce: CallExpr.T;  VAR cs: Expr.CheckState): Type.T =
  (* we already know that t is not an object, so we only need to
     check for a full revelation that says it's a REF *)
  VAR x := Revelation.LookUp (t);  r: Type.T;
  BEGIN
    IF (x = NIL) THEN
      Error.Msg (&quot;cannot apply NEW to non-object, opaque types&quot;);
    ELSIF RefType.Split (x, r) THEN
      (* full revelation =&gt; t is a REF *)
      CheckRef (r, ce, cs);
    ELSE
      Error.Msg (&quot;cannot apply NEW to this type&quot;);
    END;
    RETURN t;
  END CheckOpaque;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Gen (ce);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    (* all the work was done by Prep *)
    CG.Push (ce.tmp);
    CG.Boost_alignment (ce.align);
    CG.Free (ce.tmp);
    ce.tmp := NIL;
  END Compile;

PROCEDURE <A NAME="Gen"><procedure>Gen</procedure></A> (ce: CallExpr.T) =
  VAR t, r: Type.T;
  BEGIN
    VAR b := TypeExpr.Split (ce.args[0], t); BEGIN &lt;* ASSERT b *&gt; END;
    Type.Compile (t);
    IF (RefType.Split (t, r)) THEN GenRef (t, Type.Strip (r), ce);
    ELSIF (ObjectType.Is (t)) THEN GenObject (t, ce);
    ELSIF (OpaqueType.Is (t)) THEN GenOpaque (t, ce);
    ELSE Error.Msg (&quot;NEW must be applied to a variable of a reference type&quot;);
    END;
  END Gen;

PROCEDURE <A NAME="GenRef"><procedure>GenRef</procedure></A> (t, r: Type.T;  ce: CallExpr.T) =
  CONST PHook = ARRAY BOOLEAN OF Runtime.Hook { Runtime.Hook.NewUntracedRef,
                                                Runtime.Hook.NewTracedRef };
  VAR
    base   := Type.Base (r);
    fields : Value.T;
    proc   : Procedure.T;
    t_info : Type.Info;
    r_info : Type.Info;
  BEGIN
    t := Type.CheckInfo (t, t_info);
    r := Type.CheckInfo (r, r_info);

    IF (r_info.class = Type.Class.OpenArray) THEN
      GenOpenArray (t, t_info.isTraced, r_info, ce);

    ELSIF RecordType.Split (base, fields) THEN
      GenRecord (t, base, t_info.isTraced, r_info, ce);

    ELSE
      proc := Runtime.LookUpProc (PHook [t_info.isTraced]);
      Procedure.StartCall (proc);
      Type.LoadInfo (t, -1);
      CG.Pop_param (CG.Type.Addr);
      ce.tmp := Procedure.EmitCall (proc);
      ce.align := r_info.alignment;
    END;
  END GenRef;

PROCEDURE <A NAME="GenOpenArray"><procedure>GenOpenArray</procedure></A> (t: Type.T;  traced: BOOLEAN;
                        READONLY r_info: Type.Info;  ce: CallExpr.T) =
  CONST PHook = ARRAY BOOLEAN OF Runtime.Hook { Runtime.Hook.NewUntracedArray,
                                                Runtime.Hook.NewTracedArray };
  VAR
    n := LAST (ce.args^); (* number of open dimensions *)
    sizes := CG.Declare_temp (Target.Address.pack + (n+1)*Target.Integer.pack,
                              Target.Address.align, CG.Type.Struct,
                              in_memory := TRUE);
    offset: INTEGER;
    proc := Runtime.LookUpProc (PHook [traced]);
  BEGIN
    (* initialize the pointer to the array sizes *)
    CG.Load_addr_of (sizes, M3RT.OA_size_1, Target.Address.align);
    CG.Store_addr (sizes, M3RT.OA_elt_ptr);

    (* initialize the count of array sizes *)
    CG.Load_intt (n);
    CG.Store_int (sizes, M3RT.OA_size_0);

    (* initialize each array size *)
    offset := M3RT.OA_size_1;
    FOR i := 1 TO n DO
      Expr.Prep (ce.args[i]);
      Expr.Compile (ce.args[i]);
      CG.Store_int (sizes, offset);
      INC (offset, Target.Integer.pack);
    END;

    (* allocate the storage *)
    Procedure.StartCall (proc);
    IF Target.DefaultCall.args_left_to_right THEN
      Type.LoadInfo (t, -1);
      CG.Pop_param (CG.Type.Addr);
      CG.Load_addr_of (sizes, 0, Target.Address.align);
      CG.Pop_param (CG.Type.Addr);
    ELSE
      CG.Load_addr_of (sizes, 0, Target.Address.align);
      CG.Pop_param (CG.Type.Addr);
      Type.LoadInfo (t, -1);
      CG.Pop_param (CG.Type.Addr);
    END;
    ce.tmp := Procedure.EmitCall (proc);
    ce.align := r_info.alignment;

    CG.Free_temp (sizes);
  END GenOpenArray;

PROCEDURE <A NAME="GenRecord"><procedure>GenRecord</procedure></A> (t, r: Type.T;  traced: BOOLEAN;
                     READONLY r_info: Type.Info;  ce: CallExpr.T) =
  CONST PHook = ARRAY BOOLEAN OF Runtime.Hook { Runtime.Hook.NewUntracedRef,
                                                Runtime.Hook.NewTracedRef };
  VAR
    key: M3ID.T;
    value: Expr.T;
    field: Field.Info;
    v: Value.T;
    align := r_info.alignment;
    proc := Runtime.LookUpProc (PHook [traced]);
    b: BOOLEAN;
  BEGIN
    (* allocate the record's storage *)
    Procedure.StartCall (proc);
    Type.LoadInfo (t, -1);
    CG.Pop_param (CG.Type.Addr);
    ce.tmp := Procedure.EmitCall (proc);
    ce.align := align;

    (* do the user specified initialization *)
    FOR i := 1 TO LAST (ce.args^) DO
      b := KeywordExpr.Split (ce.args[i], key, value); &lt;*ASSERT b*&gt;
      Expr.Prep (value);
      EVAL RecordType.LookUp (r, key, v);
      Field.Split (v, field);
      CG.Push (ce.tmp);
      CG.Boost_alignment (align);
      CG.Add_offset (field.offset);
      AssignStmt.Emit (field.type, value);
    END;
  END GenRecord;

PROCEDURE <A NAME="GenObject"><procedure>GenObject</procedure></A> (t: Type.T;  ce: CallExpr.T) =
  CONST PHook = ARRAY BOOLEAN OF Runtime.Hook { Runtime.Hook.NewUntracedObj,
                                                Runtime.Hook.NewTracedRef };
  VAR
    key: M3ID.T;
    value: Expr.T;
    field: Field.Info;
    v: Value.T;
    visible: Type.T;
    obj_offset: INTEGER;
    obj_align: INTEGER;
    proc: Procedure.T;
    info: Type.Info;
    b: BOOLEAN;
  BEGIN
    t := Type.CheckInfo (t, info);
    proc := Runtime.LookUpProc (PHook [info.isTraced]);

    (* allocate the object's storage *)
    Procedure.StartCall (proc);
    Type.LoadInfo (t, -1);
    CG.Pop_param (CG.Type.Addr);
    ce.tmp := Procedure.EmitCall (proc);
    ce.align := info.alignment;

    (* do the user specified initialization *)
    FOR i := 1 TO LAST (ce.args^) DO
      IF (ce.args[i] # NIL) THEN
        b := KeywordExpr.Split (ce.args[i], key, value); &lt;*ASSERT b*&gt;
        Expr.Prep (value);
        b := ObjectType.LookUp (t, key, v, visible); &lt;*ASSERT b*&gt;
        Field.Split (v, field);
        CG.Push (ce.tmp);
        ObjectType.GetFieldOffset (visible, obj_offset, obj_align);
        IF (obj_offset &gt;= 0) THEN
          INC (field.offset, obj_offset);
        ELSE
          Type.LoadInfo (visible, M3RT.TC_dataOffset);
          CG.Index_bytes (Target.Byte);
        END;
        CG.Add_offset (field.offset);
        CG.Boost_alignment (obj_align);
        AssignStmt.Emit (field.type, value);
      END;
    END;
  END GenObject;

PROCEDURE <A NAME="GenOpaque"><procedure>GenOpaque</procedure></A> (t: Type.T;  ce: CallExpr.T) =
  VAR x := Revelation.LookUp (t);  r: Type.T;
  BEGIN
    IF (x = NIL) THEN
      &lt;* ASSERT FALSE *&gt;
    ELSIF RefType.Split (x, r) THEN
      (* full revelation =&gt; t is a REF *)
      GenRef (x, Type.Strip (r), ce);
    ELSE
      &lt;* ASSERT FALSE *&gt;
    END;
  END GenOpaque;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, LAST (INTEGER), TRUE, TRUE, TRUE, NIL,
                                 TypeOf,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 CallExpr.NoValue,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;NEW&quot;, Z, TRUE);
  END Initialize;

BEGIN
END New.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
