<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Number.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Number.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Number.m3                                             
 Last Modified On Tue May  3 16:32:23 PDT 1994 By kalsow     
      Modified On Fri Dec 21 01:16:23 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Number.i3">Number</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="#x1">Card</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../exprs/ArrayExpr.i3">ArrayExpr</A>;
IMPORT <A HREF="../types/ArrayType.i3">ArrayType</A>, <A HREF="../exprs/TypeExpr.i3">TypeExpr</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../types/EnumType.i3">EnumType</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  &lt;*UNUSED*&gt; VAR cs: Expr.CheckState) =
  VAR e: Expr.T; t, index, element: Type.T;
  BEGIN
    e := ce.args[0];
    t := Expr.TypeOf (e);
    IF ArrayType.Split (t, index, element) THEN
      IF (index = NIL) THEN index := Int.T END;
    ELSIF TypeExpr.Split (e, t) THEN
      IF ArrayType.Split (t, index, element) THEN
        IF (index = NIL) THEN
          Error.Msg (&quot;NUMBER: argument cannot be an open array type&quot;);
          index := Int.T;
        END;
      ELSE
        index := t;
      END;
    ELSE
      Error.Msg (&quot;NUMBER: argument must be a type or array&quot;);
      index := Int.T;
    END;
    IF EnumType.Is (index) THEN
      IF NOT TInt.LT (TInt.Zero, Type.Number (index)) THEN
        Error.Msg (&quot;NUMBER: empty enumeration type&quot;);
      END;
    ELSIF Type.IsOrdinal (index) THEN
      (* ordinal type =&gt; OK*)
    ELSE
      Error.Msg (&quot;NUMBER: argument must be an ordinal type, array type or array&quot;);
    END;
    ce.type := Card.T;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  VAR
    e := ce.args[0];
    t, index, element: Type.T;
  BEGIN
    IF NOT TypeExpr.Split (e, t) THEN t := Expr.TypeOf (e) END;
    Type.Compile (t);
    IF ArrayType.Split (t, index, element) THEN t := index END;

    IF (t = NIL) THEN (* open array *)
      Expr.Prep (e);
    END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR
    e := ce.args[0];
    t, index, element: Type.T;
    min, max, tmp, num: Target.Int;
  BEGIN
    IF NOT TypeExpr.Split (e, t) THEN t := Expr.TypeOf (e) END;
    IF ArrayType.Split (t, index, element) THEN t := index END;

    IF (t = NIL) THEN (* open array *)
      Expr.Compile (e);
      CG.Open_size (0);
    ELSE
      EVAL Type.GetBounds (t, min, max);
      IF TInt.LT (max, min) THEN
        CG.Load_integer (TInt.Zero);
      ELSIF TInt.Subtract (max, min, tmp)
        AND TInt.Add (tmp, TInt.One, num) THEN
        CG.Load_integer (num);
      ELSE
        Error.Warn (2, &quot;result of NUMBER too large&quot;);
        CG.Load_integer (Target.Integer.max);
        CG.Check_hi (TInt.Zero);
      END;
    END;
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR min, max, tmp, num: Target.Int;  t, index, elem: Type.T;  e: Expr.T;
  BEGIN
    e := ce.args[0];
    IF NOT TypeExpr.Split (e, t) THEN
      t := Expr.TypeOf (e);
      IF NOT ArrayType.Split (t, index, elem) THEN RETURN NIL END;
      IF (index = NIL) THEN
        (* NUMBER (open array value) =&gt; try for constant open array *)
        e := Expr.ConstValue (e);
        IF (e = NIL) THEN RETURN NIL END;
        IF ArrayExpr.GetBounds (e, min, max)
          AND TInt.Subtract (max, min, tmp)
          AND TInt.Add (tmp, TInt.One, num)
          THEN RETURN IntegerExpr.New (num);
          ELSE RETURN NIL;
        END;
      END;
    END;
    IF ArrayType.Split (t, t, elem) AND (t = NIL) THEN RETURN NIL; END;
    IF NOT Type.GetBounds (t, min, max) THEN RETURN NIL; END;

    IF TInt.LT (max, min) THEN
      RETURN IntegerExpr.New (TInt.Zero);
    ELSIF TInt.Subtract (max, min, tmp)
      AND TInt.Add (tmp, TInt.One, num) THEN
      RETURN IntegerExpr.New (num);
    ELSE
      RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, FALSE, Card.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;NUMBER&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Number.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Card is in:
</A><UL>
<LI><A HREF="../../../bicycle/src/Card.i3#0TOP0">bicycle/src/Card.i3</A>
<LI><A HREF="../builtinTypes/Card.i3#0TOP0">m3front/src/builtinTypes/Card.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
