<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Ord.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Ord.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Ord.m3                                                
 Last Modified On Tue May  3 16:32:32 PDT 1994 By kalsow     
      Modified On Sat Dec  8 00:54:19 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Ord.i3">Ord</A></implements></module>;

IMPORT <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../misc/Error.i3">Error</A>;
IMPORT <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../exprs/EnumExpr.i3">EnumExpr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  &lt;*UNUSED*&gt; VAR cs: Expr.CheckState) =
  VAR t: Type.T;
  BEGIN
    t := Expr.TypeOf (ce.args[0]);
    IF NOT Type.IsOrdinal (t) THEN
      Error.Msg (&quot;ORD: argument must be an ordinal&quot;);
    END;
    ce.type := Int.T;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.Compile (ce.args[0]);
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e: Expr.T;  i: Target.Int;  t: Type.T;
  BEGIN
    e := Expr.ConstValue (ce.args[0]);
    IF (e = NIL) THEN
      RETURN NIL;
    ELSIF EnumExpr.Split (e, i, t) THEN
      RETURN IntegerExpr.New (i);
    ELSIF IntegerExpr.Split (e, i) THEN
      RETURN IntegerExpr.New (i);
    ELSE
      RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;ORD&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Ord.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
