<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Subarray.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Subarray.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Subarray.m3                                           
 Last Modified On Wed Jun 29 17:03:23 PDT 1994 By kalsow     
      Modified On Thu Mar  7 20:18:53 1991 By muller         

<P><PRE>MODULE <module><implements><A HREF="Subarray.i3">Subarray</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/ArrayType.i3">ArrayType</A>, <A HREF="#x1">Card</A>;
IMPORT <A HREF="../types/OpenArrayType.i3">OpenArrayType</A>, <A HREF="../exprs/CheckExpr.i3">CheckExpr</A>, <A HREF="../misc/Host.i3">Host</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (ce: CallExpr.T): Type.T =
  BEGIN
    RETURN ArrayType.OpenCousin (Type.Base (Expr.TypeOf (ce.args[0])));
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR t, u, v, index, elt: Type.T;  info: Type.Info;
  BEGIN
    t := Type.Base (Expr.TypeOf (ce.args[0]));
    u := Expr.TypeOf (ce.args[1]);
    v := Expr.TypeOf (ce.args[2]);
    IF (NOT ArrayType.Split (t, index, elt)) THEN
      Error.Msg (&quot;SUBARRAY: first argument must be an array&quot;);
    ELSIF (NOT Type.IsAssignable (Card.T, u)) THEN
      Error.Msg (&quot;SUBARRAY: second argrment must be assignable to CARDINAL&quot;);
    ELSIF (NOT Type.IsAssignable (Card.T, v)) THEN
      Error.Msg (&quot;SUBARRAY: third argument must be assignable to CARDINAL&quot;);
    ELSE
      elt := Type.CheckInfo (elt, info);
      IF (info.class # Type.Class.OpenArray)
        AND (info.size MOD Target.Byte) # 0 THEN
        Error.Msg (&quot;SUBARRAY: array elements are not byte-aligned.&quot;);
      END;
      ce.args[1] := CheckPositive (ce.args[1], cs);
      ce.args[2] := CheckPositive (ce.args[2], cs);
    END;
    Expr.NeedsAddress (ce.args[0]);
    t := ArrayType.OpenCousin (t);
    ce.type := Type.Check (t);
    INC (cs.int_ops);
  END Check;

PROCEDURE <A NAME="CheckPositive"><procedure>CheckPositive</procedure></A> (e: Expr.T;  VAR cs: Expr.CheckState): Expr.T =
  VAR min, max: Target.Int;
  BEGIN
    Expr.GetBounds (e, min, max);
    IF TInt.LT (min, TInt.Zero) OR TInt.LT (max, min) THEN
      e := CheckExpr.NewLower (e, TInt.Zero);
      Expr.TypeCheck (e, cs);
    END;
    RETURN e;
  END CheckPositive;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (&lt;*UNUSED*&gt; ce: CallExpr.T) =
  BEGIN
    (* yes, all subarray's get memory addresses *)
  END NeedsAddress;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  VAR
    base      := ce.args[0];
    start     := ce.args[1];
    len       := ce.args[2];
    array     := Type.Base (Expr.TypeOf (base));
    open      := ArrayType.OpenCousin (array);
    src_depth := OpenArrayType.OpenDepth (array);
    elt_pack  := ArrayType.EltPack (array);

    index, element: Type.T;
    t_result: CG.Var;
    t_base, t_start: CG.Val;
    i_start, i_len : INTEGER;
    case: [0..7];
    n_elts, x_len, x_start, max: Target.Int;
  BEGIN
    Type.Compile (array);
    Type.Compile (open);
    EVAL ArrayType.Split (array, index, element);

    Expr.PrepLValue (base);

    (* determine which case to use *)
    case := 0;
    IF (src_depth # 0)
      THEN case := 4;
      ELSE n_elts := Type.Number (index);
    END;
    IF GetCard (start, i_start, x_start)
      THEN INC (case, 2);
      ELSE Expr.Prep (start);
    END;
    IF GetCard (len,   i_len,   x_len)
      THEN INC (case, 1);
      ELSE Expr.Prep (len);
    END;

    (* declare space for the result *)
    t_result := OpenArrayType.DeclareTemp (open);

    CASE case OF
    | 0 =&gt;  (* fixed array, var start, var len ------------------------------*)

          (* initialize the new count *)
          Expr.Compile (len);
          CG.Store_int (t_result, M3RT.OA_size_0);

          IF NOT Host.doRangeChk THEN
            Expr.CompileAddress (base);
            Expr.Compile (start);
          ELSE
            Expr.Compile (start);         t_start := CG.Pop ();
            CG.Push (t_start);
            CG.Load_int (t_result, M3RT.OA_size_0);
            CG.Add (CG.Type.Int);
            CG.Check_hi (n_elts);
            CG.Discard (CG.Type.Int);
            Expr.CompileAddress (base);
            CG.Push (t_start);
            CG.Free (t_start);
          END;

          (* initialize the new data pointer *)
          CG.Index_bytes (elt_pack);
          CG.Store_addr (t_result, M3RT.OA_elt_ptr);

    | 1 =&gt;  (* fixed array, var start, const len ----------------------------*)

          (* initialize the new count *)
          CG.Load_integer (x_len);
          CG.Store_int (t_result, M3RT.OA_size_0);

          IF NOT Host.doRangeChk THEN
            Expr.CompileAddress (base);
            Expr.Compile (start);
          ELSIF NOT TInt.Subtract (n_elts, x_len, max) THEN
            (* cannot compute n-len at compile time *)
           Expr.Compile (start);         t_start := CG.Pop ();
            CG.Push (t_start);
            CG.Load_integer (x_len);
            CG.Add (CG.Type.Int);
            CG.Check_hi (n_elts);
           CG.Discard (CG.Type.Int);
            Expr.CompileAddress (base);
            CG.Push (t_start);
            CG.Free (t_start);
          ELSIF TInt.LT (max, TInt.Zero) THEN
            Error.Warn (2, &quot;SUBARRAY length out of range&quot;);
            Expr.CompileAddress (base);
            Expr.Compile (start);
            CG.Check_hi (max);
          ELSE
            Expr.CompileAddress (base);
            Expr.Compile (start);
            CG.Check_hi (max);
          END;

          (* initialize the new data pointer *)
          CG.Index_bytes (elt_pack);
          CG.Store_addr (t_result, M3RT.OA_elt_ptr);

    | 2 =&gt;  (* fixed array, const start, var len ----------------------------*)

          IF NOT Host.doRangeChk THEN
            (* no check =&gt; initialize the new count *)
            Expr.Compile (len);
            CG.Store_int (t_result, M3RT.OA_size_0);
          ELSIF NOT TInt.Subtract (n_elts, x_start, max) THEN
            (* initialize the new count *)
            Expr.Compile (len);
            CG.Store_int (t_result, M3RT.OA_size_0);
            (* cannot compute n-start at compile time *)
            CG.Load_int (t_result, M3RT.OA_size_0);
            CG.Load_integer (x_start);
            CG.Add (CG.Type.Int);
            CG.Check_hi (n_elts);
            CG.Discard (CG.Type.Int);
          ELSIF TInt.LT (max, TInt.Zero) THEN
            (* initialize and check the new count *)
            Error.Warn (2, &quot;SUBARRAY initial index out of range&quot;);
            Expr.Compile (len);
            CG.Check_hi (max);
            CG.Store_int (t_result, M3RT.OA_size_0);
          ELSE
            (* initialize and check the new count *)
            Expr.Compile (len);
            CG.Check_hi (max);
            CG.Store_int (t_result, M3RT.OA_size_0);
          END;

          (* initialize the new data pointer *)
          Expr.CompileAddress (base);
          CG.Add_offset (i_start * elt_pack);
          CG.Store_addr (t_result, M3RT.OA_elt_ptr);

    | 3 =&gt;  (* fixed array, const start, const len --------------------------*)

          (* initialize the new count *)
          CG.Load_integer (x_len);
          CG.Store_int (t_result, M3RT.OA_size_0);

          IF NOT Host.doRangeChk THEN
            (* no check *)
          ELSIF NOT TInt.Add (x_start, x_len, max) THEN
            (* cannot compute start+len at compile time *)
            CG.Load_integer (x_start);
            CG.Load_integer (x_len);
            CG.Add (CG.Type.Int);
            CG.Check_hi (n_elts);
            CG.Discard (CG.Type.Int);
          ELSIF TInt.LT (n_elts, max) THEN
            (* oops, they're too big *)
            Error.Warn (2, &quot;SUBARRAY start+length out of range&quot;);
            CG.Load_integer (max);
            CG.Check_hi (n_elts);
            CG.Discard (CG.Type.Int);
          ELSE
            (* ok *)
          END;

          (* initialize the new data pointer *)
          Expr.CompileAddress (base);
          CG.Add_offset (i_start * elt_pack);
          CG.Store_addr (t_result, M3RT.OA_elt_ptr);

    | 4 =&gt;  (* open array, var start, var len -------------------------------*)

          Expr.CompileAddress (base);   t_base  := CG.Pop ();
          Expr.Compile (start);         t_start := CG.Pop ();

          (* initialize the new counts *)
          Expr.Compile (len);
          CG.Store_int (t_result, M3RT.OA_size_0);
          CopyDopeVector (t_base, t_result, src_depth);

          IF Host.doRangeChk THEN
            CG.Push (t_start);
            CG.Load_int (t_result, M3RT.OA_size_0);
            CG.Add (CG.Type.Int);
            CG.Push (t_base);
            CG.Open_size (0);
            CG.Subtract (CG.Type.Int);
            CG.Check_hi (TInt.Zero);
            CG.Discard (CG.Type.Int);
          END;

          (* initialize the new data pointer *)
          CG.Push (t_base);
          CG.Open_elt_ptr (ArrayType.EltAlign (array));
          CG.Push (t_start);
          ComputeOffset (t_result, src_depth, elt_pack);

          CG.Free (t_base);
          CG.Free (t_start);

    | 5 =&gt;  (* open array, var start, const len -----------------------------*)

          Expr.CompileAddress (base);   t_base  := CG.Pop ();
          Expr.Compile (start);         t_start := CG.Pop ();

          (* initialize the new counts *)
          CG.Load_integer (x_len);
          CG.Store_int (t_result, M3RT.OA_size_0);
          CopyDopeVector (t_base, t_result, src_depth);

          IF Host.doRangeChk THEN
            CG.Push (t_start);
            CG.Load_integer (x_len);
            CG.Add (CG.Type.Int);
            CG.Push (t_base);
            CG.Open_size (0);
            CG.Subtract (CG.Type.Int);
            CG.Check_hi (TInt.Zero);
            CG.Discard (CG.Type.Int);
          END;

          (* initialize the new data pointer *)
          CG.Push (t_base);
          CG.Open_elt_ptr (ArrayType.EltAlign (array));
          CG.Push (t_start);
          ComputeOffset (t_result, src_depth, elt_pack);

          CG.Free (t_base);
          CG.Free (t_start);

    | 6 =&gt;  (* open array, const start, var len -----------------------------*)

          Expr.CompileAddress (base);   t_base  := CG.Pop ();

          (* initialize the new counts *)
          Expr.Compile (len);
          CG.Store_int (t_result, M3RT.OA_size_0);
          CopyDopeVector (t_base, t_result, src_depth);

          IF Host.doRangeChk THEN
            CG.Load_int (t_result, M3RT.OA_size_0);
            CG.Load_integer (x_start);
            CG.Add (CG.Type.Int);
            CG.Push (t_base);
            CG.Open_size (0);
            CG.Subtract (CG.Type.Int);
            CG.Check_hi (TInt.Zero);
            CG.Discard (CG.Type.Int);
          END;

          (* initialize the new data pointer *)
          CG.Push (t_base);
          CG.Open_elt_ptr (ArrayType.EltAlign (array));
          IF (src_depth &lt;= 1) THEN
            CG.Add_offset (i_start * elt_pack);
            CG.Store_addr (t_result, M3RT.OA_elt_ptr);
          ELSE
            CG.Load_integer (x_start);
            ComputeOffset (t_result, src_depth, elt_pack);
          END;

          CG.Free (t_base);

    | 7 =&gt;  (* open array, const start, const len ---------------------------*)

          Expr.CompileAddress (base);   t_base  := CG.Pop ();

          (* initialize the new counts *)
          CG.Load_integer (x_len);
          CG.Store_int (t_result, M3RT.OA_size_0);
          CopyDopeVector (t_base, t_result, src_depth);

          IF NOT Host.doRangeChk THEN
            (* no check *)
          ELSIF TInt.Add (x_start, x_len, max) THEN
            CG.Load_integer (max);
            CG.Push (t_base);
            CG.Open_size (0);
            CG.Subtract (CG.Type.Int);
            CG.Check_hi (TInt.Zero);
            CG.Discard (CG.Type.Int);
          ELSE
            CG.Load_integer (x_start);
            CG.Load_integer (x_len);
            CG.Add (CG.Type.Int);
            CG.Push (t_base);
            CG.Open_size (0);
            CG.Subtract (CG.Type.Int);
            CG.Check_hi (TInt.Zero);
            CG.Discard (CG.Type.Int);
          END;

          (* initialize the new data pointer *)
          CG.Push (t_base);
          CG.Open_elt_ptr (ArrayType.EltAlign (array));
          IF (src_depth &lt;= 1) THEN
            CG.Add_offset (i_start * elt_pack);
            CG.Store_addr (t_result, M3RT.OA_elt_ptr);
          ELSE
            CG.Load_integer (x_start);
            ComputeOffset (t_result, src_depth, elt_pack);
          END;

          CG.Free (t_base);

    END; (* CASE *)

    (* leave the new subarray as the result. *)
    CG.Load_addr_of_temp (t_result, 0, Target.Address.align);
    ce.tmp := CG.Pop ();

  END Prep;

PROCEDURE <A NAME="GetCard"><procedure>GetCard</procedure></A> (e: Expr.T;  VAR i: INTEGER;  VAR x: Target.Int): BOOLEAN =
  BEGIN
    e := Expr.ConstValue (e);
    IF (e = NIL) THEN RETURN FALSE END;
    RETURN IntegerExpr.Split (e, x)
       AND TInt.ToInt (x, i)
       AND (0 &lt;= i);
  END GetCard;

PROCEDURE <A NAME="CopyDopeVector"><procedure>CopyDopeVector</procedure></A> (src: CG.Val;  dest: CG.Var;  depth: INTEGER) =
  BEGIN
    FOR i := 1 TO depth - 1 DO
      CG.Push (src);
      CG.Open_size (i);
      CG.Store_int (dest, M3RT.OA_sizes + i * Target.Integer.pack);
    END;
  END CopyDopeVector;

PROCEDURE <A NAME="ComputeOffset"><procedure>ComputeOffset</procedure></A> (array: CG.Var;  depth, elt_pack: INTEGER) =
  BEGIN
    FOR i := 1 TO depth - 1 DO
      CG.Load_int (array, M3RT.OA_sizes + i * Target.Integer.pack);
      CG.Multiply (CG.Type.Int);
    END;
    CG.Index_bytes (elt_pack);
    CG.Store_addr (array, M3RT.OA_elt_ptr);
  END ComputeOffset;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    (* all the real work was done by Prep *)
    CG.Push (ce.tmp);
    CG.Boost_alignment (Target.Address.align);
    CG.Free (ce.tmp);
    ce.tmp := NIL;
  END Compile;

PROCEDURE <A NAME="IsWritable"><procedure>IsWritable</procedure></A> (ce: CallExpr.T): BOOLEAN =
  BEGIN
    RETURN Expr.IsWritable (ce.args[0]);
  END IsWritable;

PROCEDURE <A NAME="IsDesignator"><procedure>IsDesignator</procedure></A> (ce: CallExpr.T): BOOLEAN =
  BEGIN
    RETURN Expr.IsDesignator (ce.args[0]);
  END IsDesignator;

PROCEDURE <A NAME="NoteWrites"><procedure>NoteWrites</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.NoteWrite (ce.args[0]);
  END NoteWrites;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (3, 3, TRUE, FALSE, TRUE, NIL,
                                 TypeOf,
                                 NeedsAddress,
                                 Check,
                                 Prep,
                                 Compile,
                                 Prep,
                                 Compile,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 CallExpr.NoValue, (* fold *)
                                 IsWritable,
                                 IsDesignator,
                                 NoteWrites);
    Procedure.Define (&quot;SUBARRAY&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Subarray.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Card is in:
</A><UL>
<LI><A HREF="../../../bicycle/src/Card.i3#0TOP0">bicycle/src/Card.i3</A>
<LI><A HREF="../builtinTypes/Card.i3#0TOP0">m3front/src/builtinTypes/Card.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
