<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Trunc.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Trunc.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Trunc.m3                                              
 Last Modified On Mon Sep 26 09:15:50 PDT 1994 By kalsow     
      Modified On Tue Apr 10 10:57:52 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Trunc.i3">Trunc</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="Ceiling.i3">Ceiling</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../exprs/ReelExpr.i3">ReelExpr</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    Ceiling.DoCheck (&quot;TRUNC&quot;, ce, cs);
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR e := ce.args[0];
  BEGIN
    Expr.Compile (e);
    CG.Trunc (Type.CGType (Expr.TypeOf (e)));
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e, x: Expr.T;
  BEGIN
    e := Expr.ConstValue (ce.args[0]);
    IF    (e = NIL)             THEN RETURN NIL
    ELSIF ReelExpr.Trunc (e, x) THEN RETURN x;
    ELSE (* bogus *)                 RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;TRUNC&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Trunc.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
