<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Typecode.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Typecode.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Typecode.m3                                           
 Last Modified On Tue May  3 16:33:20 PDT 1994 By kalsow     
      Modified On Fri Mar 15 03:50:01 1991 By muller         

<P><PRE>MODULE <module><implements><A HREF="Typecode.i3">Typecode</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="#x1">Card</A>, <A HREF="../misc/Error.i3">Error</A>;
IMPORT <A HREF="../builtinTypes/Reff.i3">Reff</A>, <A HREF="../exprs/TypeExpr.i3">TypeExpr</A>, <A HREF="../types/ObjectType.i3">ObjectType</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  &lt;*UNUSED*&gt; VAR cs: Expr.CheckState) =
  VAR t: Type.T;
  BEGIN
    IF TypeExpr.Split (ce.args[0], t) THEN
      IF (ObjectType.Is (t)) THEN
        (* ok *)
      ELSIF (Type.IsEqual (t, Reff.T, NIL)) THEN
        Error.Msg (&quot;TYPECODE: T must be a fixed reference type&quot;);
      ELSIF (NOT Type.IsSubtype (t, Reff.T)) THEN
        Error.Msg (&quot;TYPECODE: T must be a traced reference type&quot;);
      END;
    ELSE
      t := Expr.TypeOf (ce.args[0]);
      IF NOT Type.IsSubtype (t, Reff.T) AND NOT ObjectType.Is (t) THEN
        Error.Msg (&quot;TYPECODE: r must be a traced reference or object&quot;);
      END;
    END;
    ce.type := Card.T;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  VAR e := ce.args[0];  t: Type.T;  nil: CG.Label;
  BEGIN
    IF TypeExpr.Split (e, t) THEN
      (* get the typecode from the typecell *)
    ELSE
      (* get the typecode from the REF's header *)
      Expr.Prep (e);
      Expr.Compile (e);
      ce.tmp := CG.Pop_temp ();
      nil := CG.Next_label ();
      CG.Push (ce.tmp);
      CG.Load_nil ();
      CG.If_eq (nil, CG.Type.Addr, CG.Never);
      CG.Push (ce.tmp);
      CG.Ref_to_typecode ();
      CG.Loophole (CG.Type.Int, CG.Type.Addr);
      CG.Store_temp (ce.tmp);
      CG.Set_label (nil);
    END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR e := ce.args[0];  t: Type.T;
  BEGIN
    IF TypeExpr.Split (e, t) THEN
      (* get the typecode from the typecell *)
      Type.Compile (t);
      Type.LoadInfo (t, M3RT.TC_typecode);
    ELSE
      (* get the typecode from the REF's header *)
      CG.Push (ce.tmp);
      CG.Loophole (CG.Type.Addr, CG.Type.Int);
      CG.Free (ce.tmp);
      ce.tmp := NIL;
    END;
  END Compile;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, TRUE, Card.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 CallExpr.NoValue, (* fold *)
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;TYPECODE&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Typecode.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Card is in:
</A><UL>
<LI><A HREF="../../../bicycle/src/Card.i3#0TOP0">bicycle/src/Card.i3</A>
<LI><A HREF="../builtinTypes/Card.i3#0TOP0">m3front/src/builtinTypes/Card.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
