<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinTypes/Bool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinTypes/Bool.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Bool.m3                                               
 Last Modified On Fri Jun 24 09:42:58 PDT 1994 By kalsow     
      Modified On Mon Nov 27 15:21:12 1989 By muller         

<P><PRE>MODULE <module><implements><A HREF="Bool.i3">Bool</A></implements></module>;

IMPORT <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../types/EnumType.i3">EnumType</A>, <A HREF="../values/EnumElt.i3">EnumElt</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../misc/M3.i3">M3</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../values/Tipe.i3">Tipe</A>, <A HREF="../values/Constant.i3">Constant</A>, <A HREF="../exprs/EnumExpr.i3">EnumExpr</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  VAR elts: Scope.T;  cs := M3.OuterCheckState;  true, false: Expr.T;
  BEGIN
    elts := Scope.PushNew (FALSE, M3ID.Add (&quot;BOOLEAN&quot;));
    T := EnumType.New (2, elts);

    False := EnumElt.New (M3ID.Add (&quot;FALSE&quot;), TInt.Zero, T);
    Scope.Insert (False);

    True := EnumElt.New (M3ID.Add (&quot;TRUE&quot;), TInt.One, T);
    Scope.Insert (True);

    Scope.PopNew ();
    Scope.TypeCheck (elts, cs);
    Tipe.Define (&quot;BOOLEAN&quot;, T, TRUE);

    false := EnumExpr.New (T, TInt.Zero);
    true  := EnumExpr.New (T, TInt.One);

    Constant.Declare (&quot;FALSE&quot;, false, TRUE);
    Constant.Declare (&quot;TRUE&quot;, true, TRUE);

    Map[FALSE] := false;
    Map[TRUE] := true;
  END Initialize;

BEGIN
END Bool.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
