<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinTypes/EReel.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinTypes/EReel.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: EReel.m3                                              
 Last Modified On Wed Sep  7 15:35:49 PDT 1994 by kalsow     
      Modified On Wed Sep 26 18:57:30 1990 by muller         

<P><PRE>MODULE <module><implements><A HREF="EReel.i3">EReel</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../values/Tipe.i3">Tipe</A>, <A HREF="../types/TypeRep.i3">TypeRep</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../misc/TipeMap.i3">TipeMap</A>, <A HREF="../misc/TipeDesc.i3">TipeDesc</A>;

TYPE
  P = Type.T BRANDED &quot;EReel.T&quot; OBJECT
      OVERRIDES
        check      := Check;
        check_align:= TypeRep.ScalarAlign;
        isEqual    := TypeRep.NeverEqual;
        isSubtype  := TypeRep.NoSubtypes;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := TypeRep.InitToZeros;
        mapper     := GenMap;
        gen_desc   := GenDesc;
        fprint     := FPrinter;
      END;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P) =
  BEGIN
    p.info.size      := Target.Extended.size;
    p.info.min_size  := Target.Extended.size;
    p.info.alignment := Target.Extended.align;
    p.info.cg_type   := CG.Type.XReel;
    p.info.class     := Type.Class.Extended;
    p.info.isTraced  := FALSE;
    p.info.isEmpty   := FALSE;
    p.info.isSolid   := TRUE;
    p.info.hash      := 3;
  END Check;

PROCEDURE <A NAME="Compiler"><procedure>Compiler</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
  END Compiler;

PROCEDURE <A NAME="InitCoster"><procedure>InitCoster</procedure></A> (&lt;*UNUSED*&gt; t: Type.T; zeroed: BOOLEAN): INTEGER =
  BEGIN
    (* not every bit pattern is a legal EXTENDED *)
    IF zeroed OR Target.All_floats_legal THEN RETURN 0 ELSE RETURN 1 END;
  END InitCoster;

PROCEDURE <A NAME="FPrinter"><procedure>FPrinter</procedure></A> (&lt;*UNUSED*&gt;t: Type.T;  VAR x: M3.FPInfo) =
  BEGIN
    x.tag := &quot;$extended&quot;;
    x.n_nodes := 0;
  END FPrinter;

PROCEDURE <A NAME="GenMap"><procedure>GenMap</procedure></A> (&lt;*UNUSED*&gt; p: P; offset, size: INTEGER; refs_only: BOOLEAN) =
  BEGIN
    &lt;*ASSERT size = Target.Extended.size*&gt;
    IF NOT refs_only THEN
      TipeMap.Add (offset, TipeMap.Op.Extended, 0);
    END;
  END GenMap;

PROCEDURE <A NAME="GenDesc"><procedure>GenDesc</procedure></A> (p: P) =
  BEGIN
    EVAL TipeDesc.AddO (TipeDesc.Op.Extended, p);
  END GenDesc;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    T := NEW (P);
    TypeRep.Init (T, Type.Class.Extended);
    Tipe.Define (&quot;EXTENDED&quot;, T, TRUE);
  END Initialize;

BEGIN
END EReel.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
