<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinTypes/ErrType.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinTypes/ErrType.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ErrType.m3                                            
 Last Modified On Wed Sep  7 15:34:54 PDT 1994 by kalsow     
      Modified On Thu Dec  5 17:24:02 PST 1991 by muller     

<P><PRE>MODULE <module><implements><A HREF="ErrType.i3">ErrType</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../types/TypeRep.i3">TypeRep</A>, <A HREF="../values/Tipe.i3">Tipe</A>, <A HREF="../misc/CG.i3">CG</A>;

TYPE
  P = Type.T BRANDED &quot;ErrType.T&quot; OBJECT
      OVERRIDES
        check      := Check;
        check_align:= TypeRep.ScalarAlign;
        isEqual    := TypeRep.NeverEqual;
        isSubtype  := TypeRep.NoSubtypes;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := TypeRep.InitToZeros;
        mapper     := GenMap;
        gen_desc   := GenDesc;
        fprint     := FPrinter;
      END;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P) =
  BEGIN
    p.info.size      := 0;
    p.info.min_size  := 0;
    p.info.alignment := 1;
    p.info.cg_type   := CG.Type.Addr;
    p.info.class     := Type.Class.Error;
    p.info.isTraced  := FALSE;
    p.info.isEmpty   := FALSE;
    p.info.isSolid   := TRUE;
    p.info.hash      := 4;
  END Check;

PROCEDURE <A NAME="Compiler"><procedure>Compiler</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
  END Compiler;

PROCEDURE <A NAME="InitCoster"><procedure>InitCoster</procedure></A> (&lt;*UNUSED*&gt; t: Type.T;
                      &lt;*UNUSED*&gt; zeroed: BOOLEAN): INTEGER =
  BEGIN
    RETURN 0;
  END InitCoster;

PROCEDURE <A NAME="FPrinter"><procedure>FPrinter</procedure></A> (&lt;*UNUSED*&gt;t: Type.T;  VAR x: M3.FPInfo) =
  BEGIN
    x.tag := &quot;$ErrType&quot;;
    x.n_nodes := 0;
  END FPrinter;

PROCEDURE <A NAME="GenMap"><procedure>GenMap</procedure></A> (&lt;*UNUSED*&gt; p: P;
                  &lt;*UNUSED*&gt; offset, size: INTEGER;
                  &lt;*UNUSED*&gt; refs_only: BOOLEAN) =
  BEGIN
    (* generate nothing *)
  END GenMap;

PROCEDURE <A NAME="GenDesc"><procedure>GenDesc</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
    (* generate nothing *)
  END GenDesc;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    T := NEW (P);
    TypeRep.Init (T, Type.Class.Error);
    Tipe.Define (&quot;_ERROR&quot;, T, FALSE);
  END Initialize;

BEGIN
END ErrType.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
