<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinTypes/Int.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinTypes/Int.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Int.m3                                                
 Last Modified On Wed Sep  7 15:35:03 PDT 1994 by kalsow     
      Modified On Fri Dec 21 01:48:33 1990 by muller         

<P><PRE>MODULE <module><implements><A HREF="Int.i3">Int</A></implements></module>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../values/Tipe.i3">Tipe</A>, <A HREF="../types/TypeRep.i3">TypeRep</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../misc/TipeMap.i3">TipeMap</A>, <A HREF="../misc/TipeDesc.i3">TipeDesc</A>;

TYPE
  P = Type.T BRANDED &quot;Int.T&quot; OBJECT
      OVERRIDES
        check      := Check;
        check_align:= TypeRep.ScalarAlign;
        isEqual    := TypeRep.NeverEqual;
        isSubtype  := TypeRep.NoSubtypes;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := TypeRep.InitToZeros;
        mapper     := GenMap;
        gen_desc   := GenDesc;
        fprint     := FPrinter;
      END;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P) =
  BEGIN
    p.info.size      := Target.Integer.size;
    p.info.min_size  := Target.Integer.size;
    p.info.alignment := Target.Integer.align;
    p.info.cg_type   := CG.Type.Int;
    p.info.class     := Type.Class.Integer;
    p.info.isTraced  := FALSE;
    p.info.isEmpty   := FALSE;
    p.info.isSolid   := TRUE;
    p.info.hash      := 5;
  END Check;

PROCEDURE <A NAME="Compiler"><procedure>Compiler</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
  END Compiler;

PROCEDURE <A NAME="InitCoster"><procedure>InitCoster</procedure></A> (&lt;*UNUSED*&gt; t: Type.T;
                      &lt;*UNUSED*&gt; zeroed: BOOLEAN): INTEGER =
  BEGIN
    RETURN 0;
  END InitCoster;

PROCEDURE <A NAME="FPrinter"><procedure>FPrinter</procedure></A> (&lt;*UNUSED*&gt; t: Type.T;  VAR x: M3.FPInfo) =
  BEGIN
    x.tag := &quot;$integer&quot;;
    x.n_nodes := 0;
  END FPrinter;

PROCEDURE <A NAME="GenMap"><procedure>GenMap</procedure></A> (&lt;*UNUSED*&gt; p: P; offset, size: INTEGER; refs_only: BOOLEAN) =
  VAR IntBytes := Target.Integer.bytes;
  BEGIN
    &lt;*ASSERT size = Target.Integer.size*&gt;
    IF    (refs_only)    THEN (* skip *)
    ELSIF (IntBytes = 4) THEN TipeMap.Add (offset, TipeMap.Op.Int_4, 0);
    ELSIF (IntBytes = 8) THEN TipeMap.Add (offset, TipeMap.Op.Int_8, 0);
    ELSIF (IntBytes = 2) THEN TipeMap.Add (offset, TipeMap.Op.Int_2, 0);
    ELSIF (IntBytes = 1) THEN TipeMap.Add (offset, TipeMap.Op.Int_1, 0);
    ELSE  &lt;*ASSERT FALSE *&gt;
    END;
  END GenMap;

PROCEDURE <A NAME="GenDesc"><procedure>GenDesc</procedure></A> (p: P) =
  BEGIN
    EVAL TipeDesc.AddO (TipeDesc.Op.Integer, p);
  END GenDesc;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    T := NEW (P);
    TypeRep.Init (T, Type.Class.Integer);
    Tipe.Define (&quot;INTEGER&quot;, T, TRUE);
  END Initialize;

BEGIN
END Int.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
