<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinWord/WordExtract.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinWord/WordExtract.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: WordExtract.m3                                        
 Last Modified On Mon Dec  5 15:30:52 PST 1994 By kalsow     
      Modified On Thu Mar  7 20:19:39 1991 By muller         

<P><PRE>MODULE <module><implements><A HREF="WordExtract.i3">WordExtract</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../values/Procedure.i3">Procedure</A>;
IMPORT <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../types/ProcType.i3">ProcType</A>, <A HREF="../misc/Host.i3">Host</A>, <A HREF="#x1">Card</A>;
IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../../../m3middle/src/TWord.i3">TWord</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/Formal.i3">Formal</A>, <A HREF="../exprs/CheckExpr.i3">CheckExpr</A>, <A HREF="../misc/Error.i3">Error</A>;

VAR Z: CallExpr.MethodList;
VAR formals: Value.T;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    EVAL Formal.CheckArgs (cs, ce.args, formals, ce.proc);
    ce.type := Int.T;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR
    t1, t2: CG.Val;
    max: Target.Int;
    b, x1, x2: BOOLEAN;
    i1, i2: INTEGER;
  BEGIN
    x1 := GetBitIndex (ce.args[1], i1);
    x2 := GetBitIndex (ce.args[2], i2);

    IF x1 AND x2 THEN
      (* we can use the extract_mn operator *)
      IF (i1 + i2 &gt; Target.Integer.size) THEN
        Error.Warn (2, &quot;value out of range&quot;);
        CG.Load_integer (TInt.One);
        CG.Check_hi (TInt.Zero);
      ELSE
        Expr.Compile (ce.args[0]);
        CG.Extract_mn (FALSE, i1, i2);
      END;

    ELSIF x2 THEN
      (* we can use the extract_n operator *)
      b := TInt.FromInt (Target.Integer.size - i2, max); &lt;*ASSERT b*&gt;
      Expr.Compile (ce.args[0]);
      CheckExpr.Emit (ce.args[1], TInt.Zero, max);
      CG.Extract_n (FALSE, i2);

    ELSIF x1 THEN
      (* we need the general purpose extract operator, but can simplify
         the range checking code *)
      b := TInt.FromInt (Target.Integer.size - i1, max); &lt;*ASSERT b*&gt;
      Expr.Compile (ce.args[0]);
      CG.Force ();
      CG.Load_intt (i1);
      CheckExpr.Emit (ce.args[2], TInt.Zero, max);
      CG.Extract (sign := FALSE);

    ELSE
      (* we need the general purpose extract operator *)
      CheckExpr.Emit (ce.args[1], TInt.Zero, Target.Integer.max);
      t1 := CG.Pop ();
      CheckExpr.Emit (ce.args[2], TInt.Zero, Target.Integer.max);
      t2 := CG.Pop ();
      IF Host.doRangeChk THEN
        b := TInt.FromInt (Target.Integer.size, max); &lt;*ASSERT b*&gt;
        CG.Push (t1);
        CG.Push (t2);
        CG.Add (CG.Type.Int);
        CG.Check_hi (max);
        CG.Discard (CG.Type.Int);
      END;
      Expr.Compile (ce.args[0]);
      CG.Force ();
      CG.Push (t1);
      CG.Push (t2);
      CG.Extract (sign := FALSE);
      CG.Free (t1);
      CG.Free (t2);
    END;
  END Compile;

PROCEDURE <A NAME="GetBitIndex"><procedure>GetBitIndex</procedure></A> (e: Expr.T;  VAR i: INTEGER): BOOLEAN =
  VAR x: Target.Int;
  BEGIN
    e := Expr.ConstValue (e);
    IF (e = NIL) THEN RETURN FALSE END;
    RETURN IntegerExpr.Split (e, x)
       AND TInt.ToInt (x, i)
       AND (0 &lt;= i) AND (i &lt;= Target.Integer.size);
  END GetBitIndex;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e0, e1, e2: Expr.T;  w0, i1, i2, result: Target.Int;
  BEGIN
    e0 := Expr.ConstValue (ce.args[0]);
    e1 := Expr.ConstValue (ce.args[1]);
    e2 := Expr.ConstValue (ce.args[2]);
    IF (e0 = NIL) OR (NOT IntegerExpr.Split (e0, w0)) OR
       (e1 = NIL) OR (NOT IntegerExpr.Split (e1, i1)) OR
       (e2 = NIL) OR (NOT IntegerExpr.Split (e2, i2)) OR
       NOT TWord.Extract (w0, i1, i2, result) THEN
      RETURN NIL;
    END;
    RETURN IntegerExpr.New (result);
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  VAR
    f0 := Formal.NewBuiltin (&quot;x&quot;, 0, Int.T);
    f1 := Formal.NewBuiltin (&quot;i&quot;, 1, Card.T);
    f2 := Formal.NewBuiltin (&quot;n&quot;, 2, Card.T);
    t  := ProcType.New (Int.T, f0, f1, f2);
  BEGIN
    Z := CallExpr.NewMethodList (3, 3, TRUE, TRUE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;Extract&quot;, Z, FALSE, t);
    formals := ProcType.Formals (t);
  END Initialize;

BEGIN
END WordExtract.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Card is in:
</A><UL>
<LI><A HREF="../../../bicycle/src/Card.i3#0TOP0">bicycle/src/Card.i3</A>
<LI><A HREF="../builtinTypes/Card.i3#0TOP0">m3front/src/builtinTypes/Card.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
