<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinWord/WordGE.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinWord/WordGE.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: WordGE.m3                                             
 Last Modified On Mon Dec  5 15:30:52 PST 1994 By kalsow     
      Modified On Tue Apr 10 11:10:31 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="WordGE.i3">WordGE</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TWord.i3">TWord</A>;
IMPORT <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../builtinTypes/Bool.i3">Bool</A>, <A HREF="WordPlus.i3">WordPlus</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/Formal.i3">Formal</A>, <A HREF="../types/ProcType.i3">ProcType</A>;

VAR Z: CallExpr.MethodList;
VAR formals: Value.T;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    EVAL Formal.CheckArgs (cs, ce.args, formals, ce.proc);
    ce.type := Bool.T;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.Compile (ce.args[0]);
    Expr.Compile (ce.args[1]);
    CG.Ge (CG.Type.Word);
  END Compile;

PROCEDURE <A NAME="PrepBR"><procedure>PrepBR</procedure></A> (ce: CallExpr.T;  true, false: CG.Label;  freq: CG.Frequency)=
  BEGIN
    Expr.Prep (ce.args[0]);
    Expr.Prep (ce.args[1]);
    Expr.Compile (ce.args[0]);
    Expr.Compile (ce.args[1]);
    IF (true # CG.No_label)
      THEN CG.If_ge (true, CG.Type.Word, freq);
      ELSE CG.If_lt (false, CG.Type.Word, freq);
    END;
  END PrepBR;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR w0, w1: Target.Int;
  BEGIN
    IF WordPlus.GetArgs (ce.args, w0, w1)
      THEN RETURN Bool.Map [TWord.LE (w1, w0)];
      ELSE RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  VAR
    x1 := Formal.NewBuiltin (&quot;x&quot;, 0, Int.T);
    y1 := Formal.NewBuiltin (&quot;y&quot;, 1, Int.T);
    t1 := ProcType.New (Bool.T, x1, y1);
  BEGIN
    Z := CallExpr.NewMethodList (2, 2, TRUE, TRUE, TRUE, Bool.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 PrepBR,
                                 CallExpr.NoBranch,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;GE&quot;, Z, FALSE, t1);
    formals := ProcType.Formals (t1);
  END Initialize;

BEGIN
END WordGE.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
