<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinWord/WordInsert.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinWord/WordInsert.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: WordInsert.m3                                         
 Last Modified On Mon Dec  5 15:30:50 PST 1994 By kalsow     
      Modified On Thu Mar  7 20:20:02 1991 By muller         

<P><PRE>MODULE <module><implements><A HREF="WordInsert.i3">WordInsert</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../values/Procedure.i3">Procedure</A>;
IMPORT <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../types/ProcType.i3">ProcType</A>, <A HREF="../exprs/CheckExpr.i3">CheckExpr</A>, <A HREF="#x1">Card</A>;
IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../../../m3middle/src/TWord.i3">TWord</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/Formal.i3">Formal</A>, <A HREF="../misc/Host.i3">Host</A>;

VAR Z: CallExpr.MethodList;
VAR formals: Value.T;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    EVAL Formal.CheckArgs (cs, ce.args, formals, ce.proc);
    ce.type := Int.T;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR t2, t3: CG.Val;  b: BOOLEAN;  max: Target.Int;
  BEGIN
    CheckExpr.Emit (ce.args[2], TInt.Zero, Target.Integer.max);
    t2 := CG.Pop ();
    CheckExpr.Emit (ce.args[3], TInt.Zero, Target.Integer.max);
    t3 := CG.Pop ();
    IF Host.doRangeChk THEN
      b := TInt.FromInt (Target.Integer.size, max);  &lt;*ASSERT b*&gt;
      CG.Push (t2);
      CG.Push (t3);
      CG.Add (CG.Type.Int);
      CG.Check_hi (max);
      CG.Discard (CG.Type.Int);
    END;
    Expr.Compile (ce.args[0]);
    CG.Force ();
    Expr.Compile (ce.args[1]);
    CG.Force ();
    CG.Push (t2);
    CG.Push (t3);
    CG.Insert ();
    CG.Free (t2);
    CG.Free (t3);
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e0, e1, e2, e3: Expr.T;  w0, w1, i2, i3, result: Target.Int;
  BEGIN
    e0 := Expr.ConstValue (ce.args[0]);
    e1 := Expr.ConstValue (ce.args[1]);
    e2 := Expr.ConstValue (ce.args[2]);
    e3 := Expr.ConstValue (ce.args[3]);
    IF (e0 = NIL) OR (NOT IntegerExpr.Split (e0, w0)) OR
       (e1 = NIL) OR (NOT IntegerExpr.Split (e1, w1)) OR
       (e2 = NIL) OR (NOT IntegerExpr.Split (e2, i2)) OR
       (e3 = NIL) OR (NOT IntegerExpr.Split (e3, i3)) OR
       NOT TWord.Insert (w0, w1, i2, i3, result) THEN
      RETURN NIL;
    END;
    RETURN IntegerExpr.New (result);
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  VAR
    f0 := Formal.NewBuiltin (&quot;x&quot;, 0, Int.T);
    f1 := Formal.NewBuiltin (&quot;y&quot;, 1, Int.T);
    f2 := Formal.NewBuiltin (&quot;i&quot;, 2, Card.T);
    f3 := Formal.NewBuiltin (&quot;n&quot;, 3, Card.T);
    t  := ProcType.New (Int.T, f0, f1, f2, f3);
  BEGIN
    Z := CallExpr.NewMethodList (4, 4, TRUE, TRUE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;Insert&quot;, Z, FALSE, t);
    formals := ProcType.Formals (t);
  END Initialize;

BEGIN
END WordInsert.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Card is in:
</A><UL>
<LI><A HREF="../../../bicycle/src/Card.i3#0TOP0">bicycle/src/Card.i3</A>
<LI><A HREF="../builtinTypes/Card.i3#0TOP0">m3front/src/builtinTypes/Card.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
