<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinWord/WordModule.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinWord/WordModule.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: WordModule.m3                                         
 Last Modified On Tue Mar  2 09:13:12 PST 1993 By kalsow         
      Modified On Thu Jul 27 17:10:39 1989 By muller         

<P><PRE>MODULE <module><implements><A HREF="WordModule.i3">WordModule</A></implements></module>;

IMPORT <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../values/Tipe.i3">Tipe</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../values/Constant.i3">Constant</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../types/NamedType.i3">NamedType</A>;
IMPORT <A HREF="WordPlus.i3">WordPlus</A>, <A HREF="WordMinus.i3">WordMinus</A>, <A HREF="WordTimes.i3">WordTimes</A>, <A HREF="WordLT.i3">WordLT</A>, <A HREF="WordLE.i3">WordLE</A>, <A HREF="WordGT.i3">WordGT</A>, <A HREF="WordGE.i3">WordGE</A>;
IMPORT <A HREF="WordAnd.i3">WordAnd</A>, <A HREF="WordOr.i3">WordOr</A>, <A HREF="WordXor.i3">WordXor</A>, <A HREF="WordShift.i3">WordShift</A>, <A HREF="WordRotate.i3">WordRotate</A>, <A HREF="WordExtract.i3">WordExtract</A>;
IMPORT <A HREF="WordInsert.i3">WordInsert</A>, <A HREF="WordNot.i3">WordNot</A>, <A HREF="WordDivide.i3">WordDivide</A>, <A HREF="WordMod.i3">WordMod</A>;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  VAR zz: Scope.T;  size: Target.Int;  b: BOOLEAN;
  BEGIN

    b := TInt.FromInt (Target.Integer.size, size); &lt;*ASSERT b*&gt;
    M := Module.NewDefn (&quot;Word&quot;, TRUE, NIL);

    (* WARNING: The following list must be in the same order
        as the actual Word.i3 file, otherwise the version
        stamps will be messed up! *)

    zz := Scope.Push (Module.ExportScope (M));
    Tipe.Define (&quot;T&quot;, NamedType.New (Int.T), FALSE);
    Constant.Declare (&quot;Size&quot;, IntegerExpr.New (size), FALSE);
    WordPlus.Initialize ();
    WordTimes.Initialize ();
    WordMinus.Initialize ();
    WordDivide.Initialize ();
    WordMod.Initialize ();
    WordLT.Initialize ();
    WordLE.Initialize ();
    WordGT.Initialize ();
    WordGE.Initialize ();
    WordAnd.Initialize ();
    WordOr.Initialize ();
    WordXor.Initialize ();
    WordNot.Initialize ();
    WordShift.Initialize ();
    WordRotate.Initialize ();
    WordExtract.Initialize ();
    WordInsert.Initialize ();
    Scope.Pop (zz);
  END Initialize;

BEGIN
END WordModule.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
