<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinWord/WordNot.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinWord/WordNot.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: WordNot.m3                                            
 Last Modified On Mon Dec  5 15:30:45 PST 1994 By kalsow     
      Modified On Tue Apr 10 11:15:33 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="WordNot.i3">WordNot</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TWord.i3">TWord</A>;
IMPORT <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/Formal.i3">Formal</A>, <A HREF="../types/ProcType.i3">ProcType</A>;

VAR Z: CallExpr.MethodList;
VAR formals: Value.T;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    EVAL Formal.CheckArgs (cs, ce.args, formals, ce.proc);
    ce.type := Int.T;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.Compile (ce.args[0]);
    CG.Not ();
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e: Expr.T;  w, result: Target.Int;
  BEGIN
    e := Expr.ConstValue (ce.args[0]);
    IF (e # NIL) AND IntegerExpr.Split (e, w)
      THEN TWord.Not (w, result);  RETURN IntegerExpr.New (result);
      ELSE RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  VAR
    f0 := Formal.NewBuiltin (&quot;x&quot;, 0, Int.T);
    t  := ProcType.New (Int.T, f0);
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, TRUE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;Not&quot;, Z, FALSE, t);
    formals := ProcType.Formals (t);
  END Initialize;

BEGIN
END WordNot.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
