<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinWord/WordPlus.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinWord/WordPlus.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: WordPlus.m3                                           
 Last Modified On Mon Dec  5 15:30:44 PST 1994 By kalsow     
      Modified On Tue Apr 10 11:16:59 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="WordPlus.i3">WordPlus</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TWord.i3">TWord</A>;
IMPORT <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/Formal.i3">Formal</A>, <A HREF="../types/ProcType.i3">ProcType</A>;

VAR Z: CallExpr.MethodList;
VAR formals: Value.T;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    EVAL Formal.CheckArgs (cs, ce.args, formals, ce.proc);
    ce.type := Int.T;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.Compile (ce.args[0]);
    Expr.Compile (ce.args[1]);
    CG.Add (CG.Type.Word);
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR w0, w1, result: Target.Int;
  BEGIN
    IF GetArgs (ce.args, w0, w1)
      THEN TWord.Add (w0, w1, result);  RETURN IntegerExpr.New (result);
      ELSE RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="GetArgs"><procedure>GetArgs</procedure></A> (args: Expr.List;  VAR w0, w1: Target.Int): BOOLEAN =
  VAR e0, e1: Expr.T;
  BEGIN
    e0 := Expr.ConstValue (args[0]);
    e1 := Expr.ConstValue (args[1]);
    RETURN (e0 # NIL) AND IntegerExpr.Split (e0, w0) AND
	   (e1 # NIL) AND IntegerExpr.Split (e1, w1);
  END GetArgs;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  VAR
    x0 := Formal.NewBuiltin (&quot;x&quot;, 0, Int.T);
    y0 := Formal.NewBuiltin (&quot;y&quot;, 1, Int.T);
    t0 := ProcType.New (Int.T, x0, y0);
  BEGIN
    Z := CallExpr.NewMethodList (2, 2, TRUE, TRUE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;Plus&quot;, Z, FALSE, t0);
    formals := ProcType.Formals (t0);
  END Initialize;

BEGIN
END WordPlus.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
