<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinWord/WordShift.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinWord/WordShift.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: WordShift.m3                                          
 Last Modified On Mon Dec  5 15:30:43 PST 1994 By kalsow     
      Modified On Fri May 18 08:15:52 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="WordShift.i3">WordShift</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../types/SubrangeType.i3">SubrangeType</A>, <A HREF="../values/Formal.i3">Formal</A>;
IMPORT <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../types/ProcType.i3">ProcType</A>, <A HREF="../exprs/CheckExpr.i3">CheckExpr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../../../m3middle/src/TWord.i3">TWord</A>;

VAR Z, ZL, ZR: CallExpr.MethodList;
VAR formals, formalsL, formalsR: Value.T;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    EVAL Formal.CheckArgs (cs, ce.args, formals, ce.proc);
    ce.type := Int.T;
  END Check;

PROCEDURE <A NAME="CheckL"><procedure>CheckL</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    EVAL Formal.CheckArgs (cs, ce.args, formalsL, ce.proc);
    ce.type := Int.T;
  END CheckL;

PROCEDURE <A NAME="CheckR"><procedure>CheckR</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    EVAL Formal.CheckArgs (cs, ce.args, formalsR, ce.proc);
    ce.type := Int.T;
  END CheckR;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.Compile (ce.args[0]);
    Expr.Compile (ce.args[1]);
    CG.Shift ();
  END Compile;

PROCEDURE <A NAME="CompileL"><procedure>CompileL</procedure></A> (ce: CallExpr.T) =
  VAR max: Target.Int;  b := TInt.FromInt (Target.Integer.size -1, max);
  BEGIN
    &lt;* ASSERT b *&gt;
    Expr.Compile (ce.args[0]);
    CheckExpr.Emit (ce.args[1], TInt.Zero, max);
    CG.Shift_left ();
  END CompileL;

PROCEDURE <A NAME="CompileR"><procedure>CompileR</procedure></A> (ce: CallExpr.T) =
  VAR max: Target.Int;  b := TInt.FromInt (Target.Integer.size -1, max);
  BEGIN
    &lt;* ASSERT b *&gt;
    Expr.Compile (ce.args[0]);
    CheckExpr.Emit (ce.args[1], TInt.Zero, max);
    CG.Shift_right ();
  END CompileR;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e0, e1: Expr.T;  w0, i1, result: Target.Int;
  BEGIN
    e0 := Expr.ConstValue (ce.args[0]);
    e1 := Expr.ConstValue (ce.args[1]);
    IF (e0 # NIL) AND IntegerExpr.Split (e0, w0)
      AND (e1 # NIL) AND IntegerExpr.Split (e1, i1)
    THEN
      TWord.Shift (w0, i1, result);
      RETURN IntegerExpr.New (result);
    ELSE
      RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="FoldL"><procedure>FoldL</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e0, e1: Expr.T;  w0, i1, max, result: Target.Int;
  BEGIN
    e0 := Expr.ConstValue (ce.args[0]);
    e1 := Expr.ConstValue (ce.args[1]);
    IF (e0 # NIL) AND IntegerExpr.Split (e0, w0)
      AND (e1 # NIL) AND IntegerExpr.Split (e1, i1)
      AND TInt.LE (TInt.Zero, i1)
      AND TInt.FromInt (Target.Integer.size, max)
      AND TInt.LT (i1, max)
    THEN
      TWord.Shift (w0, i1, result);
      RETURN IntegerExpr.New (result);
    ELSE
      RETURN NIL;
    END;
  END FoldL;

PROCEDURE <A NAME="FoldR"><procedure>FoldR</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e0, e1: Expr.T;  w0, i1, max, neg_i1, result: Target.Int;
  BEGIN
    e0 := Expr.ConstValue (ce.args[0]);
    e1 := Expr.ConstValue (ce.args[1]);
    IF (e0 # NIL) AND IntegerExpr.Split (e0, w0)
      AND (e1 # NIL) AND IntegerExpr.Split (e1, i1)
      AND TInt.LE (TInt.Zero, i1)
      AND TInt.FromInt (Target.Integer.size, max)
      AND TInt.LT (i1, max)
      AND TInt.Subtract (TInt.Zero, i1, neg_i1)
    THEN
      TWord.Shift (w0, neg_i1, result);
      RETURN IntegerExpr.New (result);
    ELSE
      RETURN NIL;
    END;
  END FoldR;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  VAR
    max : Target.Int;
    b   := TInt.FromInt (Target.Integer.size-1, max);
    sub := SubrangeType.New (TInt.Zero, max, Int.T, FALSE);

    f0  := Formal.NewBuiltin (&quot;x&quot;, 0, Int.T);
    f1  := Formal.NewBuiltin (&quot;n&quot;, 1, Int.T);
    t   := ProcType.New (Int.T, f0, f1);

    Lf0 := Formal.NewBuiltin (&quot;x&quot;, 0, Int.T);
    Lf1 := Formal.NewBuiltin (&quot;n&quot;, 1, sub);
    Lt  := ProcType.New (Int.T, Lf0, Lf1);

    Rf0 := Formal.NewBuiltin (&quot;x&quot;, 0, Int.T);
    Rf1 := Formal.NewBuiltin (&quot;n&quot;, 1, sub);
    Rt  := ProcType.New (Int.T, Rf0, Rf1);
  BEGIN
    &lt;*ASSERT b*&gt;
    Z := CallExpr.NewMethodList (2, 2, TRUE, TRUE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;Shift&quot;, Z, FALSE, t);
    formals := ProcType.Formals (t);

    ZL := CallExpr.NewMethodList (2, 2, TRUE, TRUE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 CheckL,
                                 CallExpr.PrepArgs,
                                 CompileL,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 FoldL,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;LeftShift&quot;, ZL, FALSE, Lt);
    formalsL := ProcType.Formals (Lt);

    ZR := CallExpr.NewMethodList (2, 2, TRUE, TRUE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 CheckR,
                                 CallExpr.PrepArgs,
                                 CompileR,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 FoldR,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;RightShift&quot;, ZR, FALSE, Rt);
    formalsR := ProcType.Formals (Rt);

  END Initialize;

BEGIN
END WordShift.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
