<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/AddExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/AddExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: AddExpr.m3                                            

<P><PRE>MODULE <module><implements><A HREF="AddExpr.i3">AddExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../builtinTypes/Reel.i3">Reel</A>, <A HREF="../builtinTypes/LReel.i3">LReel</A>, <A HREF="../builtinTypes/EReel.i3">EReel</A>;
IMPORT <A HREF="../types/SetType.i3">SetType</A>, <A HREF="../builtinTypes/Addr.i3">Addr</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;
IMPORT <A HREF="AddressExpr.i3">AddressExpr</A>, <A HREF="SetExpr.i3">SetExpr</A>, <A HREF="IntegerExpr.i3">IntegerExpr</A>, <A HREF="ReelExpr.i3">ReelExpr</A>;

TYPE
  Class = { cINT, cREAL, cLONG, cEXTND, cADDR, cSET };

CONST
  CGType = ARRAY Class OF CG.AType {
            CG.Type.Int,   CG.Type.Reel, CG.Type.LReel,
            CG.Type.XReel, CG.Type.Word, CG.Type.Word };

TYPE
  P = ExprRep.Tab BRANDED &quot;AddExpr.P&quot; OBJECT
        class   : Class;
        tmp     : CG.Var;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := ExprRep.EqCheckAB;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a, b: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.a := a;
    p.b := b;
    p.tmp := NIL;
    RETURN p;
  END New;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  VAR ta: Type.T;
  BEGIN
    ta := Expr.TypeOf (p.a);
    ta := Type.Check (ta);
    IF Type.IsSubtype (ta, Addr.T) THEN ta := Addr.T END;
    RETURN Type.Base (ta);
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR ta, tb, range: Type.T;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    Expr.TypeCheck (p.b, cs);
    ta := Type.Base (Expr.TypeOf (p.a));
    tb := Type.Base (Expr.TypeOf (p.b));
    IF    (ta = Int.T)   AND (tb = Int.T)   THEN
      p.class := Class.cINT;  INC (cs.int_ops);
    ELSIF (ta = Reel.T)  AND (tb = Reel.T)  THEN
      p.class := Class.cREAL;  INC (cs.fp_ops);
    ELSIF (ta = LReel.T) AND (tb = LReel.T) THEN
      p.class := Class.cLONG;  INC (cs.fp_ops);
    ELSIF (ta = EReel.T) AND (tb = EReel.T) THEN
      p.class := Class.cEXTND;  INC (cs.fp_ops);
    ELSIF SetType.Split (ta, range) THEN
      p.class := Class.cSET;
      IF  NOT Type.IsEqual (ta, tb, NIL) THEN
        ta := Expr.BadOperands (&quot;\'+\'&quot;, ta, tb);
      END;
    ELSIF Type.IsSubtype (ta, Addr.T) AND (tb = Int.T) THEN
      p.class := Class.cADDR;  ta := Addr.T;
      IF Module.IsSafe () THEN Error.Msg (&quot;unsafe \'+\'&quot;); END;
    ELSE
      ta := Expr.BadOperands (&quot;\'+\'&quot;, ta, tb);
    END;
    p.type := ta;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  VAR info: Type.Info;
  BEGIN
    Expr.Prep (p.a);
    Expr.Prep (p.b);
    IF (p.class = Class.cSET) THEN
      EVAL Type.CheckInfo (p.type, info);
      IF (info.size &gt; Target.Integer.size) THEN
        p.tmp := CG.Declare_temp (info.size, Target.Integer.align,
                                  CG.Type.Struct, in_memory := TRUE);
        CG.Load_addr_of (p.tmp, 0, Target.Integer.align);
        CG.Force ();
        Expr.Compile (p.a);
        Expr.Compile (p.b);
        CG.Set_union (info.size);
      END;
    END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR info: Type.Info;
  BEGIN
    IF (p.class = Class.cSET) THEN
      EVAL Type.CheckInfo (p.type, info);
      IF (info.size &gt; Target.Integer.size) THEN
        CG.Load_addr_of_temp (p.tmp, 0, Target.Integer.align);
        p.tmp := NIL;
      ELSE
        Expr.Compile (p.a);
        Expr.Compile (p.b);
        CG.Set_union (info.size);
      END;
    ELSIF (p.class = Class.cADDR) THEN
      Expr.Compile (p.a);
      Expr.Compile (p.b);
      CG.Index_bytes (Target.Byte);
    ELSE
      Expr.Compile (p.a);
      Expr.Compile (p.b);
      CG.Add (CGType[p.class]);
    END;
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e1, e2, e3: Expr.T;
  BEGIN
    e1 := Expr.ConstValue (p.a);
    e2 := Expr.ConstValue (p.b);
    e3 := NIL;
    IF    (e1 = NIL) OR (e2 = NIL)     THEN
    ELSIF IntegerExpr.Add (e1, e2, e3) THEN
    ELSIF ReelExpr.Add    (e1, e2, e3) THEN
    ELSIF AddressExpr.Add (e1, e2, e3) THEN
    ELSIF SetExpr.Union   (e1, e2, e3) THEN
    END;
    RETURN e3;
  END Fold;

BEGIN
END AddExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
