<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/AddressExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/AddressExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: AddressExpr.m3                                        

<P><PRE>MODULE <module><implements><A HREF="AddressExpr.i3">AddressExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Addr.i3">Addr</A>, <A HREF="../builtinTypes/Null.i3">Null</A>, <A HREF="IntegerExpr.i3">IntegerExpr</A>;
IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../../../m3middle/src/TWord.i3">TWord</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;

TYPE
  P = Expr.T OBJECT
        value        : Target.Int;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := ExprRep.NoCheck;
        need_addr    := ExprRep.NotAddressable;
        prep         := ExprRep.NoPrep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := ExprRep.Self;
        isEqual      := EqCheck;
        getBounds    := Bounder;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := IsZeroes;
	genFPLiteral := GenFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := GenLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (READONLY value: Target.Int): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.value   := value;
    p.checked := TRUE;
    IF TInt.EQ (value, TInt.Zero)
      THEN p.type := Null.T;
      ELSE p.type := Addr.T;
    END;
    RETURN p;
  END New;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (e: Expr.T;  VAR value: Target.Int): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; value := p.value;  RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Split;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR i, j: Target.Int;
  BEGIN
    IF NOT IntegerExpr.Split (b, i) THEN RETURN FALSE END;
    TYPECASE a OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; TWord.Add (p.value, i, j);  c := New (j);  RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Add;

PROCEDURE <A NAME="Subtract"><procedure>Subtract</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR i, j, k: Target.Int;
  BEGIN
    TYPECASE a OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; i := p.value;
    ELSE      RETURN FALSE;
    END;

    IF IntegerExpr.Split (b, j) THEN
      TWord.Subtract (i, j, k);
      c := New (k);
    ELSE (* address - address *)
      TYPECASE b OF
      | NULL =&gt; RETURN FALSE;
      | P(p) =&gt; TWord.Subtract (i, p.value, k);  c := IntegerExpr.New (k);
      ELSE      RETURN FALSE;
      END;
    END;
    RETURN TRUE;
  END Subtract;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A> (a, b: Expr.T;  VAR sign: INTEGER): BOOLEAN =
  VAR x, y: Target.Int;
  BEGIN
    IF  NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF TWord.LT (x, y) THEN
      sign := -1
    ELSIF TWord.LT (y, x) THEN
      sign := 1
    ELSE
      sign := 0
    END;
    RETURN TRUE;
  END Compare;

PROCEDURE <A NAME="SplitPair"><procedure>SplitPair</procedure></A> (a, b: Expr.T;  VAR x, y: Target.Int): BOOLEAN =
  BEGIN
    TYPECASE a OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; x := p.value;
    ELSE      RETURN FALSE;
    END;
    TYPECASE b OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; y := p.value;
    ELSE      RETURN FALSE;
    END;
    RETURN TRUE;
  END SplitPair;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN (a.value = b.value);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR val: INTEGER;  b := TInt.ToInt (p.value, val);
  BEGIN
    &lt;*ASSERT b*&gt;
    CG.Load_nil ();
    IF (val # 0) THEN CG.Add_offset (Target.Byte * val) END;
  END Compile;

PROCEDURE <A NAME="Bounder"><procedure>Bounder</procedure></A> (p: P;   VAR min, max: Target.Int) =
  BEGIN
    min := p.value;
    max := p.value;
  END Bounder;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN p = Null.Nil OR TInt.EQ (p.value, TInt.Zero);
  END IsZeroes;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  BEGIN
    M3Buf.PutText (buf, &quot;ADDR&lt;&quot;);
    M3Buf.PutIntt (buf, p.value);
    M3Buf.PutChar (buf, '&gt;');
  END GenFPLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (p: P;  offset: INTEGER;  &lt;*UNUSED*&gt; type: Type.T) =
  BEGIN
    IF NOT TInt.EQ (p.value, TInt.Zero) THEN
      CG.Init_int (offset, MIN (Target.Integer.size, Target.Address.size),
                   p.value);
    END;
  END GenLiteral;

BEGIN
END AddressExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
