<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/ArrayExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/ArrayExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ArrayExpr.m3                                          

<P><PRE>MODULE <module><implements><A HREF="ArrayExpr.i3">ArrayExpr</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../types/ArrayType.i3">ArrayType</A>;
IMPORT <A HREF="KeywordExpr.i3">KeywordExpr</A>, <A HREF="RangeExpr.i3">RangeExpr</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../types/OpenArrayType.i3">OpenArrayType</A>, <A HREF="../values/Module.i3">Module</A>;
IMPORT <A HREF="IntegerExpr.i3">IntegerExpr</A>, <A HREF="EnumExpr.i3">EnumExpr</A>, <A HREF="../types/SubrangeType.i3">SubrangeType</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;
IMPORT <A HREF="../stmts/AssignStmt.i3">AssignStmt</A>, <A HREF="../types/RefType.i3">RefType</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/Runtime.i3">Runtime</A>, <A HREF="../builtinTypes/ErrType.i3">ErrType</A>;

TYPE
  Kind = {
    Fixed,     (* ARRAY I OF T { ... } *)
    EmptyOpen, (* ARRAY OF T { } *)
    FixedOpen, (* ARRAY OF T { ... with fixed shaped element ... } *)
    Open       (* ARRAY OF T { ... no compile-time fixed elements ... } *)
  };

TYPE
  P = Expr.T BRANDED &quot;ArrayExpr.P&quot; OBJECT
        tipe      : Type.T;
	args      : Expr.List;
	dots      : BOOLEAN;
        folded    : BOOLEAN;
        is_const  : BOOLEAN;
        kind      : Kind;
	index     : Type.T;
        refType   : Type.T; (* Kind.Open *)
        solidType : Type.T; (* Kind.FixedOpen *)
        offset    : INTEGER;
        tmp       : CG.Val;
        tmp_cnt   : INTEGER;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := IsZeroes;
	genFPLiteral := GenFPLiteral;
	prepLiteral  := PrepLiteral;
	genLiteral   := GenLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (type: Type.T;  args: Expr.List;  dots: BOOLEAN): Expr.T =
  VAR p := NEW (P);  index, element: Type.T;
  BEGIN
    ExprRep.Init (p);
    IF  NOT ArrayType.Split (type, index, element) THEN
      Error.Msg (&quot;expecting array type on array constructor&quot;);
      index := NIL;
    END;
    p.type      := type;
    p.tipe      := type;
    p.index     := index;
    p.args      := args;
    p.dots      := dots;
    p.folded    := FALSE;
    p.is_const  := FALSE;
    p.refType   := NIL;
    p.solidType := NIL;
    p.offset    := 0;
    p.tmp       := NIL;
    p.tmp_cnt   := 0;
    RETURN p;
  END New;

PROCEDURE <A NAME="Is"><procedure>Is</procedure></A> (e: Expr.T): BOOLEAN =
  BEGIN
    RETURN (TYPECODE (e) = TYPECODE (P));
  END Is;

PROCEDURE <A NAME="Subscript"><procedure>Subscript</procedure></A> (array, index: Expr.T;  VAR e: Expr.T): BOOLEAN =
  VAR p: P;  i, n: INTEGER;  int, min, max, offs: Target.Int;  t: Type.T;
      b: BOOLEAN;
  BEGIN
    TYPECASE array OF
    | NULL =&gt; RETURN FALSE;
    | P(x) =&gt; p := x;
    ELSE      RETURN FALSE;
    END;
    index := Expr.ConstValue (index);
    IF (NOT IntegerExpr.Split (index, int))
      AND (NOT EnumExpr.Split (index, int, t)) THEN
      RETURN FALSE;
    END;
    IF p.index = NIL THEN
      min := TInt.Zero (* FIRST (p.args^) *);
      b := TInt.FromInt (LAST (p.args^), max);  &lt;* ASSERT b *&gt;
    ELSE
      EVAL Type.GetBounds (p.index, min, max);
    END;

    (* correct for the base index of the array *)
    IF NOT TInt.Subtract (int, min, offs) THEN RETURN FALSE END;
    IF TInt.LT (offs, TInt.Zero)  THEN RETURN FALSE END;
    b := TInt.ToInt (offs, i); &lt;* ASSERT b *&gt;

    n := LAST (p.args^);
    IF (i &lt;= n) THEN e := p.args[i]; RETURN TRUE END;
    IF (p.dots) THEN e := p.args[n]; RETURN TRUE END;
    RETURN FALSE;
  END Subscript;

PROCEDURE <A NAME="GetBounds"><procedure>GetBounds</procedure></A> (array: Expr.T;  VAR min, max: Target.Int): BOOLEAN =
  VAR b: BOOLEAN;
  BEGIN
    TYPECASE array OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; IF p.index = NIL THEN
                (* open array type *)
                min := TInt.Zero (* FIRST (p.args^) *);
                b := TInt.FromInt (LAST (p.args^), max); &lt;*ASSERT b*&gt;
                RETURN TRUE;
              ELSE
                RETURN Type.GetBounds (p.index, min, max);
              END;
    ELSE     RETURN FALSE;
    END;
  END GetBounds;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR
    nn: Target.Int;
    n: INTEGER;
    e, value, minE, maxE: Expr.T;
    index, element, solidElt, elt: Type.T;
    key: M3ID.T;
    elt_info: Type.Info;
  BEGIN
    IF (p.index # NIL) THEN
      p.index := Type.Check (p.index);
    END;

    p.tipe := Type.Check (p.tipe);
    p.type := p.tipe;
    WITH b = ArrayType.Split (p.tipe, index, element) DO &lt;* ASSERT b *&gt; END;
    element := Type.CheckInfo (element, elt_info);

    IF (index # ErrType.T) THEN
      nn := Type.Number (index);
      IF NOT TInt.ToInt (nn, n) THEN
        Error.Msg (&quot;array has too many elements&quot;);
      END;
      IF (index # NIL) THEN
        IF n &lt; NUMBER (p.args^) THEN
          Error.Msg (&quot;too many values specified&quot;);
        ELSIF n &gt; NUMBER (p.args^) AND NOT p.dots THEN
          Error.Msg (&quot;not enough values specified&quot;);
        END;
      ELSIF (p.dots) THEN
        Error.Warn (1, &quot;\&quot;..\&quot; ignored in open array constructor&quot;);
      END;
    END;

    FOR i := 0 TO LAST (p.args^) DO
      e := p.args[i];
      Expr.TypeCheck (e, cs);
      IF KeywordExpr.Split (e, key, value) THEN
        Error.Msg (&quot;keyword values not allowed in array constructors&quot;);
        e := value;
      END;
      IF RangeExpr.Split (e, minE, maxE) THEN
        Error.Msg (&quot;range values not allowed in array constructors&quot;);
        e := value;
      END;

      IF NOT Type.IsAssignable (element, Expr.TypeOf (e)) THEN
        Error.Msg (&quot;expression is not assignable to array element&quot;);
      ELSE
        AssignStmt.Check (element, e, cs);
      END;
    END;

    IF (index # NIL) OR (index = ErrType.T) THEN
      p.kind := Kind.Fixed;
    ELSIF (NUMBER (p.args^) = 0) THEN
      p.kind := Kind.EmptyOpen;
    ELSE
      (* we're producing an open array =&gt; try to find a fixed shape element *)
      solidElt := NIL;
      IF elt_info.size &gt; 0 THEN
        solidElt := element;
      ELSE
        FOR i := 0 TO LAST (p.args^) DO
          elt := Expr.TypeOf (p.args[i]);
          elt := Type.CheckInfo (elt, elt_info);
          IF (elt_info.size &gt; 0) OR FixedArray (p.args[i], elt) THEN
            (* we found one! *)
            solidElt := elt;
            EXIT;
          END;
        END;
      END;

      IF (solidElt # NIL) AND TInt.FromInt (LAST (p.args^), nn) THEN
        p.kind := Kind.FixedOpen;
        index := SubrangeType.New (TInt.Zero, nn, Int.T, FALSE);
        p.solidType := ArrayType.New (index, solidElt);
        p.solidType := Type.CheckInfo (p.solidType, elt_info);
        element := solidElt;
      ELSE
        (* we can't determine the shape until runtime *)
        p.kind := Kind.Open;
        p.refType := RefType.New (p.tipe, traced := TRUE, brand := NIL);
        p.refType := Type.CheckInfo (p.refType, elt_info);
      END;
    END;
  END Check;

PROCEDURE <A NAME="FixedArray"><procedure>FixedArray</procedure></A> (e: Expr.T;  VAR solidType: Type.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; solidType := p.solidType; RETURN (solidType # NIL);
    ELSE      RETURN FixedArray (Expr.ConstValue (e), solidType);
    END;
  END FixedArray;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  VAR b: P;
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; b := p;
    ELSE      RETURN FALSE;
    END;
    IF   (NOT Type.IsEqual (a.tipe, b.tipe, NIL))
      OR (a.dots # b.dots)
      OR ((a.args = NIL) # (b.args = NIL))
      OR ((a.args # NIL) AND (NUMBER (a.args^) # NUMBER (b.args^))) THEN
      RETURN FALSE;
    END;
    FOR i := 0 TO LAST (a.args^) DO
      IF NOT Expr.IsEqual (a.args[i], b.args[i]) THEN RETURN FALSE END;
    END;
    RETURN TRUE;
  END EqCheck;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
    (* ya, so... *)
  END NeedsAddress;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR size, align, depth, offset: INTEGER;  info: Type.Info;
  BEGIN
    (* The bulk of the work was done by Prep *)
    IF (p.is_const) THEN
      EVAL Type.CheckInfo (p.tipe, info);
      size  := info.size;
      align := info.alignment;
      depth := OpenArrayType.OpenDepth (p.tipe);

      IF (depth &gt; 0) THEN
        (* p.tipe is an open array *)
        size := Target.Address.pack + depth * Target.Integer.pack;
        align := MAX (Target.Address.align, Target.Integer.align);
      END;

      offset := Module.Allocate (size, align, &quot;*array*&quot;);
      PrepLiteral (p, p.tipe);
      GenLiteral (p, offset, p.tipe);
      CG.Load_addr_of (Module.GlobalData (NIL), offset, align);
    ELSE
      CG.Push (p.tmp);
      DEC (p.tmp_cnt);
      IF (p.tmp_cnt &lt;= 0) THEN
        CG.Free (p.tmp);
        p.tmp := NIL;
      END;
    END;
  END Compile;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  VAR index, element: Type.T;  elt_info: Type.Info;  elt_pack: INTEGER;
  BEGIN
    Type.Compile (p.tipe);
    Type.Compile (p.refType);
    Type.Compile (p.solidType);

    IF (Fold (p) # NIL) THEN RETURN END;

    INC (p.tmp_cnt);
    IF (p.tmp # NIL) AND (p.tmp_cnt &gt; 1) THEN RETURN END;

    index := p.tipe;  IF (p.solidType # NIL) THEN index := p.solidType END;
    WITH b = ArrayType.Split (index, index, element) DO &lt;* ASSERT b *&gt; END;
    element := Type.CheckInfo (element, elt_info);
    elt_pack  := (elt_info.size + elt_info.alignment - 1)
                     DIV elt_info.alignment * elt_info.alignment;

    CASE p.kind OF
    | Kind.Fixed     =&gt; DoFixed (p, element, elt_pack);
    | Kind.EmptyOpen =&gt; DoEmpty (p);
    | Kind.FixedOpen =&gt; DoFixedOpen (p, elt_pack);
    | Kind.Open      =&gt; DoOpen (p, elt_pack, elt_info.alignment);
    END;
  END Prep;

PROCEDURE <A NAME="DoFixed"><procedure>DoFixed</procedure></A> (p: P;  element: Type.T;  elt_pack: INTEGER) =
  VAR
    t1: CG.Var;
    t2: CG.Val;
    top: CG.Label;
    nn_args : Target.Int;
    n_args := NUMBER (p.args^);
    nn_elts := Type.Number (p.index);
    n_elts : INTEGER;
    b: BOOLEAN;
    info: Type.Info;
    align: INTEGER;
  BEGIN
    EVAL Type.CheckInfo (p.tipe, info);
    align := info.alignment;
    b := TInt.ToInt (nn_elts, n_elts);    &lt;*ASSERT b*&gt;
    b := TInt.FromInt (n_args, nn_args);  &lt;*ASSERT b*&gt;

    t1 := CG.Declare_temp (info.size, align, CG.Type.Struct, in_memory:= TRUE);

    (* assign the given elements *)
    FOR i := 0 TO n_args-1 DO
      Expr.Prep (p.args[i]);
      CG.Load_addr_of (t1, i * elt_pack, align);
      AssignStmt.Emit (element, p.args[i]);
    END;

    (* fill in the '..' section *)
    IF (p.dots) AND (n_elts &gt; n_args) THEN
      CG.Load_integer (nn_args);
      t2 := CG.Pop_temp ();
      top := CG.Next_label ();
      CG.Set_label (top);

      (* ARRAY[t2] := ARRAY[n_args-1] *)
      CG.Load_addr_of (t1, 0, align);
      CG.Push (t2);
      ArrayType.GenIndex (p.tipe);
      CG.Load_addr_of (t1, (n_args-1) * elt_pack, align);
      IF ArrayType.IsBitAddressed (p.tipe) THEN
        CG.Load_indirect (CG.Type.Int, 0, elt_pack);
        CG.Store_indirect (CG.Type.Int, 0, elt_pack);
      ELSE
        CG.Copy (elt_pack, overlap := FALSE);
      END;

      (* t2 := t2 + 1 *)
      CG.Push (t2);
      CG.Load_integer (TInt.One);
      CG.Add (CG.Type.Int);
      CG.Store_temp (t2);

      (* IF (t2 &lt; NUMBER(ARRAY) GOTO TOP-OF-LOOP *)
      CG.Push (t2);
      CG.Load_integer (nn_elts);
      CG.If_lt (top, CG.Type.Int, CG.Likely);

      CG.Free (t2);
    END;

    (* remember the result *)
    CG.Load_addr_of_temp (t1, 0, info.alignment);
    p.tmp := CG.Pop ();
  END DoFixed;

PROCEDURE <A NAME="DoEmpty"><procedure>DoEmpty</procedure></A> (p: P) =
  VAR t1: CG.Var;
  BEGIN
    t1 := CG.Declare_temp (Target.Address.pack + Target.Integer.pack,
                           Target.Address.align,  CG.Type.Struct,
                           in_memory := TRUE);
    CG.Load_nil ();
    CG.Store_addr (t1, M3RT.OA_elt_ptr);
    CG.Load_integer (TInt.Zero);
    CG.Store_int (t1, M3RT.OA_size_0);

    (* remember the result *)
    CG.Load_addr_of_temp (t1, 0, Target.Address.align);
    p.tmp := CG.Pop ();
  END DoEmpty;

PROCEDURE <A NAME="DoFixedOpen"><procedure>DoFixedOpen</procedure></A> (p: P;  elt_pack: INTEGER) =
  VAR
    t1         : CG.Var;
    index, element: Type.T;
    offset     : INTEGER;
    n_args     := NUMBER (p.args^);
    openDepth  := OpenArrayType.OpenDepth (p.type);
    align      : INTEGER;
    info       : Type.Info;
    dope_size  : INTEGER;
    data_offs  : INTEGER;
    dope_align : INTEGER;
    total_size : INTEGER;
  BEGIN
    EVAL Type.CheckInfo (p.solidType, info);
    align := info.alignment;

    (* allocate space for the result *)
    dope_align := MAX (Target.Address.align, align);
    dope_size  := Target.Address.pack + openDepth * Target.Integer.pack;
    data_offs  := (dope_size + align - 1) DIV align * align;
    total_size := data_offs + info.size;
    t1 := CG.Declare_temp (total_size, dope_align, CG.Type.Struct,
                           in_memory := TRUE);

    (* initialize the element pointer *)
    CG.Load_addr_of (t1, data_offs, align);
    CG.Store_addr (t1, M3RT.OA_elt_ptr);

    (* initialize size[0] of the dope vector *)
    CG.Load_intt (n_args);
    CG.Store_int (t1, M3RT.OA_size_0);

    (* initialize the remaining sizes of the dope vector *)
    EVAL ArrayType.Split (p.solidType, index, element);
    offset := M3RT.OA_size_0 + Target.Integer.pack;
    FOR i := 1 TO openDepth-1 DO
      EVAL ArrayType.Split (element, index, element);
      &lt;*ASSERT index # NIL*&gt;
      CG.Load_integer (Type.Number (index));
      CG.Store_int (t1, offset);
      INC (offset, Target.Integer.pack);
    END;

    (* fill with the elements *)
    EVAL ArrayType.Split (p.solidType, index, element);
    FOR i := 0 TO n_args-1 DO
      Expr.Prep (p.args[i]);
      CG.Load_addr_of (t1, data_offs + i * elt_pack, align);
      AssignStmt.Emit (element, p.args[i]);
    END;

    (* remember the result *)
    CG.Load_addr_of_temp (t1, 0, dope_align);
    p.tmp := CG.Pop ();
  END DoFixedOpen;

PROCEDURE <A NAME="DoOpen"><procedure>DoOpen</procedure></A> (p: P;  elt_pack, elt_align: INTEGER) =
  VAR
    t1: CG.Var;
    t2, t3, t4: CG.Val;
    index, element: Type.T;
    offset    : INTEGER;
    n_args    := NUMBER (p.args^);
    openDepth := OpenArrayType.OpenDepth (p.type);
    size      : INTEGER;
    proc      := Runtime.LookUpProc (Runtime.Hook.NewTracedArray);
  BEGIN
    &lt;*ASSERT elt_align MOD Target.Byte = 0*&gt;

    (* evaluate the first argument to fix the runtime shape *)
    Expr.Prep (p.args[0]);
    Expr.Compile (p.args[0]);
    t2 := CG.Pop ();

    (* allocate the temporary &quot;sizes&quot; array  *)
    size := Target.Address.pack + (1 + openDepth) * Target.Integer.pack;
    t1 := CG.Declare_temp (size, Target.Address.align, CG.Type.Struct,
                           in_memory := TRUE);

    (* initialize the sizes array *)
    CG.Load_addr_of (t1, M3RT.OA_size_1, Target.Address.align);
    CG.Store_addr (t1, M3RT.OA_elt_ptr);

    CG.Load_intt (openDepth);
    CG.Store_int (t1, M3RT.OA_size_0);

    CG.Load_intt (n_args);
    CG.Store_int (t1, M3RT.OA_size_1);

    element := Expr.TypeOf (p.args[0]);
    offset := M3RT.OA_size_1 + Target.Integer.pack;
    FOR i := 1 TO openDepth-1 DO
      EVAL ArrayType.Split (element, index, element);
      IF (index = NIL) THEN
        CG.Push (t2);
        CG.Open_size (i - 1);
      ELSE
        CG.Load_integer (Type.Number (index));
      END;
      CG.Store_int (t1, offset);
      INC (offset, Target.Integer.pack);
    END;

    (* allocate space for the value *)
    Procedure.StartCall (proc);
    IF Target.DefaultCall.args_left_to_right THEN
      Type.LoadInfo (p.refType, -1);
      CG.Pop_param (CG.Type.Addr);
      CG.Load_addr_of (t1, 0, Target.Address.align);
      CG.Pop_param (CG.Type.Addr);
    ELSE
      CG.Load_addr_of (t1, 0, Target.Address.align);
      CG.Pop_param (CG.Type.Addr);
      Type.LoadInfo (p.refType, -1);
      CG.Pop_param (CG.Type.Addr);
    END;
    t3 := Procedure.EmitCall (proc);

    (* repack the &quot;sizes&quot; array as a dope vector for each array element *)
    CG.Push (t3);
    CG.Boost_alignment (elt_align);
    CG.Open_elt_ptr (Target.Integer.align);
    CG.Store_addr (t1, M3RT.OA_elt_ptr);
    FOR i := 0 TO openDepth-2 DO
      CG.Load_int (t1, M3RT.OA_sizes + (i + 2) * Target.Integer.pack);
      CG.Store_int (t1, M3RT.OA_sizes + i * Target.Integer.pack);
    END;

    (* compute the size of each element in &quot;elt_pack&quot; units *)
    FOR i := 0 TO openDepth-2 DO
      CG.Load_int (t1, M3RT.OA_sizes + i * Target.Integer.pack);
      IF (i # 0) THEN CG.Multiply (CG.Type.Int) END;
    END;
    t4 := CG.Pop ();

    (* copy the first element into place *)
    CG.Load_addr (t1, M3RT.OA_elt_ptr);
    CG.Force ();
    CG.Push (t2);
    CG.Force ();
    CG.Push (t4);
    CG.Copy_n (elt_pack, overlap := FALSE);

    (* fill in the remaining elements *)
    EVAL ArrayType.Split (p.tipe, index, element);
    FOR i := 1 TO n_args-1 DO
      (* bump the pointer to the next element *)
      CG.Load_addr (t1, M3RT.OA_elt_ptr);
      CG.Push (t4); (* == element size *)
      CG.Index_bytes (elt_pack);
      CG.Store_addr (t1, M3RT.OA_elt_ptr);

      (* do the assignment *)
      Expr.Prep (p.args[i]);
      CG.Load_addr (t1);
      AssignStmt.Emit (element, p.args[i]);
    END;

    (* remember the result and free the other temporaries *)
    p.tmp := t3;

    CG.Free_temp (t1);
    CG.Free (t2);
    CG.Free (t4);
  END DoOpen;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e: Expr.T;
  BEGIN
    IF (NOT p.folded) THEN
      p.folded   := TRUE;
      p.is_const := TRUE;
      FOR i := 0 TO LAST (p.args^) DO
        e := Expr.ConstValue (p.args[i]);
        IF (e = NIL) THEN p.is_const := FALSE; ELSE p.args[i] := e; END;
      END;
    END;
    IF p.is_const
      THEN RETURN p;
      ELSE RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (p: P): BOOLEAN =
  BEGIN
    FOR i := 0 TO LAST (p.args^) DO
      IF NOT Expr.IsZeroes (p.args[i]) THEN RETURN FALSE END;
    END;
    RETURN TRUE;
  END IsZeroes;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  VAR n_elts, n_args: INTEGER;  b: BOOLEAN;  e: Expr.T;
  BEGIN
    n_args := NUMBER (p.args^);
    M3Buf.PutText (buf, &quot;ARRAY&lt;&quot;);
    FOR i := 0 TO n_args-1 DO
      IF (i &gt; 0) THEN M3Buf.PutChar (buf, ',') END;
      Expr.GenFPLiteral (p.args[i], buf);
    END;
    IF (p.kind = Kind.Fixed) AND (p.dots) THEN
      b := TInt.ToInt (Type.Number (p.index), n_elts);    &lt;*ASSERT b*&gt;
      IF (n_elts &gt; n_args) THEN
        e := p.args [n_args-1];
        e := Expr.ConstValue (e);
        FOR i := n_args TO n_elts DO
          M3Buf.PutChar (buf, ',');
          Expr.GenFPLiteral (e, buf);
        END;
      END;
    END;
    M3Buf.PutChar (buf, '&gt;');
  END GenFPLiteral;

PROCEDURE <A NAME="PrepLiteral"><procedure>PrepLiteral</procedure></A> (p: P;  type: Type.T) =
  VAR info: Type.Info;
  BEGIN
    PrepElements (p, p.tipe);

    IF (p.kind = Kind.Fixed) OR (p.kind = Kind.EmptyOpen) THEN RETURN END;

    &lt;*ASSERT (p.kind = Kind.FixedOpen) AND (p.solidType # NIL) *&gt;
    (* else p.kind = Kind.Open =&gt; not a runtime constant! *)

    IF (p.offset = 0) THEN
      EVAL Type.CheckInfo (p.solidType, info);
      p.offset := Module.Allocate (info.size, info.alignment,
                                   &quot;*open array literal*&quot;);
      CG.Declare_global_field (M3ID.Add (&quot;_array&quot;), p.offset, info.size,
                               Type.GlobalUID(p.solidType));
    END;

    EVAL GenOpenLiteral (p, p.offset,
                         OpenArrayType.OpenDepth (p.tipe),
                         OpenArrayType.OpenType (p.tipe),
                         OpenArrayType.EltPack (p.type));
  END PrepLiteral;

PROCEDURE <A NAME="PrepElements"><procedure>PrepElements</procedure></A> (e: Expr.T;  type: Type.T) =
  VAR index, element: Type.T;  b: BOOLEAN;
  BEGIN
    TYPECASE e OF
    | NULL =&gt; (* skip *)
    | P(p) =&gt; b := ArrayType.Split (type, index, element); &lt;* ASSERT b *&gt;
              FOR i := FIRST (p.args^) TO LAST (p.args^) DO
                PrepElements (p.args[i], element);
              END;
    ELSE      Expr.PrepLiteral (e, type);
    END;
  END PrepElements;

PROCEDURE <A NAME="GenOpenLiteral"><procedure>GenOpenLiteral</procedure></A> (e: Expr.T;  offset: INTEGER;  depth: INTEGER;
                          elt_type: Type.T;  elt_pack: INTEGER): INTEGER =
  VAR size, align, start: INTEGER;  info: Type.Info;  t: Type.T;
  BEGIN
    IF (depth &lt;= 0) THEN
      (* we're out of the open-array morass *)
      Expr.GenLiteral (e, offset, elt_type);
      RETURN elt_pack;
    END;

    TYPECASE e OF
    | NULL =&gt; RETURN 0;
    | P(p) =&gt; start := offset;
              align := ArrayType.EltAlign (p.tipe);
              FOR i := FIRST (p.args^) TO LAST (p.args^) DO
                size := GenOpenLiteral (p.args[i], offset, depth-1,
                                        elt_type, elt_pack);
                INC (offset, (size + align - 1) DIV align * align);
              END;
              RETURN offset - start;
    ELSE      Error.Msg (&quot;*** INTERNAL ERROR: missing open array expr? ***&quot;);
              t := Type.CheckInfo (Expr.TypeOf (e), info);
              Expr.GenLiteral (e, offset, t);
              RETURN info.size;
    END;
  END GenOpenLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (p: P;  offset: INTEGER;  type: Type.T) =
  VAR index, element: Type.T;  last, n_elts, elt_size: INTEGER;  b: BOOLEAN;
  BEGIN
    b := ArrayType.Split (p.tipe, index, element); &lt;* ASSERT b *&gt;

    (* BUG!!  if p.tipe # type then we're generating an open literal
           for a fixed size expr or vice versa.... *)

    CASE p.kind OF
    | Kind.EmptyOpen =&gt;
        GenOpenDim (p, OpenArrayType.OpenDepth (p.tipe),
                    offset + M3RT.OA_sizes);

    | Kind.FixedOpen =&gt;
        CG.Init_var (offset + M3RT.OA_elt_ptr, Module.GlobalData (NIL),
                      p.offset);
        GenOpenDim (p, OpenArrayType.OpenDepth (p.tipe),
                    offset + M3RT.OA_sizes);

    | Kind.Open =&gt;
        &lt;* ASSERT FALSE *&gt;  (* not a compile-time constant *)

    | Kind.Fixed =&gt;
        (* find the last non-zero element *)
        last := LAST (p.args^);
        WHILE (last &gt; 0) AND Expr.IsZeroes (p.args[last]) DO DEC (last) END;

        IF (NUMBER (p.args^) &gt; 0) THEN
          elt_size := ArrayType.EltPack (p.tipe);
          FOR i := 0 TO last DO
            Expr.GenLiteral (p.args[i], offset, element);
            INC (offset, elt_size);
          END;
          IF (p.dots) AND (last = LAST (p.args^)) THEN
            b := TInt.ToInt (Type.Number (index), n_elts); &lt;*ASSERT b*&gt;
            FOR i := last+1 TO n_elts-1 DO
              Expr.GenLiteral (p.args[last], offset, element);
              INC (offset, elt_size);
            END;
          END;
        END;
    END;
  END GenLiteral;

PROCEDURE <A NAME="GenOpenDim"><procedure>GenOpenDim</procedure></A> (e: Expr.T;  depth: INTEGER;  offset: INTEGER) =
  VAR n_elts: INTEGER;
  BEGIN
    WHILE (depth &gt; 0) DO
      TYPECASE e OF
      | NULL =&gt; n_elts := 0;
      | P(p) =&gt; n_elts := NUMBER (p.args^);
                IF (n_elts # 0)
                  THEN e := p.args[0];
                  ELSE e := NIL;
                END;
      ELSE      n_elts := 0;
      END;
      CG.Init_intt (offset, Target.Integer.size, n_elts);
      INC (offset, Target.Integer.pack);
      DEC (depth);
    END;
  END GenOpenDim;

BEGIN
END ArrayExpr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
