<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/CallExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/CallExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: CallExpr.m3                                           

<P><PRE>MODULE <module><implements><A HREF="CallExpr.i3">CallExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/ProcType.i3">ProcType</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../types/UserProc.i3">UserProc</A>;
IMPORT <A HREF="KeywordExpr.i3">KeywordExpr</A>, <A HREF="../misc/ESet.i3">ESet</A>, <A HREF="QualifyExpr.i3">QualifyExpr</A>, <A HREF="../builtinTypes/ErrType.i3">ErrType</A>, <A HREF="../values/Value.i3">Value</A>;

REVEAL
  <A NAME="MethodList">MethodList</A> = BRANDED &quot;CallExpr.MethodList&quot; REF RECORD
                 minArgs      : INTEGER;
                 maxArgs      : INTEGER;
                 functional   : BOOLEAN;
                 keywords     : BOOLEAN;
                 strict       : BOOLEAN;
                 fixedType    : Type.T;
                 typeOf       : Typer;
                 need_addr    : Visitor;
                 checker      : TypeChecker;
                 prep         : Compiler;
                 compiler     : Compiler;
                 prepLV       : CompilerLV;
                 compilerLV   : CompilerLV;
                 prepBR       : CompilerBR;
                 compilerBR   : CompilerBR;
                 evaluator    : Evaluator;
                 isWritable   : Predicate;
                 isDesignator : Predicate;
                 noteWriter   : NoteWriter;
               END;

REVEAL
  <A NAME="T">T</A> = T_ BRANDED &quot;CallExpr.P&quot; OBJECT
	methods  : MethodList;
        proc_type: Type.T;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := Prep;
        compile      := Compile;
        prepLV       := PrepLV;
        compileLV    := CompileLV;
        prepBR       := PrepBR;
        compileBR    := CompileBR;
        evaluate     := Fold;
        isEqual      := ExprRep.NeverEq;
        getBounds    := ExprRep.NoBounds;
        isWritable   := IsWritable;
        isDesignator := IsDesignator;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
	note_write   := NoteWrites;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (proc: Expr.T;  args: Expr.List): Expr.T =
  VAR p := NEW (T);
  BEGIN
    ExprRep.Init (p);
    p.proc     := proc;
    p.args     := args;
    p.tmp      := NIL;
    p.methods  := NIL;
    p.proc_type:= NIL;
    RETURN p;
  END New;

PROCEDURE <A NAME="Is"><procedure>Is</procedure></A> (e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
      | NULL =&gt; RETURN FALSE;
      | T    =&gt; RETURN TRUE;
      ELSE      RETURN FALSE;
    END;
  END Is;

PROCEDURE <A NAME="NewMethodList"><procedure>NewMethodList</procedure></A> (minArgs, maxArgs: INTEGER;
                         functional   : BOOLEAN;
                         keywords     : BOOLEAN;
                         strict       : BOOLEAN;
                         fixedType    : Type.T;
                         typeOf       : Typer;
                         need_addr    : Visitor;
                         checker      : TypeChecker;
                         prep         : Compiler;
			 compiler     : Compiler;
                         prepLV       : CompilerLV;
			 compilerLV   : CompilerLV;
                         prepBR       : CompilerBR;
			 compilerBR   : CompilerBR;
                         evaluator    : Evaluator;
                         isWritable   : Predicate;
                         isDesignator : Predicate;
                         noteWriter   : NoteWriter): MethodList =
  VAR m: MethodList;
  BEGIN
    m := NEW (MethodList);
    m.minArgs      := minArgs;
    m.maxArgs      := maxArgs;
    m.functional   := functional;
    m.keywords     := keywords;
    m.strict       := strict;
    m.fixedType    := fixedType;
    m.typeOf       := typeOf;
    m.need_addr    := need_addr;
    m.checker      := checker;
    m.prep         := prep;
    m.compiler     := compiler;
    m.prepLV       := prepLV;
    m.compilerLV   := compilerLV;
    m.prepBR       := prepBR;
    m.compilerBR   := compilerBR;
    m.evaluator    := evaluator;
    m.isWritable   := isWritable;
    m.isDesignator := isDesignator;
    m.noteWriter   := noteWriter;
    RETURN m;
  END NewMethodList;

PROCEDURE <A NAME="IsNever"><procedure>IsNever</procedure></A> (&lt;*UNUSED*&gt; t: T): BOOLEAN =
  BEGIN
    RETURN FALSE;
  END IsNever;

PROCEDURE <A NAME="IsAlways"><procedure>IsAlways</procedure></A> (&lt;*UNUSED*&gt; t: T): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END IsAlways;

PROCEDURE <A NAME="NoValue"><procedure>NoValue</procedure></A> (&lt;*UNUSED*&gt; t: T): Expr.T =
  BEGIN
    RETURN NIL;
  END NoValue;

PROCEDURE <A NAME="NotAddressable"><procedure>NotAddressable</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NotAddressable;

PROCEDURE <A NAME="PrepArgs"><procedure>PrepArgs</procedure></A> (t: T) =
  BEGIN
    FOR i := 0 TO LAST (t.args^) DO
      Expr.Prep (t.args[i]);
    END;
  END PrepArgs;

PROCEDURE <A NAME="NoLValue"><procedure>NoLValue</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    &lt;*ASSERT FALSE*&gt;
  END NoLValue;

PROCEDURE <A NAME="NotBoolean"><procedure>NotBoolean</procedure></A> (&lt;*UNUSED*&gt; t: T;
                      &lt;*UNUSED*&gt; true, false: CG.Label;
                      &lt;*UNUSED*&gt; freq: CG.Frequency) =
  BEGIN
    &lt;*ASSERT FALSE*&gt;
  END NotBoolean;

PROCEDURE <A NAME="PrepNoBranch"><procedure>PrepNoBranch</procedure></A> (t: T;  true, false: CG.Label;  freq: CG.Frequency) =
  BEGIN
    t.prep ();
    t.compile ();
    IF (true # CG.No_label)
      THEN CG.If_true (true, freq);
      ELSE CG.If_false (false, freq);
    END;
  END PrepNoBranch;

PROCEDURE <A NAME="NoBranch"><procedure>NoBranch</procedure></A> (&lt;*UNUSED*&gt; t: T;
                    &lt;*UNUSED*&gt; true, false: CG.Label;
                    &lt;*UNUSED*&gt; freq: CG.Frequency) =
  BEGIN
    (* all the work was done by prep *)
  END NoBranch;

PROCEDURE <A NAME="NotWritable"><procedure>NotWritable</procedure></A> (&lt;*UNUSED*&gt; t: T)=
  BEGIN
    (* skip *)
  END NotWritable;
</PRE>*********************************************************************

<P><PRE>PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (p: T) =
  VAR t: Type.T;
  BEGIN
    IF (p.methods # NIL) THEN RETURN END;
    t := Expr.TypeOf (p.proc);
    IF (t = NIL) THEN
      t := QualifyExpr.MethodType (p.proc);
      (* we need this hack because &quot;TypeOf(obj.method)&quot; returns NIL
         so that you can't use it as a vanilla procedure value. *)
    END;
    p.methods := ProcType.Methods (t);
    p.proc_type := t;
  END Resolve;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: T): Type.T =
  BEGIN
    Resolve (p);
    IF (p.methods = NIL) THEN
      p.type := NIL;
    ELSIF (p.methods.fixedType # NIL) OR (p.methods.typeOf = NIL) THEN
      p.type := p.methods.fixedType;
    ELSE
      FixArgs (p);
      p.type := p.methods.typeOf (p);
    END;
    RETURN p.type;
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: T;  VAR cs: Expr.CheckState) =
  VAR
    nErrs0, nErrs1, nWarns: INTEGER;
    arg: Expr.T;
    keywords: BOOLEAN;
  BEGIN
    (* check the procedure *)
    Error.Count (nErrs0, nWarns);
    Expr.TypeCheck (p.proc, cs);
    Resolve (p);
    Error.Count (nErrs1, nWarns);
    IF (p.methods = NIL) AND (nErrs0 = nErrs1) THEN
      Error.Msg (&quot;attempting to call a non-procedure&quot; &amp; ProcName (p));
      p.type := ErrType.T;
    END;

    (* check its args *)
    keywords := (p.methods = NIL) OR (p.methods.keywords);
    FOR i := 0 TO LAST (p.args^) DO
      arg := p.args[i];
      Expr.TypeCheck (arg, cs);
      IF (Expr.TypeOf (arg) = ErrType.T) THEN
        p.type := ErrType.T;
      ELSIF (NOT keywords) AND KeywordExpr.Is (arg) THEN
        Error.Msg (&quot;keyword parameters not allowed on builtin operations&quot; &amp;
                   ProcName (p));
      END;
    END;

    (* finally, do the procedure specific checking *)
    IF (p.type # ErrType.T) AND (p.methods # NIL) THEN
      FixArgs (p);
      p.methods.checker (p, cs);
    END;

    (* check the exceptions *)
    ESet.NoteExceptions (cs, ProcType.Raises (p.proc_type));
  END Check;

PROCEDURE <A NAME="FixArgs"><procedure>FixArgs</procedure></A> (p: T) =
  VAR z: Expr.List;
  BEGIN
    IF (NUMBER (p.args^) &lt; p.methods.minArgs) THEN
      Error.Msg (&quot;too few arguments&quot; &amp; ProcName (p));
      z := NEW (Expr.List, p.methods.minArgs);
      FOR i := 0 TO LAST (p.args^) DO z[i] := p.args[i] END;
      p.args := z;
    ELSIF (NUMBER (p.args^) &gt; p.methods.maxArgs) THEN
      Error.Msg (&quot;too many arguments&quot; &amp; ProcName (p));
      z := NEW (Expr.List, p.methods.maxArgs);
      FOR i := 0 TO p.methods.maxArgs - 1 DO z[i] := p.args[i] END;
      p.args := z;
    END;
  END FixArgs;

PROCEDURE <A NAME="ProcName"><procedure>ProcName</procedure></A> (p: T): TEXT =
  VAR v: Value.T;
  BEGIN
    IF (p.proc # NIL) AND UserProc.IsProcedureLiteral (p.proc, v) THEN
      RETURN &quot;: &quot; &amp; Value.GlobalName (v, dots := TRUE, with_module := TRUE);
    ELSE
      RETURN &quot;&quot;;
    END;
  END ProcName;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (p: T) =
  BEGIN
    IF (p.methods # NIL) THEN
      p.methods.need_addr (p);
    END;
  END NeedsAddress;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: T) =
  BEGIN
    p.methods.prep (p);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: T) =
  BEGIN
    p.methods.compiler (p);
  END Compile;

PROCEDURE <A NAME="PrepLV"><procedure>PrepLV</procedure></A> (p: T) =
  BEGIN
    p.methods.prepLV (p);
  END PrepLV;

PROCEDURE <A NAME="CompileLV"><procedure>CompileLV</procedure></A> (p: T) =
  BEGIN
    p.methods.compilerLV (p);
  END CompileLV;

PROCEDURE <A NAME="PrepBR"><procedure>PrepBR</procedure></A> (p: T;  true, false: CG.Label;  freq: CG.Frequency) =
  BEGIN
    p.methods.prepBR (p, true, false, freq);
  END PrepBR;

PROCEDURE <A NAME="CompileBR"><procedure>CompileBR</procedure></A> (p: T;  true, false: CG.Label;  freq: CG.Frequency) =
  BEGIN
    p.methods.compilerBR (p, true, false, freq);
  END CompileBR;

PROCEDURE <A NAME="NoteWrites"><procedure>NoteWrites</procedure></A> (p: T) =
  BEGIN
    IF p.methods # NIL THEN
      p.methods.noteWriter (p);
    END;
  END NoteWrites;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: T): Expr.T =
  BEGIN
    Resolve (p);
    IF (p.methods = NIL) THEN RETURN NIL END;
    RETURN p.methods.evaluator (p);
  END Fold;

PROCEDURE <A NAME="IsDesignator"><procedure>IsDesignator</procedure></A> (p: T): BOOLEAN =
  BEGIN
    Resolve (p);
    IF p.methods = NIL THEN RETURN FALSE END;
    RETURN p.methods.isDesignator (p);
  END IsDesignator;

PROCEDURE <A NAME="IsWritable"><procedure>IsWritable</procedure></A> (p: T): BOOLEAN =
  BEGIN
    Resolve (p);
    IF p.methods = NIL THEN RETURN FALSE END;
    RETURN p.methods.isWritable (p);
  END IsWritable;

BEGIN
END CallExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
