<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/CastExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/CastExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: CastExpr.m3                                           
 Last Modified On Wed Jun 29 17:09:10 PDT 1994 By kalsow     
      Modified On Sun Dec 23 08:07:22 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="CastExpr.i3">CastExpr</A></implements></module>;

IMPORT <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/OpenArrayType.i3">OpenArrayType</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

TYPE
  Kind = {
    Noop,    (* code generator cannot tell the difference *)
    D_to_A,  (* designator -&gt; open array *)
    S_to_A,  (* structure -&gt; open array *)
    V_to_A,  (* value -&gt; open array *)
    D_to_S,  (* designator -&gt; structure *)
    S_to_S,  (* structure -&gt; structure *)
    V_to_S,  (* value -&gt; structure *)
    D_to_V,  (* designator -&gt; value *)
    S_to_V,  (* structure -&gt; value *)
    V_to_V   (* value -&gt; value *)
  };

TYPE
  P = Expr.T BRANDED &quot;CastExpr&quot; OBJECT
        kind    : Kind;
        expr    : Expr.T;
	tipe    : Type.T;
        tmp     : CG.Var;
        tmp_cnt : INTEGER;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := Prep;
        compile      := Compile;
        prepLV       := PrepLV;
        compileLV    := CompileLV;
        prepBR       := ExprRep.PrepNoBranch;
        compileBR    := ExprRep.NoBranch;
        evaluate     := Fold;
        isEqual      := EqCheck;
        getBounds    := Bounder;
        isWritable   := IsWritable;
        isDesignator := IsDesignator;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := GenFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := NoteWrites;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a: Expr.T;  t: Type.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.origin := a.origin;
    p.expr   := a;
    p.tipe   := t;
    p.type   := t;
    p.tmp    := NIL;
    p.tmp_cnt:= 0;
    RETURN p;
  END New;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR
    src, dest, elt: Type.T;  sz0, sz1: INTEGER;
    array_out, desig_in, struct_in, struct_out: BOOLEAN;
    align_in, align_out: INTEGER;
    dest_info, src_info, elt_info: Type.Info;
  BEGIN
    Expr.TypeCheck (p.expr, cs);
    p.tipe := Type.CheckInfo (p.tipe, dest_info);

    src        := Type.CheckInfo (Expr.TypeOf (p.expr), src_info);
    dest       := p.tipe;
    desig_in   := Expr.IsDesignator (p.expr);
    struct_in  := Type.IsStructured (src);
    struct_out := Type.IsStructured (dest);
    array_out  := OpenArrayType.Split (dest, elt);
    align_in   := src_info.alignment;
    align_out  := dest_info.alignment;

    (* check to see that the value is legal *)
    IF (src_info.class = Type.Class.OpenArray) THEN
      Error.Msg (&quot;LOOPHOLE: first argument cannot be an open array&quot;);
    END;
    sz0 := src_info.size;

    (* check to see that the destination type is legal *)
    IF array_out THEN
      (* open array type *)
      elt := Type.CheckInfo (elt, elt_info);
      IF (elt_info.class = Type.Class.OpenArray) THEN
        Error.Msg (&quot;LOOPHOLE: multidimensional open arrays not supported&quot;);
      END;
      sz1 := elt_info.size;
      IF (sz1 &lt;= 0) OR ((sz0 MOD sz1) # 0) THEN
        Error.Msg (&quot;LOOPHOLE: expression's size incompatible with type's&quot;);
      END;
      align_out := elt_info.alignment;
    ELSE
      (* fixed size type *)
      sz1 := dest_info.size;
      IF (sz0 # sz1) THEN
        Error.Msg (&quot;LOOPHOLE: expression's size differs from type's&quot;);
      END;
    END;

    (* check for alignment problems *)
    IF (align_in &lt; align_out) OR (align_in MOD align_out # 0) THEN
      Error.Warn(1,&quot;LOOPHOLE: expression's alignment may differ from type's&quot;);
    END;

    (* classify the type of LOOPHOLE operation *)

    IF array_out THEN
      IF desig_in THEN
        p.kind := Kind.D_to_A;
      ELSIF struct_in THEN
        p.kind := Kind.S_to_A;
      ELSE
        p.kind := Kind.V_to_A;
      END;
    ELSIF (src_info.cg_type = dest_info.cg_type) THEN
      p.kind := Kind.Noop;
    ELSIF struct_out THEN
      IF desig_in THEN
        p.kind := Kind.D_to_S;
      ELSIF struct_in THEN
        p.kind := Kind.S_to_S;
      ELSE
        p.kind := Kind.V_to_S;
      END;
    ELSIF struct_in THEN
      p.kind := Kind.S_to_V;
    ELSIF desig_in THEN
      p.kind := Kind.D_to_V;
    ELSE
      p.kind := Kind.V_to_V;
    END;

    IF (p.kind = Kind.D_to_A) OR (p.kind = Kind.D_to_S) THEN
      (* we're going to take the address of this value *)
      Expr.NeedsAddress (p.expr);
    END;
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN Type.IsEqual (a.tipe, b.tipe, NIL)
                 AND Expr.IsEqual (a.expr, b.expr);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (p: P) =
  BEGIN
    CASE p.kind OF
    | Kind.Noop,
      Kind.D_to_S,
      Kind.S_to_S,
      Kind.D_to_V,
      Kind.S_to_V,
      Kind.V_to_V =&gt;
        Expr.NeedsAddress (p.expr);

    | Kind.D_to_A,
      Kind.S_to_A,
      Kind.V_to_A,
      Kind.V_to_S =&gt;
        (* ok, cause we build a temporary *)
    END;
  END NeedsAddress;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  VAR
    e  := p.expr;
    u  := Expr.TypeOf (e);
    t  := p.tipe;
    t1 : CG.Var;
    sz, t_align, u_align, z_align: INTEGER;
    t_cg, u_cg: CG.Type;
    u_info, t_info: Type.Info;
  BEGIN
    IF (p.tmp_cnt &gt; 0) THEN  INC (p.tmp_cnt);  RETURN;  END;
    u := Type.CheckInfo (u, u_info);
    t := Type.CheckInfo (t, t_info);
    t_cg := t_info.cg_type;  t_align := t_info.alignment;
    u_cg := u_info.cg_type;  u_align := u_info.alignment;
    sz := u_info.size;
    Type.Compile (t);
    Type.Compile (u);
    z_align := MAX (t_align, u_align);

    CASE p.kind OF
    | Kind.Noop =&gt;
        Expr.Prep (e);
    | Kind.D_to_A =&gt;
        INC (p.tmp_cnt);
        Expr.PrepLValue (e);
        Expr.CompileAddress (e);
        p.tmp := BuildArray (p, sz);
    | Kind.S_to_A =&gt;
        INC (p.tmp_cnt);
        Expr.Prep (e);
        Expr.Compile (e);
        p.tmp := BuildArray (p, sz);
    | Kind.V_to_A =&gt;
        (* copy the value to a temporary *)
        INC (p.tmp_cnt);
        Expr.Prep (e);
        t1 := CG.Declare_local (M3ID.NoID, sz, z_align, u_cg,
                                Type.GlobalUID (u),
                                in_memory := TRUE, up_level := FALSE,
                                f := CG.Never);
        Expr.Compile (e);
        CG.Store (t1, 0, sz, z_align, u_cg);
        CG.Load_addr_of (t1, 0, z_align);
        p.tmp := BuildArray (p, sz);
    | Kind.D_to_S =&gt;
        Expr.PrepLValue (e);
    | Kind.S_to_S =&gt;
        Expr.Prep (e);
    | Kind.V_to_S =&gt;
        INC (p.tmp_cnt);
        Expr.Prep (e);
        p.tmp := CG.Declare_temp (sz, z_align, t_cg, in_memory := TRUE);
        Expr.Compile (e);
        CG.Store (p.tmp, 0, sz, z_align, u_cg);
    | Kind.D_to_V =&gt;
        Expr.Prep (e);
    | Kind.S_to_V =&gt;
        Expr.Prep (e);
    | Kind.V_to_V =&gt;
        Expr.Prep (e);
    END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR
    e  := p.expr;
    u  := Expr.TypeOf (e);
    t  := p.tipe;
    sz, t_align, u_align, z_align: INTEGER;
    t_cg, u_cg: CG.Type;
    u_info, t_info: Type.Info;
  BEGIN
    u := Type.CheckInfo (u, u_info);
    t := Type.CheckInfo (t, t_info);
    t_cg := t_info.cg_type;  t_align := t_info.alignment;
    u_cg := u_info.cg_type;  u_align := u_info.alignment;
    sz := u_info.size;
    Type.Compile (t);
    Type.Compile (u);
    z_align := MAX (t_align, u_align);

    CASE p.kind OF
    | Kind.Noop =&gt;
        Expr.Compile (e);
        CG.Boost_alignment (t_align);
    | Kind.D_to_A,
      Kind.S_to_A,
      Kind.V_to_A =&gt;
        PushTmp (p, t_align);
    | Kind.D_to_S =&gt;
        Expr.CompileAddress (e);
        CG.Boost_alignment (t_align);
    | Kind.S_to_S =&gt;
        Expr.Compile (e);
        CG.Boost_alignment (t_align);
    | Kind.V_to_S =&gt;
        PushTmp (p, z_align);
    | Kind.D_to_V =&gt;
        Expr.Compile (e);
        CG.Loophole (u_cg, t_cg);
        (*** back-ends have problems with this 'cause floating-point
           variables may be in floating-point registers...
        Expr.PrepLValue (e);
        Expr.CompileLValue (e);
        CG.Boost_alignment (t_align);
        CG.Load_indirect (t_cg, 0, sz);
        ******)
    | Kind.S_to_V =&gt;
        Expr.Compile (e);
        CG.Boost_alignment (t_align);
        CG.Load_indirect (t_cg, 0, sz);
    | Kind.V_to_V =&gt;
        Expr.Compile (e);
        CG.Loophole (u_cg, t_cg);
    END;
  END Compile;

PROCEDURE <A NAME="PushTmp"><procedure>PushTmp</procedure></A> (p: P;  align: INTEGER) =
  BEGIN
    DEC (p.tmp_cnt);
    IF (p.tmp_cnt &lt;= 0) THEN
      CG.Load_addr_of_temp (p.tmp, 0, align);
      p.tmp := NIL;
    ELSE
      CG.Load_addr_of (p.tmp, 0, align);
    END;
  END PushTmp;

PROCEDURE <A NAME="BuildArray"><procedure>BuildArray</procedure></A> (p: P;  src_size: INTEGER): CG.Var =
  VAR
    array : CG.Var;
    elt   := OpenArrayType.OpenType (p.tipe);
    elt_info: Type.Info;
  BEGIN
    elt := Type.CheckInfo (elt, elt_info);
    (** CG.Check_byte_aligned (); **)
    array := OpenArrayType.DeclareTemp (p.tipe);
    CG.Store_addr (array, M3RT.OA_elt_ptr);
    CG.Load_intt (src_size DIV elt_info.size);
    CG.Store_int (array, M3RT.OA_size_0);
    RETURN array;
  END BuildArray;

PROCEDURE <A NAME="PrepLV"><procedure>PrepLV</procedure></A> (p: P) =
  VAR
    e  := p.expr;
    u  := Expr.TypeOf (e);
    t  := p.tipe;
    sz, t_align, u_align, z_align: INTEGER;
    t_cg, u_cg: CG.Type;
    t1 : CG.Var;
    u_info, t_info: Type.Info;
  BEGIN
    IF (p.tmp_cnt &gt; 0) THEN  INC (p.tmp_cnt);  RETURN;  END;
    u := Type.CheckInfo (u, u_info);
    t := Type.CheckInfo (t, t_info);
    t_align := t_info.alignment;
    u_align := u_info.alignment;
    z_align := MAX (t_align, u_align);
    t_cg := t_info.cg_type;
    u_cg := u_info.cg_type;
    sz := u_info.size;
    Type.Compile (t);
    Type.Compile (u);

    CASE p.kind OF
    | Kind.Noop,
      Kind.D_to_S,
      Kind.S_to_S,
      Kind.D_to_V,
      Kind.S_to_V,
      Kind.V_to_V =&gt;
        Expr.PrepLValue (p.expr);

    | Kind.D_to_A =&gt;
        INC (p.tmp_cnt);
        Expr.PrepLValue (e);
        Expr.CompileLValue (e);
        p.tmp := BuildArray (p, sz);
    | Kind.S_to_A =&gt;
        INC (p.tmp_cnt);
        Expr.Prep (e);
        Expr.Compile (e);
        p.tmp := BuildArray (p, sz);
    | Kind.V_to_A =&gt;
        (* copy the value to a temporary *)
        INC (p.tmp_cnt);
        Expr.Prep (e);
        t1 := CG.Declare_local (M3ID.NoID, sz, z_align, u_cg,
                                Type.GlobalUID (u),
                                in_memory := TRUE, up_level := FALSE,
                                f := CG.Never);
        Expr.Compile (e);
        CG.Store (t1, 0, sz, z_align, u_cg);
        CG.Load_addr_of (t1, 0, z_align);
        p.tmp := BuildArray (p, sz);
    | Kind.V_to_S =&gt;
        INC (p.tmp_cnt);
        Expr.Prep (e);
        p.tmp := CG.Declare_temp (sz, z_align, t_cg, in_memory := TRUE);
        Expr.Compile (e);
        CG.Store (p.tmp, 0, sz, z_align, u_cg);
    END;
  END PrepLV;

PROCEDURE <A NAME="CompileLV"><procedure>CompileLV</procedure></A> (p: P) =
  VAR
    e  := p.expr;
    u  := Expr.TypeOf (e);
    t  := p.tipe;
    sz, t_align, u_align, z_align: INTEGER;
    u_cg: CG.Type;
    u_info, t_info: Type.Info;
  BEGIN
    u := Type.CheckInfo (u, u_info);
    t := Type.CheckInfo (t, t_info);
    t_align := t_info.alignment;
    u_align := u_info.alignment;
    z_align := MAX (t_align, u_align);
    u_cg := u_info.cg_type;
    sz := u_info.size;
    Type.Compile (t);
    Type.Compile (u);

    CASE p.kind OF
    | Kind.Noop,
      Kind.D_to_S,
      Kind.S_to_S,
      Kind.D_to_V,
      Kind.S_to_V,
      Kind.V_to_V =&gt;
        Expr.CompileLValue (p.expr);
        CG.Boost_alignment (t_align);

    | Kind.D_to_A,
      Kind.S_to_A,
      Kind.V_to_A =&gt;
        PushTmp (p, t_align);
    | Kind.V_to_S =&gt;
        PushTmp (p, z_align);
    END;
  END CompileLV;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e: Expr.T;
  BEGIN
    e := Expr.ConstValue (p.expr);
    IF (e = NIL) THEN RETURN NIL END;
    p.expr := e;
    RETURN p;
  END Fold;

PROCEDURE <A NAME="Bounder"><procedure>Bounder</procedure></A> (p: P;  VAR min, max: Target.Int) =
  VAR min1, max1: Target.Int;
  BEGIN
    Expr.GetBounds (p.expr, min, max);
    EVAL Type.GetBounds (p.tipe, min1, max1);
    IF TInt.LT (min, min1) THEN min := min1 END;
    IF TInt.LT (max1, max) THEN max := max1 END;
  END Bounder;

PROCEDURE <A NAME="IsDesignator"><procedure>IsDesignator</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN Expr.IsDesignator (p.expr);
  END IsDesignator;

PROCEDURE <A NAME="IsWritable"><procedure>IsWritable</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN Expr.IsWritable (p.expr);
  END IsWritable;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  BEGIN
    Expr.GenFPLiteral (p.expr, buf);
  END GenFPLiteral;

PROCEDURE <A NAME="NoteWrites"><procedure>NoteWrites</procedure></A> (p: P) =
  BEGIN
    Expr.NoteWrite (p.expr);
  END NoteWrites;

BEGIN
END CastExpr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
