<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/CheckExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/CheckExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: CheckExpr.m3                                          
 Last Modified On Tue Aug 16 08:19:24 PDT 1994 By kalsow     
      Modified On Fri Feb 15 04:03:38 1991 By muller         

<P><PRE>MODULE <module><implements><A HREF="CheckExpr.i3">CheckExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="IntegerExpr.i3">IntegerExpr</A>, <A HREF="EnumExpr.i3">EnumExpr</A>, <A HREF="../misc/Host.i3">Host</A>;
IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../misc/Error.i3">Error</A>;

TYPE
  Class = { cLOWER, cUPPER, cBOTH };

TYPE
  P = Expr.T OBJECT
        expr  : Expr.T;
        min   : Target.Int;
        max   : Target.Int;
        class : Class;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.PrepNoBranch;
        compileBR    := ExprRep.NoBranch;
        evaluate     := Fold;
        isEqual      := EqCheck;
        getBounds    := Bounder;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a: Expr.T;  READONLY min, max: Target.Int): Expr.T =
  BEGIN
    RETURN Create (a, min, max, Class.cBOTH);
  END New;

PROCEDURE <A NAME="NewLower"><procedure>NewLower</procedure></A> (a: Expr.T;  READONLY min: Target.Int): Expr.T =
  BEGIN
    RETURN Create (a, min, TInt.Zero, Class.cLOWER);
  END NewLower;

PROCEDURE <A NAME="NewUpper"><procedure>NewUpper</procedure></A> (a: Expr.T;  READONLY max: Target.Int): Expr.T =
  BEGIN
    RETURN Create (a, TInt.Zero, max, Class.cUPPER);
  END NewUpper;

PROCEDURE <A NAME="Create"><procedure>Create</procedure></A> (a: Expr.T; READONLY min, max: Target.Int; c: Class): Expr.T =
  VAR p: P;
  BEGIN
    IF (NOT Host.doRangeChk) THEN RETURN a END;
    p := NEW (P);
    ExprRep.Init (p);
    p.expr   := a;
    p.min    := min;
    p.max    := max;
    p.class  := c;
    p.origin := a.origin;
    RETURN p;
  END Create;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  BEGIN
    RETURN Expr.TypeOf (p.expr);
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  BEGIN
    Expr.TypeCheck (p.expr, cs);
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN (a.class = b.class)
                 AND (a.min = b.min)
                 AND (a.max = b.max)
                 AND Expr.IsEqual (a.expr, b.expr);
    ELSE RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  BEGIN
    Expr.Prep (p.expr);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    Expr.Compile (p.expr);
    CASE p.class OF
    | Class.cLOWER =&gt; CG.Check_lo (p.min);
    | Class.cUPPER =&gt; CG.Check_hi (p.max);
    | Class.cBOTH  =&gt; CG.Check_range (p.min, p.max);
    END;
  END Compile;

PROCEDURE <A NAME="Emit"><procedure>Emit</procedure></A> (e: Expr.T;  READONLY min, max: Target.Int) =
  VAR minE, maxE: Target.Int;  x: Expr.T;
  BEGIN
    x := Expr.ConstValue (e);
    IF (x # NIL) THEN e := x;  END;
    Expr.Compile (e);
    IF Host.doRangeChk THEN
      Expr.GetBounds (e, minE, maxE);
      IF TInt.LT (minE, min) AND TInt.LT (max, maxE) THEN
        CG.Check_range (min, max);
      ELSIF TInt.LT (minE, min) THEN
        IF TInt.LT (maxE, min) THEN
          Error.Warn (2, &quot;value out of range&quot;);
        END;
        CG.Check_lo (min);
      ELSIF TInt.LT (max, maxE) THEN
        IF TInt.LT (max, minE) THEN
          Error.Warn (2, &quot;value out of range&quot;);
        END;
        CG.Check_hi (max);
      END;
    END;
  END Emit;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e: Expr.T;  i: Target.Int;  t: Type.T;
  BEGIN
    e := Expr.ConstValue (p.expr);
    IF (e = NIL) THEN RETURN NIL END;
    IF (NOT IntegerExpr.Split (e, i))
      AND (NOT EnumExpr.Split (e, i, t)) THEN
      RETURN NIL;
    END;
    CASE p.class OF
    | Class.cLOWER =&gt; IF TInt.LT (i, p.min) THEN RETURN NIL END;
    | Class.cUPPER =&gt; IF TInt.LT (p.max, i) THEN RETURN NIL END;
    | Class.cBOTH  =&gt; IF TInt.LT (i, p.min)
                      OR TInt.LT (p.max, i) THEN RETURN NIL END;
    END;
    RETURN e;
  END Fold;

PROCEDURE <A NAME="Bounder"><procedure>Bounder</procedure></A> (p: P;  VAR min, max: Target.Int) =
  BEGIN
    Expr.GetBounds (p.expr, min, max);
    CASE p.class OF
    | Class.cLOWER =&gt; IF TInt.LT (min, p.min) THEN min := p.min END;
    | Class.cUPPER =&gt; IF TInt.LT (p.max, max) THEN max := p.max END;
    | Class.cBOTH  =&gt; IF TInt.LT (min, p.min) THEN min := p.min END;
                      IF TInt.LT (p.max, max) THEN max := p.max END;
    END;
  END Bounder;

BEGIN
END CheckExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
