<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/ConcatExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/ConcatExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ConcatExpr.m3                                         

<P><PRE>MODULE <module><implements><A HREF="ConcatExpr.i3">ConcatExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Textt.i3">Textt</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;
IMPORT <A HREF="TextExpr.i3">TextExpr</A>, <A HREF="../stmts/AssignStmt.i3">AssignStmt</A>, <A HREF="../misc/Host.i3">Host</A>, <A HREF="../builtinOps/Narrow.i3">Narrow</A>, <A HREF="../misc/Runtime.i3">Runtime</A>, <A HREF="../misc/Error.i3">Error</A>;

TYPE
  P = ExprRep.Tab BRANDED &quot;ConcatExpr.P&quot; OBJECT
        folded : Expr.T;
        tmp    : CG.Val;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := ExprRep.EqCheckAB;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a, b: Expr.T): Expr.T =
  VAR p := NEW (P);
  BEGIN
    ExprRep.Init (p);
    p.a := a;
    p.b := b;
    p.folded := NIL;
    p.type := Textt.T;
    p.tmp := NIL;
    RETURN p;
  END New;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR ta, tb: Type.T;  a, b: INTEGER;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    Expr.TypeCheck (p.b, cs);
    ta := Type.Base (Expr.TypeOf (p.a));
    tb := Type.Base (Expr.TypeOf (p.b));

    IF Type.IsAssignable (Textt.T, ta) AND Type.IsAssignable (Textt.T, tb) THEN
      AssignStmt.Check (Textt.T, p.a, cs);
      AssignStmt.Check (Textt.T, p.b, cs);
    ELSE
      p.type := Expr.BadOperands (&quot;\'&amp;\'&quot;, ta, tb);
    END;

    Error.Count (a, b);
    IF (a = 0) THEN
      EVAL Fold (p); (* try folding all concatenations *)
    END;

    IF (p.folded # NIL) THEN Expr.TypeCheck (p.folded, cs) END;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  VAR proc: Procedure.T;
  BEGIN
    IF (p.folded # NIL) THEN
      Expr.Prep (p.folded);
    ELSE
      Expr.Prep (p.a);
      Expr.Prep (p.b);
      proc := Runtime.LookUpProc (Runtime.Hook.Concat);
      Procedure.StartCall (proc);
      IF Target.DefaultCall.args_left_to_right THEN
        Expr.Compile (p.a);
        IF Host.doNarrowChk THEN Narrow.Emit (Textt.T, Expr.TypeOf (p.a)) END;
        CG.Pop_param (CG.Type.Addr);
        Expr.Compile (p.b);
        IF Host.doNarrowChk THEN Narrow.Emit (Textt.T, Expr.TypeOf (p.b)) END;
        CG.Pop_param (CG.Type.Addr);
      ELSE
        Expr.Compile (p.b);
        IF Host.doNarrowChk THEN Narrow.Emit (Textt.T, Expr.TypeOf (p.b)) END;
        CG.Pop_param (CG.Type.Addr);
        Expr.Compile (p.a);
        IF Host.doNarrowChk THEN Narrow.Emit (Textt.T, Expr.TypeOf (p.a)) END;
        CG.Pop_param (CG.Type.Addr);
      END;
      p.tmp := Procedure.EmitCall (proc);
    END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    IF (p.folded # NIL) THEN
      Expr.Compile (p.folded);
    ELSE
      CG.Push (p.tmp);
      CG.Boost_alignment (Target.Address.align);
      CG.Free (p.tmp);
      p.tmp := NIL;
    END;
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e1, e2, e3: Expr.T;
  BEGIN
    IF (p.folded # NIL) THEN RETURN p.folded END;
    e1 := Expr.ConstValue (p.a);
    IF (e1 = NIL) THEN RETURN NIL END;
    p.a := e1;
    e2 := Expr.ConstValue (p.b);
    IF (e2 = NIL) THEN RETURN NIL END;
    p.b := e2;
    e3 := NIL;
    IF TextExpr.Cat (e1, e2, e3) THEN p.folded := e3 END;
    RETURN e3;
  END Fold;

BEGIN
END ConcatExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
