<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/ConsExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/ConsExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ConsExpr.m3                                           

<P><PRE>MODULE <module><implements><A HREF="ConsExpr.i3">ConsExpr</A></implements></module>;

IMPORT <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/Type.i3">Type</A>;
IMPORT <A HREF="TypeExpr.i3">TypeExpr</A>, <A HREF="SetExpr.i3">SetExpr</A>, <A HREF="RecordExpr.i3">RecordExpr</A>, <A HREF="ArrayExpr.i3">ArrayExpr</A>;

TYPE
  Kind = { Unknown, Record, Set, Array };

TYPE
  P = Expr.T BRANDED &quot;ConsExpr.P&quot; OBJECT
        tipe : Expr.T;
        args : Expr.List;
	dots : BOOLEAN;
        base : Expr.T;
        kind : Kind;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (type: Expr.T;  args: Expr.List;  dots: BOOLEAN): Expr.T =
  VAR p := NEW (P);
  BEGIN
    ExprRep.Init (p);
    p.tipe := type;
    p.args := args;
    p.dots := dots;
    p.base := NIL;
    p.kind := Kind.Unknown;
    RETURN p;
  END New;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  VAR ta: Type.T;
  BEGIN
    IF TypeExpr.Split (p.tipe, ta)
      THEN RETURN ta;
      ELSE RETURN Expr.TypeOf (p.tipe);
    END;
  END TypeOf;

PROCEDURE <A NAME="Seal"><procedure>Seal</procedure></A> (p: P) =
  VAR ta: Type.T;  info: Type.Info;
  BEGIN
    IF (p.base # NIL) THEN RETURN END;
    IF NOT TypeExpr.Split (p.tipe, ta) THEN RETURN END;
    ta := Type.Base (ta);  (* strip any BITS FOR packing *)
    ta := Type.CheckInfo (ta, info);
    IF (ta = NIL) THEN
      (* error *)
    ELSIF (info.class = Type.Class.Record) THEN
      p.base := RecordExpr.New (ta, p.args);
      p.kind := Kind.Record;
    ELSIF (info.class = Type.Class.Set) THEN
      p.base := SetExpr.New (ta, p.args);
      p.kind := Kind.Set;
    ELSIF (info.class = Type.Class.Array)
       OR (info.class = Type.Class.OpenArray) THEN
      p.base := ArrayExpr.New (ta, p.args, p.dots);
      p.kind := Kind.Array;
    END;
  END Seal;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  BEGIN
    Seal (p);
    Expr.TypeCheck (p.tipe, cs);
    p.type := TypeOf (p);
    IF (p.kind = Kind.Unknown) THEN
      Error.Msg (&quot;constructor type must be array, record, or set type&quot;);
    ELSIF (p.dots) AND (p.kind # Kind.Array) THEN
      Error.Msg (&quot;trailing \'..\' in constructor, ignored&quot;);
    END;
    FOR i := 0 TO LAST (p.args^) DO Expr.TypeCheck (p.args[i], cs) END;
    Expr.TypeCheck (p.base, cs);
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    Seal (a);
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; Seal (b);  RETURN Expr.IsEqual (a.base, b.base);
    ELSE      RETURN Expr.IsEqual (a.base, e);
    END;
  END EqCheck;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (p: P) =
  BEGIN
    Seal (p);
    Expr.NeedsAddress (p.base);
  END NeedsAddress;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  VAR t: Type.T;
  BEGIN
    Seal (p);
    IF TypeExpr.Split (p.tipe, t) THEN Type.Compile (t) END;
    Expr.Prep (p.base);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    Expr.Compile (p.base);
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  BEGIN
    Seal (p);
    RETURN Expr.ConstValue (p.base);
  END Fold;

BEGIN
END ConsExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
