<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/DerefExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/DerefExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: DerefExpr.m3                                          

<P><PRE>MODULE <module><implements><A HREF="DerefExpr.i3">DerefExpr</A></implements></module>;

IMPORT <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/RefType.i3">RefType</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/Type.i3">Type</A>;
IMPORT <A HREF="NilChkExpr.i3">NilChkExpr</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../builtinTypes/ErrType.i3">ErrType</A>;

TYPE
  P = ExprRep.Ta BRANDED &quot;DerefExpr.P&quot; OBJECT
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := Prep;
        compile      := Compile;
        prepLV       := Prep;
        compileLV    := CompileLV;
        prepBR       := ExprRep.PrepNoBranch;
        compileBR    := ExprRep.NoBranch;
        evaluate     := ExprRep.NoValue;
        isEqual      := ExprRep.EqCheckA;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsAlways;
        isDesignator := ExprRep.IsAlways;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := NoteWrites;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.a := NilChkExpr.New (a);
    p.origin := p.a.origin;
    RETURN p;
  END New;

PROCEDURE <A NAME="SetOffset"><procedure>SetOffset</procedure></A> (e: Expr.T; n: INTEGER) =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; (* nothing *)
    | P(p) =&gt; NilChkExpr.SetOffset (p.a, n);
    ELSE      (* nothing *)
    END;
  END SetOffset;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  VAR ta, target: Type.T;
  BEGIN
    ta := Expr.TypeOf (p.a);
    IF RefType.Split (ta, target)
      THEN RETURN target;
      ELSE RETURN ErrType.T;
    END;
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR ta, target: Type.T;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    ta := Type.Base (Expr.TypeOf (p.a));
    target := NIL;
    IF NOT RefType.Split (ta, target) THEN
      Error.Msg (&quot;cannot dereference a non-REF value&quot;);
      target := ErrType.T;
    ELSIF (target = NIL) THEN
      Error.Msg (&quot;cannot dereference an open REF type&quot;);
      target := ErrType.T;
    END;
    p.type := target;
  END Check;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
    (* ok *)
  END NeedsAddress;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  BEGIN
    Expr.Prep (p.a);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR t := p.type;  info: Type.Info;
  BEGIN
    Expr.Compile (p.a);
    EVAL Type.CheckInfo (t, info);
    CG.Force ();  (*'cause alignment applies to the referent, not the pointer*)
    CG.Boost_alignment (info.alignment);
    Type.LoadScalar (t);
  END Compile;

PROCEDURE <A NAME="CompileLV"><procedure>CompileLV</procedure></A> (p: P) =
  VAR info: Type.Info;
  BEGIN
    Expr.Compile (p.a);
    EVAL Type.CheckInfo (p.type, info);
    CG.Force ();  (*'cause alignment applies to the referent, not the pointer*)
    CG.Boost_alignment (info.alignment);
  END CompileLV;

PROCEDURE <A NAME="NoteWrites"><procedure>NoteWrites</procedure></A> (p: P) =
  BEGIN
    Expr.NoteWrite (p.a);
  END NoteWrites;

BEGIN
END DerefExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
