<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/Expr.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/Expr.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Expr.i3                                               
 Last Modified On Fri Jul  8 09:38:56 PDT 1994 By kalsow     

<P><PRE>INTERFACE <interface><A HREF="Expr.m3">Expr</A></interface>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;

TYPE
  T    = M3.Expr;
  List = REF ARRAY OF T;
  CheckState = M3.CheckState;
</PRE>** phase 1 **

<P><PRE>PROCEDURE <A HREF="Expr.m3#Parse">Parse</A> (): T;
</PRE><BLOCKQUOTE><EM> parses an expression </EM></BLOCKQUOTE><PRE>
</PRE>** phase 2 **

<P><PRE>PROCEDURE <A HREF="Expr.m3#TypeOf">TypeOf</A> (t: T): M3.Type;
</PRE><BLOCKQUOTE><EM> returns the type of the expression </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#TypeCheck">TypeCheck</A> (t: T;  VAR cs: CheckState);
</PRE><BLOCKQUOTE><EM> typechecks the expression. </EM></BLOCKQUOTE><PRE>
</PRE>** phase 3 **

<P><PRE>PROCEDURE <A HREF="Expr.m3#ConstValue">ConstValue</A> (t: T): T;
</PRE><BLOCKQUOTE><EM> Returns NIL if t is not a constant, otherwise returns a simplified
   expression that denotes t.  Value may be called before the expression
   is typechecked. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#GetBounds">GetBounds</A> (t: T;  VAR min, max: Target.Int);
</PRE><BLOCKQUOTE><EM> returns upper and lower bounds for the value of the expression. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#IsDesignator">IsDesignator</A> (t: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE iff t is a designator </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#IsWritable">IsWritable</A> (t: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE iff t is a writable designator </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#IsZeroes">IsZeroes</A> (t: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE if t's binary representation is all zeroes </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#GetSign">GetSign</A> (t: T): CG.Sign;
</PRE><BLOCKQUOTE><EM> returns the best guess of t's sign </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#NeedsAddress">NeedsAddress</A> (t: T);
</PRE><BLOCKQUOTE><EM> marks t as needing an L-value (ie. a memory address). </EM></BLOCKQUOTE><PRE>
</PRE>** phase 4 ***

<P> Expressions are compiled in two steps:
     Prep: emit any code that includes branchs or stores
     Compile: emit the rest of the code


<P><PRE>PROCEDURE <A HREF="Expr.m3#Prep">Prep</A> (t: T);
PROCEDURE <A HREF="Expr.m3#Compile">Compile</A> (t: T);
</PRE><BLOCKQUOTE><EM> emits code to evaluate the expression onto the top of stack </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#PrepLValue">PrepLValue</A> (t: T);
PROCEDURE <A HREF="Expr.m3#CompileLValue">CompileLValue</A> (t: T);
</PRE><BLOCKQUOTE><EM> emits code to evaluate 't's L-value into s0.A. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#CompileAddress">CompileAddress</A> (t: T);
</PRE><BLOCKQUOTE><EM> emits code to evaluate 't's byte address onto the top of stack.
   Use PrepLValue to prep these expressions. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#PrepBranch">PrepBranch</A> (t: T;  true, false: CG.Label;  freq: CG.Frequency);
PROCEDURE <A HREF="Expr.m3#CompileBranch">CompileBranch</A> (t: T;  true, false: CG.Label;  freq: CG.Frequency);
</PRE><BLOCKQUOTE><EM> emits code to evaluate the expression and conditionally branch to 'true'
   or 'false' depending on its boolean value.  'freq' is the estimated
   frequency that the specified branch will be taken. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#NoteWrite">NoteWrite</A> (t: T);
</PRE><BLOCKQUOTE><EM> generates any tracing implied by a write to 't' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#IsEqual">IsEqual</A> (a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE iff (value(a) = value(b)), assuming a constant global store </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#PrepLiteral">PrepLiteral</A> (t: T;  type: M3.Type);
</PRE><BLOCKQUOTE><EM> prepares constant values for GenLiteral </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#GenLiteral">GenLiteral</A> (t: T;  offset: INTEGER;  type: M3.Type);
</PRE><BLOCKQUOTE><EM> initializes the global storage at ADR(x)+offset to the
   constant value t.  For any expression t, PrepLiteral(t) must
   be called before GenLiteral (t).  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#GenFPLiteral">GenFPLiteral</A> (t: T;  mbuf: M3Buf.T);
</PRE><BLOCKQUOTE><EM> add the string denoting the literal value of 't' to 'mbuf' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Expr.m3#BadOperands">BadOperands</A> (op: TEXT;  a, b: M3.Type := NIL): M3.Type;
</PRE><BLOCKQUOTE><EM> generate an <CODE>illegal operands</CODE> error message if neither 'a' nor 'b'
   is the contagious error type and return the error type </EM></BLOCKQUOTE><PRE>

END Expr.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
