<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/Expr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/Expr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Expr.m3                                               
 Last Modified On Tue Aug 16 08:18:41 PDT 1994 By kalsow     
      Modified On Fri Dec 21 01:21:51 1990 By muller         

<P><PRE>MODULE <module>Expr</module> EXPORTS <A HREF="Expr.i3"><implements>Expr</A></implements>, <A HREF="ExprRep.i3"><implements>ExprRep</A></implements>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="ExprParse.i3">ExprParse</A>;
IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../builtinTypes/ErrType.i3">ErrType</A>, <A HREF="../misc/Error.i3">Error</A>;
</PRE>******************************************************************

<P><PRE>PROCEDURE <A NAME="Parse"><procedure>Parse</procedure></A> (): T =
  BEGIN
    RETURN ExprParse.E0 (FALSE);
  END Parse;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T) =
  BEGIN
    t.origin  := Scanner.offset;
    t.type    := NIL;
    t.checked := FALSE;
  END Init;
</PRE>******************************************************************

<P><PRE>PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (t: T): Type.T =
  BEGIN
    IF (t = NIL) THEN RETURN ErrType.T END;
    IF (t.type = NIL) THEN t.type := t.typeOf () END;
    RETURN t.type;
  END TypeOf;

PROCEDURE <A NAME="TypeCheck"><procedure>TypeCheck</procedure></A> (t: T;  VAR cs: CheckState) =
  VAR save: INTEGER;
  BEGIN
    IF (t = NIL) THEN RETURN END;
    IF (t.checked) THEN RETURN END;
    save := Scanner.offset;
    Scanner.offset := t.origin;
    t.check (cs);
    Scanner.offset := save;
    t.checked := TRUE;
  END TypeCheck;
</PRE>******************************************************************

<P><PRE>PROCEDURE <A NAME="ConstValue"><procedure>ConstValue</procedure></A> (t: T): T =
  VAR new: T;  cs: CheckState;
  BEGIN
    IF (t = NIL) THEN RETURN NIL END;
    (*** &lt;* ASSERT t.checked *&gt; ***)
    new := t.evaluate ();
    IF (new # t) THEN
      cs := M3.OuterCheckState; (* OK since constants don't raise exceptions *)
      TypeCheck (new, cs);
    END;
    RETURN new;
  END ConstValue;

PROCEDURE <A NAME="GetBounds"><procedure>GetBounds</procedure></A> (t: T;  VAR min, max: Target.Int) =
  BEGIN
    IF (t = NIL) THEN min := TInt.Zero; max := TInt.MOne; RETURN END;
    &lt;* ASSERT t.checked *&gt;
    t.getBounds (min, max);
  END GetBounds;

PROCEDURE <A NAME="IsDesignator"><procedure>IsDesignator</procedure></A> (t: T): BOOLEAN =
  BEGIN
    IF (t = NIL) THEN RETURN TRUE END;
    &lt;* ASSERT t.checked *&gt;
    RETURN t.isDesignator ();
  END IsDesignator;

PROCEDURE <A NAME="IsWritable"><procedure>IsWritable</procedure></A> (t: T): BOOLEAN =
  BEGIN
    IF (t = NIL) THEN RETURN TRUE END;
    &lt;* ASSERT t.checked *&gt;
    RETURN t.isWritable ()
  END IsWritable;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (t: T): BOOLEAN =
  BEGIN
    IF (t = NIL) THEN RETURN TRUE END;
    &lt;* ASSERT t.checked *&gt;
    RETURN t.isZeroes ()
  END IsZeroes;

PROCEDURE <A NAME="GetSign"><procedure>GetSign</procedure></A> (t: T): CG.Sign =
  VAR min, max: Target.Int;
  BEGIN
    GetBounds (t, min, max);
    IF    TInt.LE (TInt.Zero, min) THEN  RETURN CG.Sign.Positive;
    ELSIF TInt.LE (max, TInt.Zero) THEN  RETURN CG.Sign.Negative;
    ELSE                                        RETURN CG.Sign.Unknown;
    END;
  END GetSign;
</PRE>******************************************************************

<P><PRE>PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;*ASSERT t.checked *&gt;
    t.need_addr ();
  END NeedsAddress;
</PRE>******************************************************************

<P><PRE>PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    t.prep ();
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    t.compile ();
  END Compile;

PROCEDURE <A NAME="PrepLValue"><procedure>PrepLValue</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    Type.Compile (t.type);
    &lt;* ASSERT t.checked *&gt;
    t.prepLV ();
  END PrepLValue;

PROCEDURE <A NAME="CompileLValue"><procedure>CompileLValue</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    t.compileLV ();
  END CompileLValue;

PROCEDURE <A NAME="CompileAddress"><procedure>CompileAddress</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    t.compileLV ();
    CG.Check_byte_aligned ();
  END CompileAddress;

PROCEDURE <A NAME="PrepBranch"><procedure>PrepBranch</procedure></A> (t: T;  true, false: CG.Label;  freq: CG.Frequency) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    &lt;* ASSERT (true = CG.No_label) OR (false = CG.No_label) *&gt;
    Type.Compile (t.type);
    t.prepBR (true, false, freq);
  END PrepBranch;

PROCEDURE <A NAME="CompileBranch"><procedure>CompileBranch</procedure></A> (t: T;  true, false: CG.Label;  freq: CG.Frequency) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    &lt;* ASSERT (true = CG.No_label) OR (false = CG.No_label) *&gt;
    t.compileBR (true, false, freq);
  END CompileBranch;

PROCEDURE <A NAME="NoteWrite"><procedure>NoteWrite</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    t.note_write ();
  END NoteWrite;

PROCEDURE <A NAME="IsEqual"><procedure>IsEqual</procedure></A> (a, b: T): BOOLEAN =
  BEGIN
    IF (a = b) THEN RETURN TRUE END;
    IF (a = NIL) OR (b = NIL) THEN RETURN FALSE END;
    RETURN a.isEqual (b);
  END IsEqual;

PROCEDURE <A NAME="PrepLiteral"><procedure>PrepLiteral</procedure></A> (t: T;  type: Type.T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    Type.Compile (t.type);
    t.prepLiteral (type);
  END PrepLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (t: T;  offset: INTEGER;  type: Type.T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    Type.Compile (t.type);
    t.genLiteral (offset, type);
  END GenLiteral;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (t: T;  mbuf: M3Buf.T) =
  VAR u := ConstValue (t);
  BEGIN
    IF (u = NIL) THEN
      Error.Msg (&quot;INTERNAL ERROR: fingerprint of a non-constant expression&quot;);
    END;
    &lt;* ASSERT u.checked *&gt;
    u.genFPLiteral (mbuf);
  END GenFPLiteral;

PROCEDURE <A NAME="BadOperands"><procedure>BadOperands</procedure></A> (op: TEXT;  a, b: M3.Type := NIL): M3.Type =
  BEGIN
    IF (a # ErrType.T) AND (b # ErrType.T) THEN
      Error.Msg (&quot;illegal operand(s) for &quot; &amp; op);
    END;
    RETURN ErrType.T;
  END BadOperands;
</PRE>******************* default methods ***********************************

<P><PRE>PROCEDURE <A NAME="NoType"><procedure>NoType</procedure></A> (&lt;*UNUSED*&gt; t: T): Type.T =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NoType;

PROCEDURE <A NAME="NoCheck"><procedure>NoCheck</procedure></A> (&lt;*UNUSED*&gt; t: T;  &lt;*UNUSED*&gt; VAR cs: CheckState) =
  BEGIN
  END NoCheck;

PROCEDURE <A NAME="NoValue"><procedure>NoValue</procedure></A> (&lt;*UNUSED*&gt; t: T): T =
  BEGIN
    RETURN NIL;
  END NoValue;

PROCEDURE <A NAME="NoFPLiteral"><procedure>NoFPLiteral</procedure></A> (&lt;*UNUSED*&gt; t: T;  &lt;*UNUSED*&gt;mbuf: M3Buf.T) =
  BEGIN
    &lt;*ASSERT FALSE*&gt;
  END NoFPLiteral;

PROCEDURE <A NAME="Self"><procedure>Self</procedure></A> (t: T): T =
  BEGIN
    RETURN t;
  END Self;

PROCEDURE <A NAME="NoBounds"><procedure>NoBounds</procedure></A> (t: T;  VAR min, max: Target.Int) =
  BEGIN
    EVAL Type.GetBounds (t.type, min, max);
  END NoBounds;

PROCEDURE <A NAME="IsNever"><procedure>IsNever</procedure></A> (&lt;*UNUSED*&gt; t: T): BOOLEAN =
  BEGIN
    RETURN FALSE;
  END IsNever;

PROCEDURE <A NAME="IsAlways"><procedure>IsAlways</procedure></A> (&lt;*UNUSED*&gt; t: T): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END IsAlways;

PROCEDURE <A NAME="NeverEq"><procedure>NeverEq</procedure></A> (&lt;*UNUSED*&gt; a, b: T): BOOLEAN =
  BEGIN
    RETURN FALSE;
  END NeverEq;

PROCEDURE <A NAME="NoPrepLiteral"><procedure>NoPrepLiteral</procedure></A> (&lt;*UNUSED*&gt; t: T;  &lt;*UNUSED*&gt; type: Type.T) =
  BEGIN
  END NoPrepLiteral;

PROCEDURE <A NAME="NoLiteral"><procedure>NoLiteral</procedure></A> (&lt;*UNUSED*&gt; t: T;
                     &lt;*UNUSED*&gt; offset: INTEGER;
                     &lt;*UNUSED*&gt; type: Type.T) =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NoLiteral;

PROCEDURE <A NAME="NoPrep"><procedure>NoPrep</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
  END NoPrep;

PROCEDURE <A NAME="NoCompile"><procedure>NoCompile</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    &lt;*ASSERT FALSE*&gt;
  END NoCompile;

PROCEDURE <A NAME="NotLValue"><procedure>NotLValue</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NotLValue;

PROCEDURE <A NAME="NotBoolean"><procedure>NotBoolean</procedure></A> (&lt;*UNUSED*&gt; t: T;
                      &lt;*UNUSED*&gt; true, false: CG.Label;
                      &lt;*UNUSED*&gt; freq: CG.Frequency) =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NotBoolean;

PROCEDURE <A NAME="PrepNoBranch"><procedure>PrepNoBranch</procedure></A> (t: T;  true, false: CG.Label;  freq: CG.Frequency) =
  BEGIN
    t.prep ();
    t.compile ();
    IF (true = CG.No_label)
      THEN CG.If_false (false, freq);
      ELSE CG.If_true (true, freq);
    END;
  END PrepNoBranch;

PROCEDURE <A NAME="NoBranch"><procedure>NoBranch</procedure></A> (&lt;*UNUSED*&gt; t: T;
                    &lt;*UNUSED*&gt; true, false: CG.Label;
                    &lt;*UNUSED*&gt; freq: CG.Frequency) =
  BEGIN
    (* prep did all the work *)
  END NoBranch;

PROCEDURE <A NAME="NotAddressable"><procedure>NotAddressable</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    &lt;*ASSERT FALSE*&gt;
  END NotAddressable;

PROCEDURE <A NAME="NotWritable"><procedure>NotWritable</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    (* skip *)
  END NotWritable;

PROCEDURE <A NAME="EqCheckA"><procedure>EqCheckA</procedure></A> (a: Ta;  e: T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL  =&gt; RETURN FALSE;
    | Ta(b) =&gt; RETURN (TYPECODE (a) = TYPECODE (e)) AND IsEqual (a.a, b.a);
    ELSE       RETURN FALSE;
    END;
  END EqCheckA;

PROCEDURE <A NAME="EqCheckAB"><procedure>EqCheckAB</procedure></A> (a: Tab;  e: T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL   =&gt; RETURN FALSE;
    | Tab(b) =&gt; RETURN (TYPECODE (a) = TYPECODE (b)) AND
                       IsEqual (a.a, b.a) AND IsEqual (a.b, b.b);
    ELSE        RETURN FALSE;
    END;
  END EqCheckAB;

BEGIN
END Expr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
