<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/ExprParse.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/ExprParse.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ExprParse.m3                                          
 Last Modified On Tue Dec 20 15:25:42 PST 1994 By kalsow     
      Modified On Sat Aug 18 01:24:21 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="ExprParse.i3">ExprParse</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../misc/Token.i3">Token</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/CChar.i3">CChar</A>, <A HREF="../types/ObjectType.i3">ObjectType</A>;
IMPORT <A HREF="AndExpr.i3">AndExpr</A>, <A HREF="OrExpr.i3">OrExpr</A>, <A HREF="EqualExpr.i3">EqualExpr</A>, <A HREF="CompareExpr.i3">CompareExpr</A>, <A HREF="MultiplyExpr.i3">MultiplyExpr</A>, <A HREF="DivExpr.i3">DivExpr</A>;
IMPORT <A HREF="DivideExpr.i3">DivideExpr</A>, <A HREF="ModExpr.i3">ModExpr</A>, <A HREF="AddExpr.i3">AddExpr</A>, <A HREF="SubtractExpr.i3">SubtractExpr</A>, <A HREF="InExpr.i3">InExpr</A>, <A HREF="PlusExpr.i3">PlusExpr</A>;
IMPORT <A HREF="NegateExpr.i3">NegateExpr</A>, <A HREF="NotExpr.i3">NotExpr</A>, <A HREF="ConcatExpr.i3">ConcatExpr</A>, <A HREF="IntegerExpr.i3">IntegerExpr</A>, <A HREF="ReelExpr.i3">ReelExpr</A>;
IMPORT <A HREF="TextExpr.i3">TextExpr</A>, <A HREF="DerefExpr.i3">DerefExpr</A>, <A HREF="QualifyExpr.i3">QualifyExpr</A>, <A HREF="SubscriptExpr.i3">SubscriptExpr</A>, <A HREF="TypeExpr.i3">TypeExpr</A>;
IMPORT <A HREF="CallExpr.i3">CallExpr</A>, <A HREF="ConsExpr.i3">ConsExpr</A>, <A HREF="RangeExpr.i3">RangeExpr</A>, <A HREF="NamedExpr.i3">NamedExpr</A>, <A HREF="KeywordExpr.i3">KeywordExpr</A>, <A HREF="EnumExpr.i3">EnumExpr</A>;
IMPORT <A HREF="../types/RefType.i3">RefType</A>, <A HREF="../types/NamedType.i3">NamedType</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

FROM <A HREF="../misc/Scanner.i3">Scanner</A> IMPORT Match, MatchID, GetToken, Fail, cur, offset;

TYPE
  TK = Token.T;

PROCEDURE <A NAME="E0"><procedure>E0</procedure></A> (types: BOOLEAN): Expr.T =
  VAR a: Expr.T;  here := offset;
  BEGIN
    a := E1 (types);
    WHILE (cur.token = TK.tOR) DO
      GetToken (); (* OR *)
      a := OrExpr.New (a, E1 (FALSE));
      a.origin := here;
      here := offset;
    END;
    RETURN a;
  END E0;

PROCEDURE <A NAME="E1"><procedure>E1</procedure></A> (types: BOOLEAN): Expr.T =
  VAR a: Expr.T;  here := offset;
  BEGIN
    a := E2 (types);
    WHILE (cur.token = TK.tAND) DO
      GetToken (); (* AND *)
      a := AndExpr.New (a, E2 (FALSE));
      a.origin := here;
      here := offset;
    END;
    RETURN a;
  END E1;

PROCEDURE <A NAME="E2"><procedure>E2</procedure></A> (types: BOOLEAN;  ): Expr.T =
  VAR a: Expr.T;  n: INTEGER;  here := offset;
  BEGIN
    n := 0;
    WHILE (cur.token = TK.tNOT) DO
      GetToken (); (* NOT *)
      INC (n);
    END;
    a := E3 (types);
    IF (n &gt; 0) THEN
      a := NotExpr.New (a);
      a.origin := here;
      IF ((n MOD 2) = 0) THEN
        a := NotExpr.New (a);
        a.origin := here;
      END;
    END;
    RETURN a;
  END E2;

PROCEDURE <A NAME="E3"><procedure>E3</procedure></A> (types: BOOLEAN;  ): Expr.T =
  CONST RelOps = Token.Set {TK.tEQUAL, TK.tSHARP, TK.tLESS, TK.tLSEQUAL,
                            TK.tGREATER, TK.tGREQUAL, TK.tIN};
  VAR a, b: Expr.T;  t: Token.T;  here := offset;
  BEGIN
    a := E4 (types);
    WHILE (cur.token IN RelOps) DO
      t := cur.token;
      GetToken ();
      b := E4 (FALSE);
      CASE t OF
      | TK.tEQUAL   =&gt; a := EqualExpr.NewEQ (a, b);
      | TK.tSHARP   =&gt; a := EqualExpr.NewNE (a, b);
      | TK.tLESS    =&gt; a := CompareExpr.NewLT (a, b);
      | TK.tLSEQUAL =&gt; a := CompareExpr.NewLE (a, b);
      | TK.tGREATER =&gt; a := CompareExpr.NewGT (a, b);
      | TK.tGREQUAL =&gt; a := CompareExpr.NewGE (a, b);
      | TK.tIN      =&gt; a := InExpr.New (a, b);
      ELSE             &lt;*ASSERT FALSE*&gt;
      END;
      a.origin := here;
      here := offset;
    END;
    RETURN a;
  END E3;

PROCEDURE <A NAME="E4"><procedure>E4</procedure></A> (types: BOOLEAN;  ): Expr.T =
  CONST AddOps = Token.Set {TK.tPLUS, TK.tMINUS, TK.tAMPERSAND};
  VAR a, b: Expr.T;  t: Token.T;  here := offset;
  BEGIN
    a := E5 (types);
    WHILE (cur.token IN AddOps) DO
      t := cur.token;
      GetToken ();
      b := E5 (FALSE);
      CASE t OF
      | TK.tPLUS      =&gt; a := AddExpr.New (a, b);
      | TK.tMINUS     =&gt; a := SubtractExpr.New (a, b);
      | TK.tAMPERSAND =&gt; a := ConcatExpr.New (a, b);
      ELSE               &lt;*ASSERT FALSE*&gt;
      END;
      a.origin := here;
      here := offset;
    END;
    RETURN a;
  END E4;

PROCEDURE <A NAME="E5"><procedure>E5</procedure></A> (types: BOOLEAN;  ): Expr.T =
  CONST MulOps = Token.Set {TK.tASTERISK, TK.tSLASH, TK.tDIV, TK.tMOD};
  VAR a, b: Expr.T;  t: Token.T;  here := offset;
  BEGIN
    a := E6 (types);
    WHILE (cur.token IN MulOps) DO
      t := cur.token;
      GetToken ();
      b := E6 (FALSE);
      CASE t OF
      | TK.tASTERISK =&gt; a := MultiplyExpr.New (a, b);
      | TK.tSLASH    =&gt; a := DivideExpr.New (a, b);
      | TK.tDIV      =&gt; a := DivExpr.New (a, b);
      | TK.tMOD      =&gt; a := ModExpr.New (a, b);
      ELSE              &lt;*ASSERT FALSE*&gt;
      END;
      a.origin := here;
      here := offset;
    END;
    RETURN a;
  END E5;

CONST
  SelectStart = Token.Set {TK.tARROW, TK.tDOT, TK.tLBRACKET, TK.tLPAREN,
                           TK.tLBRACE, TK.tBRANDED, TK.tOBJECT};

PROCEDURE <A NAME="E6"><procedure>E6</procedure></A> (types: BOOLEAN; ): Expr.T =
  VAR a, b: Expr.T;  p, m: INTEGER;  here := offset;
  BEGIN
    p := 0;
    m := 0;
    LOOP
      IF    (cur.token = TK.tPLUS)  THEN  GetToken (); INC (p);
      ELSIF (cur.token = TK.tMINUS) THEN  GetToken (); INC (m);
      ELSE  EXIT;
      END;
    END;
    a := E8 (types);  b := NIL;
    WHILE (a # b) AND (cur.token IN SelectStart) DO
      b := a;
      a := ESelector (types, a);
      a.origin := here;
      here := offset;
    END;
    IF (p + m &gt; 0) THEN
      IF ((m MOD 2) = 1)
        THEN a := NegateExpr.New (a);
        ELSE a := PlusExpr.New (a); (* get the typechecking *)
      END;
      a.origin := here;
    END;
    RETURN a;
  END E6;

PROCEDURE <A NAME="E8"><procedure>E8</procedure></A> (types: BOOLEAN): Expr.T =
  TYPE RP = ReelExpr.Precision;
  VAR a: Expr.T;  here := offset;
  BEGIN
    CASE cur.token OF
    | TK.tIDENT =&gt;     a := NamedExpr.New (cur.id, cur.defn);     GetToken ();
    | TK.tCARDCONST =&gt; a := IntegerExpr.New (cur.int);            GetToken ();
    | TK.tCHARCONST =&gt; a := EnumExpr.New (CChar.T, cur.int);      GetToken ();
    | TK.tTEXTCONST =&gt; a := TextExpr.New (cur.str);               GetToken ();
    | TK.tREALCONST =&gt; a := ReelExpr.New (cur.float, RP.Short);   GetToken ();
    | TK.tLONGREALCONST=&gt; a := ReelExpr.New (cur.float,RP.Long);  GetToken ();
    | TK.tEXTENDEDCONST=&gt; a :=ReelExpr.New(cur.float, RP.Extended); GetToken();

    | TK.tLPAREN =&gt;
        GetToken ();
        a := E0 (types);
        Match (TK.tRPAREN);

    | TK.tARRAY, TK.tBITS, TK.tRECORD, TK.tSET =&gt;
        a := TypeExpr.New (Type.Parse ());
        a.origin := here;
        IF (NOT types) AND (cur.token # TK.tLBRACE) THEN
          Error.Msg (&quot;expected a constructor&quot;);
        END;

    | TK.tBRANDED, TK.tLBRACE, TK.tUNTRACED, TK.tOBJECT,
      TK.tPROCEDURE, TK.tREF, TK.tLBRACKET, TK.tCALLCONV =&gt;
        IF NOT types THEN Error.Msg (&quot;unexpected type expression&quot;) END;
        a := TypeExpr.New (Type.Parse ());
        a.origin := here;

    ELSE
        Fail (&quot;bad expression&quot;); a := IntegerExpr.New (TInt.Zero);
    END;
    RETURN a;
  END E8;

PROCEDURE <A NAME="ESelector"><procedure>ESelector</procedure></A> (types: BOOLEAN;  a: Expr.T;
                                           ): Expr.T =
  VAR
    args: Expr.List;
    t: Type.T;
    open: BOOLEAN;
    name, module: M3ID.T;
    brand: Expr.T;
    here := offset;
  BEGIN
    CASE cur.token OF
    | TK.tARROW =&gt;
        GetToken (); (* ^ *)
        a := DerefExpr.New (a);
    | TK.tDOT =&gt;
        GetToken (); (* . *)
        a := QualifyExpr.New (a, MatchID ());
        a.origin := here;
    | TK.tLBRACKET =&gt;
        GetToken (); (* [ *)
        LOOP
          a := SubscriptExpr.New (a, E0 (FALSE));
          a.origin := here;
          here := offset;
          IF (cur.token # TK.tCOMMA) THEN EXIT END;
          GetToken (); (* , *)
        END;
        Match (TK.tRBRACKET);
    | TK.tLPAREN =&gt;
        GetToken (); (* ( *)
        args := ParseArgList ();
        Match (TK.tRPAREN);
        a := CallExpr.New (a, args);
        a.origin := here;
    | TK.tLBRACE =&gt;
        GetToken (); (* { *)
        args := ParseConsList (open);
        Match (TK.tRBRACE);
        a := ConsExpr.New (a, args, open);
        a.origin := here;
    | TK.tBRANDED, TK.tOBJECT =&gt;
        IF (types) THEN
	  brand := RefType.ParseBrand ();
          IF NamedExpr.SplitName (a, name) THEN
            t := NamedType.Create (M3ID.NoID, name);
          ELSIF QualifyExpr.SplitQID (a, module, name) THEN
            t := NamedType.Create (module, name);
          ELSE
            t := NIL;
            Fail (&quot;bad selector&quot;);
          END;
	  a := TypeExpr.New (ObjectType.Parse (t, TRUE, brand));
          a.origin := here;
        END;
    ELSE Fail (&quot;bad selector&quot;);
    END;
    RETURN a;
  END ESelector;

TYPE RefExprList = REF ARRAY OF Expr.T;

PROCEDURE <A NAME="ParseArgList"><procedure>ParseArgList</procedure></A> (): Expr.List =
  VAR
    i := 0;
    e: Expr.T;
    result: Expr.List;
    args: ARRAY [0..9] OF Expr.T;
    args2: RefExprList;
  BEGIN
    IF (cur.token # TK.tRPAREN) THEN
      LOOP
        e := EActual ();
        IF (i &lt; NUMBER (args)) THEN
          args[i] := e;
        ELSIF (i = NUMBER (args)) THEN
          args2 := Expand (args);
          args2[i] := e;
        ELSIF (i = NUMBER (args2^)) THEN
          args2 := Expand (args2^);
          args2[i] := e;
        ELSE
          args2[i] := e;
        END;
        INC (i);
        IF (cur.token # TK.tCOMMA) THEN EXIT END;
        GetToken (); (* , *)
      END;
    END;
    result := NEW (Expr.List, i);
    IF (i &lt;= NUMBER (args))
      THEN FOR j := 0 TO i - 1 DO result[j] := args[j] END;
      ELSE FOR j := 0 TO i - 1 DO result[j] := args2[j] END;
    END;
    RETURN result;
  END ParseArgList;

PROCEDURE <A NAME="ParseConsList"><procedure>ParseConsList</procedure></A> (VAR open: BOOLEAN;
                         ): Expr.List =
  VAR
    i := 0;
    e: Expr.T;
    result: Expr.List;
    args: ARRAY [0..9] OF Expr.T;
    args2: RefExprList;
  BEGIN
    open := FALSE;
    IF (cur.token # TK.tRBRACE) THEN
      LOOP
        IF (cur.token = TK.tDOTDOT) THEN
          (* must be the end of an array constructor *)
          IF (i = 0) THEN Error.Msg(&quot;array constructor has no values&quot;) END;
          open := TRUE;
          GetToken (); (* .. *)
          EXIT;
        END;
        e := EConstructor ();
        IF (i &lt; NUMBER (args)) THEN
          args[i] := e;
        ELSIF (i = NUMBER (args)) THEN
          args2 := Expand (args);
          args2[i] := e;
        ELSIF (i = NUMBER (args2^)) THEN
          args2 := Expand (args2^);
          args2[i] := e;
        ELSE
          args2[i] := e;
        END;
        INC (i);
        IF (cur.token # TK.tCOMMA) THEN EXIT END;
        GetToken (); (* , *)
      END;
    END;
    result := NEW (Expr.List, i);
    IF (i &lt;= NUMBER (args))
      THEN FOR j := 0 TO i - 1 DO result[j] := args[j] END;
      ELSE FOR j := 0 TO i - 1 DO result[j] := args2[j] END;
    END;
    RETURN result;
  END ParseConsList;

PROCEDURE <A NAME="Expand"><procedure>Expand</procedure></A> (READONLY old: ARRAY OF Expr.T): RefExprList =
  VAR new := NEW (RefExprList, MAX (200, 2 * NUMBER (old)));
  BEGIN
    FOR i := 0 TO LAST (old) DO new[i] := old[i] END;
    RETURN new;
  END Expand;

PROCEDURE <A NAME="EActual"><procedure>EActual</procedure></A> (): Expr.T =
  VAR a: Expr.T;  name: M3ID.T;  here := offset;
  BEGIN
    a := E0 (TRUE);
    IF (cur.token = TK.tASSIGN) THEN
      GetToken (); (* := *)
      IF NamedExpr.SplitName (a, name)
        THEN a := KeywordExpr.New (name, E0 (FALSE)); a.origin := here;
        ELSE Error.Msg (&quot;syntax error: expected \'keyword := value\'&quot;);
      END;
    END;
    RETURN a;
  END EActual;

PROCEDURE <A NAME="EConstructor"><procedure>EConstructor</procedure></A> (): Expr.T =
  VAR a: Expr.T;  name: M3ID.T;  here := offset;
  BEGIN
    a := E0 (FALSE);
    IF (cur.token = TK.tDOTDOT) THEN
      GetToken (); (* .. *)
      a := RangeExpr.New (a, E0 (FALSE));
      a.origin := here;
    ELSIF (cur.token = TK.tASSIGN) THEN
      GetToken (); (* := *)
      IF NamedExpr.SplitName (a, name)
        THEN a := KeywordExpr.New (name, E0 (FALSE));  a.origin := here;
        ELSE Error.Msg (&quot;syntax error: expected \'keyword := value\'&quot;);
      END;
    END;
    RETURN a;
  END EConstructor;

BEGIN
END ExprParse.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
