<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/ExprRep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/ExprRep.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ExprRep.i3                                            
 Last Modified On Tue Aug 16 08:18:09 PDT 1994 By kalsow     
      Modified On Thu Nov 29 03:45:22 1990 By muller         

<P><PRE>INTERFACE <interface><A HREF="Expr.m3">ExprRep</A></interface>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;

REVEAL
  M3.<A NAME="Expr">Expr</A> = M3.Node BRANDED &quot;Expr.T&quot; OBJECT
    type    : M3.Type;
    checked : BOOLEAN;
  METHODS
    typeOf       (): M3.Type                       := NoType;
    check        (VAR cs: M3.CheckState)           := NoCheck;
    isEqual      (e: M3.Expr): BOOLEAN             := NeverEq;
    evaluate     (): M3.Expr                       := NoValue;
    getBounds    (VAR min, max: Target.Int)        := NoBounds;
    isWritable   (): BOOLEAN                       := IsNever;
    isDesignator (): BOOLEAN                       := IsNever;
    isZeroes     (): BOOLEAN                       := IsNever;
    need_addr    ()                                := NotAddressable;
    genFPLiteral (mbuf: M3Buf.T)                   := NoFPLiteral;
    prepLiteral  (type: M3.Type)                   := NoPrepLiteral;
    genLiteral   (offset: INTEGER;  type: M3.Type) := NoLiteral;
    prep         ()                                := NoCompile;
    compile      ()                                := NoCompile;
    prepLV       ()                                := NotLValue;
    compileLV    ()                                := NotLValue;
    prepBR       (true, false: CG.Label;  freq: CG.Frequency) := NotBoolean;
    compileBR    (true, false: CG.Label;  freq: CG.Frequency) := NotBoolean;
    note_write   ()                                := NotWritable;
  END;

TYPE Ta   = M3.Expr OBJECT a: M3.Expr     OVERRIDES isEqual := EqCheckA  END;
TYPE Tab  = M3.Expr OBJECT a, b: M3.Expr  OVERRIDES isEqual := EqCheckAB END;
TYPE Tabc = Tab     OBJECT class: INTEGER OVERRIDES isEqual := EqCheckAB END;

PROCEDURE <A HREF="Expr.m3#Init">Init</A> (e: M3.Expr);
</PRE><BLOCKQUOTE><EM> initializes the common part of an Expr.T </EM></BLOCKQUOTE><PRE>
</PRE> misc. useful methods 
<PRE>PROCEDURE <A HREF="Expr.m3#NotAddressable">NotAddressable</A> (e: M3.Expr);
PROCEDURE <A HREF="Expr.m3#NoType">NoType</A>         (e: M3.Expr): M3.Type;
PROCEDURE <A HREF="Expr.m3#NoCheck">NoCheck</A>        (e: M3.Expr;  VAR cs: M3.CheckState);
PROCEDURE <A HREF="Expr.m3#NoValue">NoValue</A>        (e: M3.Expr): M3.Expr;
PROCEDURE <A HREF="Expr.m3#Self">Self</A>           (e: M3.Expr): M3.Expr;
PROCEDURE <A HREF="Expr.m3#NoBounds">NoBounds</A>       (e: M3.Expr;  VAR min, max: Target.Int);
PROCEDURE <A HREF="Expr.m3#IsNever">IsNever</A>        (e: M3.Expr): BOOLEAN;
PROCEDURE <A HREF="Expr.m3#IsAlways">IsAlways</A>       (e: M3.Expr): BOOLEAN;
PROCEDURE <A HREF="Expr.m3#NeverEq">NeverEq</A>        (e: M3.Expr;  x: M3.Expr): BOOLEAN;
PROCEDURE <A HREF="Expr.m3#NoFPLiteral">NoFPLiteral</A>    (e: M3.Expr;  mbuf: M3Buf.T);
PROCEDURE <A HREF="Expr.m3#NoPrepLiteral">NoPrepLiteral</A>  (e: M3.Expr;  type: M3.Type);
PROCEDURE <A HREF="Expr.m3#NoLiteral">NoLiteral</A>      (e: M3.Expr;  offset: INTEGER;  type: M3.Type);
PROCEDURE <A HREF="Expr.m3#NoPrep">NoPrep</A>         (e: M3.Expr);
PROCEDURE <A HREF="Expr.m3#NoCompile">NoCompile</A>      (e: M3.Expr);
PROCEDURE <A HREF="Expr.m3#NotLValue">NotLValue</A>      (e: M3.Expr);
PROCEDURE <A HREF="Expr.m3#NotBoolean">NotBoolean</A>     (e: M3.Expr; t,f: CG.Label; freq: CG.Frequency);
PROCEDURE <A HREF="Expr.m3#PrepNoBranch">PrepNoBranch</A>   (e: M3.Expr; t,f: CG.Label; freq: CG.Frequency);
PROCEDURE <A HREF="Expr.m3#NoBranch">NoBranch</A>       (e: M3.Expr; t,f: CG.Label; freq: CG.Frequency);
PROCEDURE <A HREF="Expr.m3#NotWritable">NotWritable</A>    (e: M3.Expr);

PROCEDURE <A HREF="Expr.m3#EqCheckA">EqCheckA</A>  (e: Ta;  x: M3.Expr): BOOLEAN;
PROCEDURE <A HREF="Expr.m3#EqCheckAB">EqCheckAB</A> (e: Tab; x: M3.Expr): BOOLEAN;

END ExprRep.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
