<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/InExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/InExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: InExpr.m3                                             

<P><PRE>MODULE <module><implements><A HREF="InExpr.i3">InExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../types/SetType.i3">SetType</A>, <A HREF="../builtinTypes/Bool.i3">Bool</A>, <A HREF="SetExpr.i3">SetExpr</A>;
IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

TYPE
  P = ExprRep.Tab BRANDED &quot;InExpr.P&quot; OBJECT
        tmp: CG.Val;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.PrepNoBranch;
        compileBR    := ExprRep.NoBranch;
        evaluate     := Fold;
        isEqual      := ExprRep.EqCheckAB;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a, b: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.a    := a;
    p.b    := b;
    p.type := Bool.T;
    p.tmp  := NIL;
    RETURN p;
  END New;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR ta, tb, tc: Type.T;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    Expr.TypeCheck (p.b, cs);
    ta := Type.Base (Expr.TypeOf (p.a));
    tb := Type.Base (Expr.TypeOf (p.b));
    IF SetType.Split (tb, tc) AND Type.IsSubtype (ta, Type.Base (tc)) THEN
      (*ok *)
    ELSE
      p.type := Expr.BadOperands (&quot;IN&quot;, ta, tb);
    END;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  VAR
    set, range: Type.T;
    b: BOOLEAN;
    min, max, emin, emax, n_elts: Target.Int;
    skip: CG.Label;
    index: CG.Val;
    info: Type.Info;
  BEGIN
    set := Type.CheckInfo (Expr.TypeOf (p.b), info);
    b := SetType.Split (set, range);  &lt;*ASSERT b*&gt;
    b := Type.GetBounds (range, min, max);  &lt;*ASSERT b*&gt;
    Expr.GetBounds (p.a, emin, emax);

    Expr.Prep (p.a);
    Expr.Prep (p.b);

    IF TInt.LT (emin, min) OR TInt.LT (max, emax) THEN
      (* we need to range check a *)
      IF NOT TInt.Subtract (max, min, n_elts) THEN
        Error.Msg (&quot;set too large&quot;);
      END;
      Expr.Compile (p.a);
      IF NOT TInt.EQ (min, TInt.Zero) THEN
        CG.Load_integer (min);
        CG.Subtract (CG.Type.Int);
      END;
      index := CG.Pop ();
      CG.Load_integer (TInt.Zero);
      p.tmp := CG.Pop_temp ();
      CG.Push (index);
      CG.Loophole (CG.Type.Int, CG.Type.Word);
      CG.Load_integer (n_elts);
      CG.Loophole (CG.Type.Int, CG.Type.Word);
      skip := CG.Next_label ();
      CG.If_gt (skip, CG.Type.Word, CG.Never);
      Expr.Compile (p.b);
      CG.Push (index);
      CG.Set_member (info.size);
      CG.Store_temp (p.tmp);
      CG.Set_label (skip);
      CG.Free (index);
    END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR
    set, range: Type.T;
    b: BOOLEAN;
    min, max, emin, emax: Target.Int;
    info: Type.Info;
  BEGIN
    set := Type.CheckInfo (Expr.TypeOf (p.b), info);
    b := SetType.Split (set, range);  &lt;*ASSERT b*&gt;
    b := Type.GetBounds (range, min, max);  &lt;*ASSERT b*&gt;
    Expr.GetBounds (p.a, emin, emax);

    IF TInt.LT (emin, min) OR TInt.LT (max, emax) THEN
      (* we need to range check a *)
      CG.Push (p.tmp);
      CG.Free (p.tmp);
      p.tmp := NIL;
    ELSE
      (* no range checking is needed *)
      Expr.Compile (p.b);
      Expr.Compile (p.a);
      IF NOT TInt.EQ (min, TInt.Zero) THEN
        CG.Load_integer (min);
        CG.Subtract (CG.Type.Int);
      END;
      CG.Set_member (info.size);
    END;
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e1, e2, e3: Expr.T;
  BEGIN
    e1 := Expr.ConstValue (p.b);
    e2 := Expr.ConstValue (p.a);
    e3 := NIL;
    IF (e1 = NIL) OR (e2 = NIL) THEN
    ELSIF SetExpr.Member (e1, e2, e3) THEN
    END;
    RETURN e3;
  END Fold;

BEGIN
END InExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
