<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/IntegerExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/IntegerExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: IntegerExpr.m3                                        

<P><PRE>MODULE <module><implements><A HREF="IntegerExpr.i3">IntegerExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

TYPE
  P = Expr.T BRANDED &quot;IntegerExpr.T&quot; OBJECT
        value: Target.Int;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := ExprRep.NoCheck;
        need_addr    := ExprRep.NotAddressable;
        prep         := ExprRep.NoPrep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := ExprRep.Self;
        isEqual      := EqCheck;
        getBounds    := Bounder;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := IsZeroes;
	genFPLiteral := GenFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := GenLiteral;
        note_write   := ExprRep.NotWritable;
      END;

VAR cache := ARRAY [-7 .. 64] OF P { NIL, .. };

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (READONLY value: Target.Int): Expr.T =
  VAR p: P;  n: INTEGER;
  BEGIN
    IF TInt.ToInt (value, n)
      AND (FIRST (cache) &lt;= n) AND (n &lt;= LAST (cache)) THEN
      p := cache[n];
      IF (p # NIL) THEN RETURN p; END;
    END;
    p := NEW (P);
    ExprRep.Init (p);
    p.value   := value;
    p.type    := Int.T;
    p.checked := TRUE;
    IF TInt.ToInt (value, n)
      AND (FIRST (cache) &lt;= n) AND (n &lt;= LAST (cache)) THEN
      cache[n] := p;
    END;
    RETURN p;
  END New;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN TInt.EQ (a.value, b.value);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    CG.Load_integer (p.value);
  END Compile;

PROCEDURE <A NAME="Bounder"><procedure>Bounder</procedure></A> (p: P;  VAR min, max: Target.Int) =
  BEGIN
    min := p.value;
    max := p.value;
  END Bounder;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A> (a, b: Expr.T;  VAR sign: INTEGER): BOOLEAN =
  VAR x, y: Target.Int;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF    TInt.LT (x, y) THEN  sign := -1
    ELSIF TInt.LT (y, x) THEN  sign := 1
    ELSE                            sign := 0
    END;
    RETURN TRUE;
  END Compare;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Int;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF NOT TInt.Add (x, y, res) THEN RETURN FALSE END;
    c := New (res);
    RETURN TRUE;
  END Add;

PROCEDURE <A NAME="Subtract"><procedure>Subtract</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Int;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF NOT TInt.Subtract (x, y, res) THEN RETURN FALSE END;
    c := New (res);
    RETURN TRUE;
  END Subtract;

PROCEDURE <A NAME="Multiply"><procedure>Multiply</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Int;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF NOT TInt.Multiply (x, y, res) THEN RETURN FALSE END;
    c := New (res);
    RETURN TRUE;
  END Multiply;

PROCEDURE <A NAME="Div"><procedure>Div</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Int;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF TInt.EQ (y, TInt.Zero) THEN
      Error.Msg (&quot;attempt to DIV by 0&quot;);
      RETURN FALSE;
    END;
    IF NOT TInt.Div (x, y, res) THEN RETURN FALSE END;
    c := New (res);
    RETURN TRUE;
  END Div;

PROCEDURE <A NAME="Mod"><procedure>Mod</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Int;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF TInt.EQ (y, TInt.Zero) THEN
      Error.Msg (&quot;attempt to MOD by 0&quot;);
      RETURN FALSE;
    END;
    IF NOT TInt.Mod (x, y, res) THEN RETURN FALSE END;
    c := New (res);
    RETURN TRUE;
  END Mod;

PROCEDURE <A NAME="Negate"><procedure>Negate</procedure></A> (a: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR res: Target.Int;
  BEGIN
    TYPECASE a OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; IF NOT TInt.Subtract (TInt.Zero, p.value, res) THEN
                RETURN FALSE;
              END;
              c := New (res);  RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Negate;

PROCEDURE <A NAME="SplitPair"><procedure>SplitPair</procedure></A> (a, b: Expr.T;  VAR x, y: Target.Int): BOOLEAN =
  BEGIN
    TYPECASE a OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; x := p.value;
    ELSE      RETURN FALSE;
    END;
    TYPECASE b OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; y := p.value; RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END SplitPair;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (e: Expr.T;  VAR value: Target.Int): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; value := p.value; RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Split;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN TInt.EQ (p.value, TInt.Zero);
  END IsZeroes;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  BEGIN
    M3Buf.PutText (buf, &quot;INT&lt;&quot;);
    M3Buf.PutIntt (buf, p.value);
    M3Buf.PutChar (buf, '&gt;');
  END GenFPLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (p: P;  offset: INTEGER;  type: Type.T) =
  VAR info: Type.Info;
  BEGIN
    EVAL Type.CheckInfo (type, info);
    CG.Init_int (offset, info.size, p.value);
  END GenLiteral;

BEGIN
END IntegerExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
