<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/KeywordExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/KeywordExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: KeywordExpr.m3                                        

<P><PRE>MODULE <module><implements><A HREF="KeywordExpr.i3">KeywordExpr</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;

TYPE
  P = Expr.T OBJECT
        expr : Expr.T;
	key  : M3ID.T;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := Prep;
        compile      := Compile;
        prepLV       := PrepLV;
        compileLV    := CompileLV;
        prepBR       := ExprRep.PrepNoBranch;
        compileBR    := ExprRep.NoBranch;
        evaluate     := Fold;
        isEqual      := EqCheck;
        getBounds    := Bounder;
        isWritable   := IsWritable;
        isDesignator := IsDesignator;
	isZeroes     := IsZeroes;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := PrepLiteral;
	genLiteral   := GenLiteral;
        note_write   := NoteWrites;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (key: M3ID.T;  arg: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.key  := key;
    p.expr := arg;
    RETURN p;
  END New;

PROCEDURE <A NAME="Is"><procedure>Is</procedure></A> (e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P    =&gt; RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Is;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (e: Expr.T;  VAR key: M3ID.T;  VAR value: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; key := p.key;  value := p.expr;  RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Split;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  BEGIN
    RETURN Expr.TypeOf (p.expr);
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  BEGIN
    Expr.TypeCheck (p.expr, cs);
    p.type := Expr.TypeOf (p.expr);
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN Expr.IsEqual (a.expr, b.expr);
    ELSE      RETURN Expr.IsEqual (a.expr, e);
    END;
  END EqCheck;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (p: P) =
  BEGIN
    Expr.NeedsAddress (p.expr);
  END NeedsAddress;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  BEGIN
    Expr.Prep (p.expr);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    Expr.Compile (p.expr);
  END Compile;

PROCEDURE <A NAME="PrepLV"><procedure>PrepLV</procedure></A> (p: P) =
  BEGIN
    Expr.PrepLValue (p.expr);
  END PrepLV;

PROCEDURE <A NAME="CompileLV"><procedure>CompileLV</procedure></A> (p: P) =
  BEGIN
    Expr.CompileLValue (p.expr);
  END CompileLV;

PROCEDURE <A NAME="Bounder"><procedure>Bounder</procedure></A> (p: P;  VAR min, max: Target.Int) =
  BEGIN
    Expr.GetBounds (p.expr, min, max);
  END Bounder;

PROCEDURE <A NAME="IsDesignator"><procedure>IsDesignator</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN Expr.IsDesignator (p.expr);
  END IsDesignator;

PROCEDURE <A NAME="IsWritable"><procedure>IsWritable</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN Expr.IsWritable (p.expr);
  END IsWritable;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  BEGIN
    WITH e = Expr.ConstValue (p.expr) DO
      IF e = NIL THEN
        RETURN NIL
      ELSE
        p.expr := e;
        RETURN p;
      END;
    END;
  END Fold;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN Expr.IsZeroes (p.expr);
  END IsZeroes;

PROCEDURE <A NAME="PrepLiteral"><procedure>PrepLiteral</procedure></A> (p: P;  type: Type.T) =
  BEGIN
    Expr.PrepLiteral (p.expr, type);
  END PrepLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (p: P;  offset: INTEGER;  type: Type.T) =
  BEGIN
    Expr.GenLiteral (p.expr, offset, type);
  END GenLiteral;

PROCEDURE <A NAME="NoteWrites"><procedure>NoteWrites</procedure></A> (p: P) =
  BEGIN
    Expr.NoteWrite (p.expr);
  END NoteWrites;

BEGIN
END KeywordExpr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
