<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/MethodExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/MethodExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: MethodExpr.m3                                         

<P><PRE>MODULE <module><implements><A HREF="MethodExpr.i3">MethodExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../types/ObjectType.i3">ObjectType</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;
IMPORT <A HREF="../values/Value.i3">Value</A>, <A HREF="../types/ProcType.i3">ProcType</A>, <A HREF="../values/Method.i3">Method</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="#x1">M3ID</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>;

TYPE
  P = Expr.T BRANDED &quot;MethodExpr.T&quot; OBJECT
        object      : Type.T;
        method      : Value.T;
        holder      : Type.T;
        name        : M3ID.T;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := ExprRep.NoPrep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := ExprRep.Self;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := GenFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := GenLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (object: Type.T;  name: M3ID.T;
                  method: Value.T;  holder: Type.T): Expr.T =
  VAR p := NEW (P);
  BEGIN
    ExprRep.Init (p);
    p.object  := object;
    p.name    := name;
    p.method  := method;
    p.holder  := holder;
    RETURN p;
  END New;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  VAR m: Method.Info;
  BEGIN
    Method.SplitX (p.method, m);
    RETURN ProcType.MethodSigAsProcSig (m.signature, p.object);
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  BEGIN
    p.object := Type.Check (p.object);
    p.holder := Type.Check (p.holder);
    Value.TypeCheck (p.method, cs);
    EVAL Type.Check (TypeOf (p));
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN (a.name = b.name)
                 AND Type.IsEqual (a.object, b.object, NIL);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR
    x := ObjectType.MethodOffset (p.holder);
    method: Method.Info;
  BEGIN
    Type.Compile (p.object);
    Method.SplitX (p.method, method);

    Type.LoadInfo (p.object, M3RT.TC_defaultMethods, addr := TRUE);
    IF (x &gt;= 0) THEN
      INC (method.offset, x);
    ELSE (* runtime offset to methods *)
      Type.LoadInfo (p.holder, M3RT.TC_methodOffset);
      CG.Index_bytes (Target.Byte);
    END;
    CG.Boost_alignment (Target.Address.align);
    CG.Load_indirect (CG.Type.Addr, method.offset, Target.Address.size);
    CG.Boost_alignment (Target.Address.align);
  END Compile;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  BEGIN
    M3Buf.PutText (buf, &quot;METHOD&lt;&quot;);
    (*** M3Buf.PutText (buf, Type.Name (p.object)); ***)
    M3ID.Put   (buf, p.name);
    M3Buf.PutChar (buf, '&gt;');
  END GenFPLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (p: P;  offset: INTEGER;  type: Type.T) =
  VAR m_name := Value.GlobalName (p.method, dots := FALSE, with_module :=TRUE);
  VAR t_name := Type.Name (p.object);
  VAR name   := t_name &amp; &quot;_&quot; &amp; m_name;
  VAR uid    := Type.GlobalUID (type);
  VAR var    := CG.Import_global (M3ID.Add (name), Target.Address.size,
                                  Target.Address.align, CG.Type.Addr, uid);
  BEGIN
    CG.Init_var (offset, var, 0);
    Type.Compile (type);
    Error.ID (p.name,
    &quot;SRC Modula-3 restriction: default method is not a compile-time constant&quot;);
  END GenLiteral;

BEGIN
END MethodExpr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
