<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/ModExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/ModExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: ModExpr.m3                                            

<P><PRE>MODULE <module><implements><A HREF="ModExpr.i3">ModExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="IntegerExpr.i3">IntegerExpr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;
IMPORT <A HREF="../builtinTypes/Reel.i3">Reel</A>, <A HREF="../builtinTypes/LReel.i3">LReel</A>, <A HREF="../builtinTypes/EReel.i3">EReel</A>, <A HREF="ReelExpr.i3">ReelExpr</A>, <A HREF="DivExpr.i3">DivExpr</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

TYPE
  Class = { cINT, cREAL, cLONG, cEXTND, cERR };

CONST
  CGType = ARRAY Class OF CG.Type {
             CG.Type.Int,   CG.Type.Reel, CG.Type.LReel,
             CG.Type.XReel, CG.Type.Word };

TYPE
  P = ExprRep.Tab BRANDED &quot;ModExpr.P&quot; OBJECT
        class: Class;
        tmp1 : CG.Var;
        tmp2 : CG.Var;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := ExprRep.EqCheckAB;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a, b: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.a    := a;
    p.b    := b;
    p.type := Int.T;
    p.tmp1 := NIL;
    p.tmp2 := NIL;
    RETURN p;
  END New;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR ta, tb: Type.T;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    Expr.TypeCheck (p.b, cs);
    ta := Type.Base (Expr.TypeOf (p.a));
    tb := Type.Base (Expr.TypeOf (p.b));
    IF    (ta = Int.T)   AND (tb = Int.T)   THEN
      p.class := Class.cINT;  INC (cs.div_ops);
    ELSIF (ta = Reel.T)  AND (tb = Reel.T)  THEN
      p.class := Class.cREAL;  INC (cs.fp_ops);
    ELSIF (ta = LReel.T) AND (tb = LReel.T) THEN
      p.class := Class.cLONG;  INC (cs.fp_ops);
    ELSIF (ta = EReel.T) AND (tb = EReel.T) THEN
      p.class := Class.cEXTND;  INC (cs.fp_ops);
    ELSE p.class := Class.cERR;  ta := Int.T;
      ta := Expr.BadOperands (&quot;MOD&quot;, ta, tb);
    END;
    p.type := ta;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  VAR cg_type: CG.Type;  sz, align: INTEGER;  info: Type.Info;
  BEGIN
    Expr.Prep (p.a);
    Expr.Prep (p.b);
    IF (p.class # Class.cINT) THEN
      (* floating point: x MOD y == x - y * FLOOR (x / y)  *)
      EVAL Type.CheckInfo (p.a.type, info);
      sz := info.size;
      align := info.alignment;
      cg_type := CGType [p.class];

      Expr.Compile (p.a);
      p.tmp1 := CG.Declare_temp (sz, align, cg_type, in_memory := FALSE);
      CG.Store (p.tmp1, 0, sz, align, cg_type);

      Expr.Compile (p.b);
      p.tmp2 := CG.Declare_temp (sz, align, cg_type, in_memory := FALSE);
      CG.Store (p.tmp2, 0, sz, align, cg_type);
    END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR
    cg_type: CG.Type;
    info: Type.Info;
    sz, align: INTEGER;
    e1, e2, e3: Expr.T;
    divisor, mask: Target.Int;
    log: INTEGER;
  BEGIN
    IF (p.class = Class.cINT) THEN
      e1 := Expr.ConstValue (p.a);
      e2 := Expr.ConstValue (p.b);
      e3 := NIL;
      IF (e1 # NIL) AND (e2 # NIL) AND IntegerExpr.Mod (e1, e2, e3) THEN
      ELSIF (e2 # NIL)
        AND IntegerExpr.Split (e2, divisor)
        AND DivExpr.SmallPowerOfTwo (divisor, log) THEN
        IF (e1 = NIL) THEN e1 := p.a; END;
        IF (log = 0) THEN
          (* mod 1 =&gt; zero *)
          Expr.Compile (e1);
          CG.Discard (CG.Type.Int);
          CG.Load_integer (TInt.Zero);
        ELSE
          EVAL TInt.Subtract (divisor, TInt.One, mask);
          Expr.Compile (e1);
          CG.Load_integer (mask);
          CG.And ();
        END;
      ELSE
        IF (e1 = NIL) THEN e1 := p.a; END;
        IF (e2 = NIL) THEN e2 := p.b; END;
        Expr.Compile (e1);
        Expr.Compile (e2);
        CG.Mod (CG.Type.Int, Expr.GetSign (e1), Expr.GetSign (e2));
      END;
    ELSE
      (* floating point: x MOD y == x - y * FLOOR (x / y)  *)
      EVAL Type.CheckInfo (p.a.type, info);
      sz := info.size;
      align := info.alignment;
      cg_type := CGType [p.class];

      CG.Load (p.tmp1, 0, sz, align, cg_type);
      CG.Load (p.tmp2, 0, sz, align, cg_type);
      CG.Divide (cg_type);
      CG.Floor (cg_type);
      CG.Cvt_float (CG.Type.Int, cg_type);
      CG.Load (p.tmp2, 0, sz, align, cg_type);
      CG.Multiply (cg_type);
      CG.Load (p.tmp1, 0, sz, align, cg_type);
      CG.Swap ();
      CG.Subtract (cg_type);

      CG.Free_temp (p.tmp1);
      CG.Free_temp (p.tmp2);
      p.tmp1 := NIL;
      p.tmp2 := NIL;
    END;
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e1, e2, e3: Expr.T;
  BEGIN
    e1 := Expr.ConstValue (p.a);
    e2 := Expr.ConstValue (p.b);
    e3 := NIL;
    IF    (e1 = NIL) OR (e2 = NIL)     THEN
    ELSIF IntegerExpr.Mod (e1, e2, e3) THEN
    ELSIF ReelExpr.Mod    (e1, e2, e3) THEN
    END;
    RETURN e3;
  END Fold;

BEGIN
END ModExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
