<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/NegateExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/NegateExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: NegateExpr.m3                                         

<P><PRE>MODULE <module><implements><A HREF="NegateExpr.i3">NegateExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../builtinTypes/Reel.i3">Reel</A>, <A HREF="../builtinTypes/LReel.i3">LReel</A>, <A HREF="../builtinTypes/EReel.i3">EReel</A>;
IMPORT <A HREF="IntegerExpr.i3">IntegerExpr</A>, <A HREF="ReelExpr.i3">ReelExpr</A>;

TYPE
  P = ExprRep.Ta BRANDED &quot;NegateExpr.P&quot; OBJECT
        folded : Expr.T;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := ExprRep.EqCheckA;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.a := a;
    p.folded := NIL;
    RETURN p;
  END New;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  BEGIN
    RETURN Expr.TypeOf (p.a)
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR t: Type.T;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    t := Type.Base (Expr.TypeOf (p.a));
    IF (t = Int.T) THEN
      INC (cs.int_ops);
    ELSIF (t = Reel.T) OR (t = LReel.T) OR (t = EReel.T) THEN
      INC (cs.fp_ops);
    ELSE
      t := Expr.BadOperands (&quot;unary \'-\'&quot;, t);
    END;
    p.type := t;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  VAR e := Fold (p);
  BEGIN
    IF (e = NIL)
      THEN Expr.Prep (p.a);
      ELSE Expr.Prep (e);
    END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR e := p.folded;
  BEGIN
    IF (e = NIL) THEN
      Expr.Compile (p.a);
      CG.Negate (Type.CGType (p.type));
    ELSE
      Expr.Compile (e);
    END;
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e1, e3: Expr.T;
  BEGIN
    IF (p.folded # NIL) THEN RETURN p.folded END;
    e1 := Expr.ConstValue (p.a);
    e3 := NIL;
    IF    (e1 = NIL)                  THEN
    ELSIF IntegerExpr.Negate (e1, e3) THEN
    ELSIF ReelExpr.Negate    (e1, e3) THEN
    END;
    p.folded := e3;
    RETURN e3;
  END Fold;

BEGIN
END NegateExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
