<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/NilChkExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/NilChkExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: NilChkExpr.m3                                         
 Last Modified On Thu Jun 30 08:50:41 PDT 1994 By kalsow     
      Modified On Thu Nov 29 03:28:30 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="NilChkExpr.i3">NilChkExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="AddressExpr.i3">AddressExpr</A>;
IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../types/RefType.i3">RefType</A>, <A HREF="../misc/Host.i3">Host</A>, <A HREF="../types/OpenArrayType.i3">OpenArrayType</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>;

TYPE
  P = ExprRep.Ta BRANDED &quot;NilChkExpr.P&quot; OBJECT
        offset       : INTEGER;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := ExprRep.EqCheckA;
        getBounds    := Bounder;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := NoteWrites;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    IF (NOT Host.doNilChk) OR (TYPECODE (a) = TYPECODE (P)) THEN RETURN a END;
    p := NEW (P);
    ExprRep.Init (p);
    p.origin := a.origin;
    p.a := a;
    p.offset := LAST (INTEGER);
    RETURN p;
  END New;

PROCEDURE <A NAME="SetOffset"><procedure>SetOffset</procedure></A> (a: Expr.T; offset: INTEGER) =
  BEGIN
    TYPECASE a OF
    | NULL =&gt; (* skip *)
    | P(p) =&gt; p.offset := MIN (p.offset, offset);
    ELSE      (* skip *)
    END;
  END SetOffset;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  BEGIN
    RETURN Expr.TypeOf (p.a)
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR target: Type.T;  x: INTEGER;  info: Type.Info;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    p.type := Type.Check (Expr.TypeOf (p.a));
    IF RefType.Split (p.type, target) THEN
      IF OpenArrayType.Is (target)
        THEN x := MIN (M3RT.OA_elt_ptr, M3RT.OA_size_0);
        ELSE EVAL Type.CheckInfo (target, info);  x := info.size;
      END;
      p.offset := MIN (p.offset, x);
    END;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  BEGIN
    Expr.Prep (p.a);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR EasyCheck := Target.First_readable_addr * Target.Char.size;
  BEGIN
    Expr.Compile (p.a);
    IF (p.offset &lt; 0) OR (EasyCheck &lt;= p.offset) THEN
      CG.Check_nil ();
    END;
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e: Expr.T;  i: Target.Int;
  BEGIN
    e := Expr.ConstValue (p.a);
    IF (e = NIL) THEN RETURN NIL END;
    IF  NOT AddressExpr.Split (e, i) THEN RETURN NIL END;
    IF TInt.EQ (i, TInt.Zero) THEN RETURN NIL END;
    RETURN e;
  END Fold;

PROCEDURE <A NAME="Bounder"><procedure>Bounder</procedure></A> (p: P;  VAR min, max: Target.Int) =
  BEGIN
    Expr.GetBounds (p.a, min, max);
  END Bounder;

PROCEDURE <A NAME="NoteWrites"><procedure>NoteWrites</procedure></A> (p: P) =
  BEGIN
    Expr.NoteWrite (p.a);
  END NoteWrites;

BEGIN
END NilChkExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
