<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/NotExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/NotExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: NotExpr.m3                                            

<P><PRE>MODULE <module><implements><A HREF="NotExpr.i3">NotExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Bool.i3">Bool</A>, <A HREF="EnumExpr.i3">EnumExpr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

TYPE
  P = ExprRep.Ta BRANDED &quot;NotExpr.P&quot; OBJECT
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := PrepBR;
        compileBR    := ExprRep.NoBranch;
        evaluate     := Fold;
        isEqual      := ExprRep.EqCheckA;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.a    := a;
    p.type := Bool.T;
    RETURN p;
  END New;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR ta: Type.T;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    ta := Type.Base (Expr.TypeOf (p.a));
    IF (ta # Bool.T) THEN
      p.type := Expr.BadOperands (&quot;NOT&quot;, ta);
    END;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  BEGIN
    Expr.Prep (p.a);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    Expr.Compile (p.a);
    CG.Load_integer (TInt.Zero);
    CG.Eq (CG.Type.Int);
  END Compile;

PROCEDURE <A NAME="PrepBR"><procedure>PrepBR</procedure></A> (p: P;  true, false: CG.Label;  freq: CG.Frequency) =
  BEGIN
    Expr.PrepBranch (p.a, false, true, CG.Always - freq);
    Expr.CompileBranch (p.a, false, true, CG.Always - freq);
  END PrepBR;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e1, e3: Expr.T;  ii: Target.Int; i: INTEGER; t: Type.T;
  BEGIN
    e1 := Expr.ConstValue (p.a);
    e3 := NIL;
    IF (e1 # NIL)
      AND (EnumExpr.Split (e1, ii, t))
      AND (Type.Base (t) = Bool.T)
      AND TInt.ToInt (ii, i) THEN
      e3 := Bool.Map[ORD (FALSE) = i]
    END;
    RETURN e3;
  END Fold;

BEGIN
END NotExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
