<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/OrExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/OrExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: OrExpr.m3                                             

<P><PRE>MODULE <module><implements><A HREF="OrExpr.i3">OrExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Bool.i3">Bool</A>, <A HREF="EnumExpr.i3">EnumExpr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

TYPE
  P = ExprRep.Tab BRANDED &quot;OrExpr.P&quot; OBJECT
        tmp: CG.Val;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := PrepBR;
        compileBR    := ExprRep.NoBranch;
        evaluate     := Fold;
        isEqual      := ExprRep.EqCheckAB;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a, b: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.a    := a;
    p.b    := b;
    p.type := Bool.T;
    p.tmp  := NIL;
    RETURN p;
  END New;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR ta, tb: Type.T;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    Expr.TypeCheck (p.b, cs);
    ta := Type.Base (Expr.TypeOf (p.a));
    tb := Type.Base (Expr.TypeOf (p.b));
    IF (ta # Bool.T) OR (tb # Bool.T) THEN
      p.type := Expr.BadOperands (&quot;OR&quot;, ta, tb);
    END;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  VAR true := CG.Next_label ();
  BEGIN
    CG.Load_integer (TInt.One);
    p.tmp := CG.Pop_temp ();
    PrepBR (p, true, CG.No_label, CG.Maybe);
    CG.Load_integer (TInt.Zero);
    CG.Store_temp (p.tmp);
    CG.Set_label (true);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    CG.Push (p.tmp);
    CG.Free (p.tmp);
    p.tmp := NIL;
  END Compile;

PROCEDURE <A NAME="PrepBR"><procedure>PrepBR</procedure></A> (p: P;  true, false: CG.Label;  freq: CG.Frequency) =
  VAR skip: CG.Label;
  BEGIN
    IF (false = CG.No_label) THEN
      Expr.PrepBranch (p.a, true, false, freq);
      Expr.CompileBranch (p.a, true, false, freq);
      Expr.PrepBranch (p.b, true, false, freq);
      Expr.CompileBranch (p.b, true, false, freq);
    ELSE (* true = NoLabel =&gt; fall through *)
      skip := CG.Next_label ();
      Expr.PrepBranch (p.a, skip, CG.No_label, CG.Always - freq);
      Expr.CompileBranch (p.a, skip, CG.No_label, CG.Always - freq);
      Expr.PrepBranch (p.b, CG.No_label, false, freq);
      Expr.CompileBranch (p.b, CG.No_label, false, freq);
      CG.Set_label (skip);
    END;
  END PrepBR;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e1, e2: Expr.T; i1, i2: Target.Int; t1, t2: Type.T;  z1, z2: INTEGER;
  BEGIN
    e1 := Expr.ConstValue (p.a);
    e2 := Expr.ConstValue (p.b);
    IF (e1 = NIL) OR (e2 = NIL)
      OR (NOT EnumExpr.Split (e1, i1, t1))
      OR (NOT EnumExpr.Split (e2, i2, t2))
      OR (Type.Base (t1) # Bool.T)
      OR (Type.Base (t2) # Bool.T)
      OR (NOT TInt.ToInt (i1, z1))
      OR (NOT TInt.ToInt (i2, z2)) THEN
      RETURN NIL;
    ELSE
      RETURN Bool.Map[(ORD (TRUE) = z1) OR (ORD (TRUE) = z2)];
    END;
  END Fold;

BEGIN
END OrExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
