<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/ProcExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/ProcExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ProcExpr.m3                                           

<P><PRE>MODULE <module><implements><A HREF="ProcExpr.i3">ProcExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;
IMPORT <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../misc/ProcBody.i3">ProcBody</A>;

TYPE
  P = Expr.T OBJECT
        proc : Value.T;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := ExprRep.NoPrep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := ExprRep.Self;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := GenFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := GenLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (proc: Value.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.proc := Value.Base (proc);
    RETURN p;
  END New;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (e: Expr.T;  VAR proc: Value.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; proc := p.proc; RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Split;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A> (a, b: Expr.T;  VAR sign: INTEGER): BOOLEAN =
  VAR x, y: Value.T;
  BEGIN
    TYPECASE a OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; x := p.proc;
    ELSE      RETURN FALSE;
    END;
    TYPECASE b OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; y := p.proc;
    ELSE      RETURN FALSE;
    END;
    IF (x = y) THEN sign := 0 ELSE sign :=  -3 END;
    RETURN TRUE;
  END Compare;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  BEGIN
    RETURN Value.TypeOf (p.proc);
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  BEGIN
    Value.TypeCheck (p.proc, cs);
    p.type := Value.TypeOf (p.proc);
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN Procedure.IsEqual (a.proc, b.proc);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    Value.Load (p.proc);
  END Compile;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  VAR s: Scope.IDStack;
  BEGIN
    s.top := 0;
    Scope.NameToPrefix (p.proc, s, dots := TRUE);
    Scope.PutStack (buf, s);
  END GenFPLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (p: P;  offset: INTEGER;  &lt;*UNUSED*&gt;type: Type.T) =
  VAR proc: CG.Proc;  globals: CG.Var;  g_offset: INTEGER;
  BEGIN
    Procedure.CGName (p.proc, proc, globals, g_offset);
    IF (proc # NIL)
      THEN CG.Init_proc (offset, proc);
      ELSE ProcBody.DelayedInit (offset, globals, g_offset);
    END;
  END GenLiteral;

BEGIN
END ProcExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
