<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/QualifyExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/QualifyExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: QualifyExpr.m3                                        

<P><PRE>MODULE <module><implements><A HREF="QualifyExpr.i3">QualifyExpr</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Module.i3">Module</A>;
IMPORT <A HREF="../types/RecordType.i3">RecordType</A>, <A HREF="../types/ObjectType.i3">ObjectType</A>, <A HREF="../values/Variable.i3">Variable</A>, <A HREF="VarExpr.i3">VarExpr</A>, <A HREF="../misc/Scope.i3">Scope</A>;
IMPORT <A HREF="../types/EnumType.i3">EnumType</A>, <A HREF="../types/RefType.i3">RefType</A>, <A HREF="DerefExpr.i3">DerefExpr</A>, <A HREF="NamedExpr.i3">NamedExpr</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/ProcType.i3">ProcType</A>;
IMPORT <A HREF="../builtinTypes/ErrType.i3">ErrType</A>, <A HREF="RecordExpr.i3">RecordExpr</A>, <A HREF="TypeExpr.i3">TypeExpr</A>, <A HREF="MethodExpr.i3">MethodExpr</A>, <A HREF="ProcExpr.i3">ProcExpr</A>;
IMPORT <A HREF="../values/Method.i3">Method</A>, <A HREF="../values/Field.i3">Field</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/M3RT.i3">M3RT</A>;

TYPE
  Class = { cMODULE, cENUM, cOBJTYPE, cFIELD, cOBJFIELD, cMETHOD, cUNKNOWN };

TYPE
  VC = Value.Class;

TYPE
  P = Expr.T BRANDED &quot;QualifyExpr.T&quot; OBJECT
        expr        : Expr.T;
        obj         : Value.T;
        holder      : Type.T;
        objType     : Type.T;
	temp        : CG.Val;
        name        : M3ID.T;
        class       : Class;
        inFold      : BOOLEAN;
        inIsZeroes  : BOOLEAN;
        inGetBounds : BOOLEAN;
        inTypeOf    : BOOLEAN;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := Prep;
        compile      := Compile;
        prepLV       := Prep;
        compileLV    := CompileLV;
        prepBR       := ExprRep.PrepNoBranch;
        compileBR    := ExprRep.NoBranch;
        evaluate     := Fold;
        isEqual      := EqCheck;
        getBounds    := Bounder;
        isWritable   := IsWritable;
        isDesignator := IsDesignator;
	isZeroes     := IsZeroes;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := NoteWrites;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a: Expr.T;  id: M3ID.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.expr        := a;
    p.name        := id;
    p.obj         := NIL;
    p.class       := Class.cUNKNOWN;
    p.holder      := NIL;
    p.objType     := NIL;
    p.inFold      := FALSE;
    p.inIsZeroes  := FALSE;
    p.inGetBounds := FALSE;
    p.inTypeOf    := FALSE;
    RETURN p;
  END New;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (e: Expr.T; VAR obj: Value.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; Resolve (p); obj := p.obj; RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Split;

PROCEDURE <A NAME="SplitQID"><procedure>SplitQID</procedure></A> (e: Expr.T;  VAR module, item: M3ID.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; IF NamedExpr.SplitName (p.expr, module)
                 THEN item := p.name; RETURN TRUE;
                 ELSE RETURN FALSE;
              END;
    ELSE      RETURN FALSE;
    END;
  END SplitQID;

PROCEDURE <A NAME="PassObject"><procedure>PassObject</procedure></A> (e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; (* nothing *)
    | P(p) =&gt; IF (p.class = Class.cMETHOD) THEN
                CG.Push (p.temp);
                CG.Pop_param (CG.Type.Addr);
                CG.Free (p.temp);
                p.temp := NIL;
		RETURN TRUE;
              END;
    ELSE      (* nothing *)
    END;
    RETURN FALSE;
  END PassObject;

PROCEDURE <A NAME="MethodType"><procedure>MethodType</procedure></A> (e: Expr.T): Type.T =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; (* nothing *)
    | P(p) =&gt; Resolve (p);
              IF (p.class = Class.cMETHOD) THEN RETURN Value.TypeOf(p.obj) END;
    ELSE      (* nothing *)
    END;
    RETURN NIL;
  END MethodType;

PROCEDURE <A NAME="Bounder"><procedure>Bounder</procedure></A> (p: P;  VAR min, max: Target.Int) =
  BEGIN
    Resolve (p);
    IF (p.inGetBounds) THEN Value.IllegalRecursion (p.obj) END;
    p.inGetBounds := TRUE;
    CASE Value.ClassOf (p.obj) OF
    | Value.Class.Expr =&gt; Expr.GetBounds (Value.ToExpr (p.obj), min, max);
    | Value.Class.Var  =&gt; Variable.GetBounds (p.obj, min, max);
    ELSE                  EVAL Type.GetBounds (p.type, min, max);
    END;
    p.inGetBounds := FALSE;
  END Bounder;

PROCEDURE <A NAME="MakeDummy"><procedure>MakeDummy</procedure></A> (p: P) =
  BEGIN
    p.class := Class.cMODULE;
    p.obj   := VarExpr.Obj (VarExpr.New (ErrType.T, p.name));
  END MakeDummy;

PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (p: P) =
  VAR
    t      : Type.T;
    base_t : Type.T;
    s      : Scope.T;
    obj    : Value.T;
    name   : M3ID.T;
  BEGIN
    IF (p.class # Class.cUNKNOWN) THEN RETURN END;

    t := Expr.TypeOf (p.expr);

    IF RefType.Is (t) THEN
      (* auto-magic dereference *)
      p.expr := DerefExpr.New (p.expr);
      p.expr.origin := p.origin;
      t := Expr.TypeOf (p.expr);
    END;

    p.holder := t;
    p.obj := NIL;
    base_t := Type.Base (t);

    IF (t = ErrType.T) THEN
      (* the lhs already contains an error =&gt; silently make it look like
         everything is ok. *)
      MakeDummy (p);

    ELSIF (t = NIL) THEN
      (* a module or type *)
      IF TypeExpr.Split (p.expr, t) THEN
        IF EnumType.LookUp (t, p.name, p.obj) THEN
          p.class := Class.cENUM;
        ELSIF ObjectType.LookUp (t, p.name, p.obj, p.holder) THEN
          p.objType := t;
          p.class := Class.cOBJTYPE;
        END;
      ELSIF NamedExpr.Split (p.expr, name, obj) THEN
        IF (Value.ClassOf (obj) = VC.Module) THEN
          p.class := Class.cMODULE;
          s := Module.ExportScope (Value.Base (obj));
          p.obj := Scope.LookUp (s, p.name, TRUE);
        END;
      END;

    ELSIF RecordType.LookUp (base_t, p.name, p.obj) THEN
      p.class := Class.cFIELD;

    ELSIF ObjectType.LookUp (base_t, p.name, p.obj, p.holder) THEN
      IF (Value.ClassOf (p.obj) = VC.Field)
        THEN p.class := Class.cOBJFIELD;
        ELSE p.class := Class.cMETHOD;
      END;
    END;
  END Resolve;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  BEGIN
    Resolve (p);
    IF (p.inTypeOf) THEN
      Value.IllegalRecursion (p.obj);
      p.type := ErrType.T;
      RETURN ErrType.T;
    END;
    p.inTypeOf := TRUE;
    p.type := Value.TypeOf (p.obj);
    IF p.class = Class.cMETHOD THEN
      p.type := NIL;
    ELSIF p.class = Class.cOBJTYPE THEN
      p.type := ProcType.MethodSigAsProcSig (p.type, p.objType);
    END;
    p.inTypeOf := FALSE;
    RETURN p.type;
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR nErrs0, nErrs1, nWarns: INTEGER;  info: Type.Info;
  BEGIN
    Error.Count (nErrs0, nWarns);
      Expr.TypeCheck (p.expr, cs);
      Resolve (p);
      Expr.TypeCheck (p.expr, cs);
    Error.Count (nErrs1, nWarns);

    IF (p.obj = NIL) THEN
      IF (nErrs0 = nErrs1) THEN
        Error.ID (p.name, &quot;unknown qualification \'.\'&quot;);
      END;
      MakeDummy (p);
    ELSIF (p.class = Class.cFIELD) THEN
      EVAL Type.CheckInfo (p.holder, info);
      DerefExpr.SetOffset (p.expr, info.size);
    ELSIF (p.class = Class.cOBJTYPE)
      AND (Value.ClassOf (p.obj) # VC.Method) THEN
      Error.ID (p.name, &quot;doesn\'t name a method&quot;);
    END;

    Value.TypeCheck (p.obj, cs);
    EVAL TypeOf (p);
    IF (p.type # NIL) THEN
      p.type := Type.Check (p.type);
    END;
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; Resolve (a);  Resolve (b);
              RETURN (a.obj = b.obj)
                 AND (a.class = b.class)
                 AND Expr.IsEqual (a.expr, b.expr);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (p: P) =
  VAR c: Value.Class;
  BEGIN
    CASE p.class OF
    | Class.cMODULE =&gt;
        c := Value.ClassOf (p.obj);
        IF (c = Value.Class.Var) THEN
          Variable.NeedsAddress (p.obj);
        ELSIF (c = Value.Class.Expr) THEN
          Expr.NeedsAddress (Value.ToExpr (p.obj));
        END;
    | Class.cFIELD =&gt;
        Expr.NeedsAddress (p.expr);
    | Class.cOBJFIELD =&gt;
        (* ok, all objects have addresses *)
    | Class.cENUM,
      Class.cOBJTYPE,
      Class.cMETHOD,
      Class.cUNKNOWN =&gt;
        &lt;* ASSERT FALSE *&gt;
    END;
  END NeedsAddress;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  BEGIN
    CASE p.class OF
    | Class.cMODULE, Class.cENUM =&gt;
        (* skip *)
    | Class.cOBJTYPE =&gt;
        (* skip *)
    | Class.cFIELD =&gt;
        IF Expr.IsDesignator (p.expr)
          THEN Expr.PrepLValue (p.expr);
          ELSE Expr.Prep (p.expr);
        END;
    | Class.cOBJFIELD =&gt;
        Expr.Prep (p.expr);
    | Class.cMETHOD =&gt;
        Expr.Prep (p.expr);
        Expr.Compile (p.expr);
        p.temp := CG.Pop ();
    | Class.cUNKNOWN =&gt;
        &lt;* ASSERT FALSE *&gt;
    END;
 END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR
    obj_offset, obj_align: INTEGER;
    field: Field.Info;
    method: Method.Info;
  BEGIN
    CASE p.class OF
    | Class.cMODULE, Class.cENUM =&gt;
        Value.Load (p.obj);
    | Class.cOBJTYPE =&gt;
        Type.Compile (p.holder);
        Type.Compile (p.objType);
        Method.SplitX (p.obj, method);
        Type.LoadInfo (p.objType, M3RT.TC_defaultMethods, addr := TRUE);
        obj_offset := ObjectType.MethodOffset (p.holder);
        IF (obj_offset &gt;= 0) THEN
          INC (method.offset, obj_offset);
        ELSE
          Type.LoadInfo (p.holder, M3RT.TC_methodOffset);
          CG.Index_bytes (Target.Byte);
        END;
        CG.Boost_alignment (Target.Address.align);
        CG.Load_indirect (CG.Type.Addr, method.offset, Target.Address.size);
        CG.Boost_alignment (Target.Address.align);
    | Class.cFIELD =&gt;
        Field.Split (p.obj, field);
        IF Expr.IsDesignator (p.expr)
          THEN Expr.CompileLValue (p.expr);
          ELSE Expr.Compile (p.expr);
        END;
        CG.Add_offset (field.offset);
        Type.LoadScalar (field.type);
    | Class.cOBJFIELD =&gt;
        Field.Split (p.obj, field);
        Expr.Compile (p.expr);
        CG.Boost_alignment (Target.Address.align);
        ObjectType.GetFieldOffset (p.holder, obj_offset, obj_align);
        IF (obj_offset &gt;= 0) THEN
          INC (field.offset, obj_offset);
        ELSE
          CG.Check_nil ();
          Type.LoadInfo (p.holder, M3RT.TC_dataOffset);
          CG.Index_bytes (Target.Byte);
        END;
        CG.Add_offset (field.offset);
        CG.Boost_alignment (obj_align);
        Type.LoadScalar (field.type);
    | Class.cMETHOD =&gt;
        Method.SplitX (p.obj, method);
        CG.Push (p.temp);
        CG.Boost_alignment (Target.Address.align);
        CG.Load_indirect (CG.Type.Addr, 0, Target.Address.size);
        CG.Boost_alignment (Target.Address.align);
        obj_offset := ObjectType.MethodOffset (p.holder);
        IF (obj_offset &gt;= 0) THEN
          INC (method.offset, obj_offset);
        ELSE
          Type.LoadInfo (p.holder, M3RT.TC_methodOffset);
          CG.Index_bytes (Target.Byte);
        END;
        CG.Boost_alignment (Target.Address.align);
        CG.Load_indirect (CG.Type.Addr, method.offset, Target.Address.size);
        CG.Boost_alignment (Target.Address.align);
    | Class.cUNKNOWN =&gt;
        &lt;* ASSERT FALSE *&gt;
    END;
 END Compile;

PROCEDURE <A NAME="CompileLV"><procedure>CompileLV</procedure></A> (p: P) =
  VAR obj_offset, obj_align: INTEGER;  field: Field.Info;
  BEGIN
    CASE p.class OF
    | Class.cMODULE =&gt;
        Variable.LoadLValue (p.obj);
    | Class.cFIELD =&gt;
        Field.Split (p.obj, field);
        Expr.CompileLValue (p.expr);
        CG.Add_offset (field.offset);
    | Class.cOBJFIELD =&gt;
        Field.Split (p.obj, field);
        Expr.Compile (p.expr);
        ObjectType.GetFieldOffset (p.holder, obj_offset, obj_align);
        IF (obj_offset &gt;= 0) THEN
          INC (field.offset, obj_offset);
        ELSE
          CG.Check_nil ();
          Type.LoadInfo (p.holder, M3RT.TC_dataOffset);
          CG.Index_bytes (Target.Byte);
        END;
        CG.Add_offset (field.offset);
        CG.Boost_alignment (obj_align);
    | Class.cENUM,
      Class.cOBJTYPE,
      Class.cMETHOD,
      Class.cUNKNOWN =&gt;
        &lt;* ASSERT FALSE *&gt;
    END;
 END CompileLV;

TYPE
  Kind = {Value, Expr, Type, None};
  LHS = RECORD
          kind  : Kind;
          value : Value.T;
          expr  : Expr.T;
          type  : Type.T;
        END;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR lhs: LHS;  e: Expr.T;
  BEGIN
    IF (p.inFold) THEN Value.IllegalRecursion (p.obj); RETURN NIL END;
    p.inFold := TRUE;

    (* evaluate the qualified expression *)
    lhs.kind := Kind.Expr;
    lhs.expr := p.expr;
    DoQualify (lhs, p.name);

    (* finally, simplify the result to an Expr.T if possible *)
    CASE lhs.kind OF
    | Kind.None =&gt;
        e := NIL;
    | Kind.Expr =&gt;
        e := Expr.ConstValue (lhs.expr);
    | Kind.Type =&gt;
        e := TypeExpr.New (lhs.type);
    | Kind.Value =&gt;
        CASE Value.ClassOf (lhs.value) OF
        | VC.Expr =&gt;
            e := Expr.ConstValue (Value.ToExpr (lhs.value));
        | VC.Type =&gt;
            e := NIL; (* TypeExpr.New (Value.ToType (lhs.value));*)
        | VC.Procedure =&gt;
            e := ProcExpr.New (lhs.value);
            (* lhs.value is a procedure *)
        ELSE (* not possible to convert to an expression *)
            e := NIL;
        END;
    END;

    p.inFold := FALSE;
    RETURN e;
  END Fold;

PROCEDURE <A NAME="DoQualify"><procedure>DoQualify</procedure></A> (VAR lhs: LHS;  name: M3ID.T) =
  VAR
    e: Expr.T;
    v: Value.T;
    p: P;
    s: Scope.T;
    t, t1: Type.T;
    n: M3ID.T;
  BEGIN
    CASE lhs.kind OF
    | Kind.None =&gt;
        (* don't even try *)
    | Kind.Expr =&gt;
        IF lhs.expr = NIL THEN
          lhs.kind := Kind.None; (*FINAL*)
        ELSIF (TYPECODE (lhs.expr) = TYPECODE (P)) THEN
          p := lhs.expr;
          lhs.kind  := Kind.Expr;
          lhs.expr  := p.expr;
          DoQualify (lhs, p.name);
          DoQualify (lhs, name);
        ELSIF TypeExpr.Split (lhs.expr, t) THEN
          lhs.kind  := Kind.Type;
          lhs.type  := t;
          DoQualify (lhs, name);
        ELSIF NamedExpr.Split (lhs.expr, n, v) THEN
          lhs.kind  := Kind.Value;
          lhs.value := v;
          DoQualify (lhs, name);
        ELSIF RecordExpr.Qualify (lhs.expr, name, e) THEN
          lhs.kind  := Kind.Expr;  (*FINAL*)
          lhs.expr  := e;
        ELSE
          e := Expr.ConstValue (lhs.expr);
          IF (e # lhs.expr) THEN
            (* try qualifying the constant value *)
            lhs.kind  := Kind.Expr;
            lhs.expr  := Expr.ConstValue (lhs.expr);
            DoQualify (lhs, name);
          ELSE
            lhs.kind := Kind.None; (*FINAL*)
          END;
        END;
    | Kind.Type =&gt;
        t := Type.Strip (lhs.type);
        IF EnumType.LookUp (t, name, v) THEN
          lhs.kind  := Kind.Expr;  (*FINAL*)
          lhs.expr  := Value.ToExpr (v);
        ELSIF ObjectType.LookUp (t, name, v, t1)
          AND (Value.ClassOf (v) = VC.Method) THEN
          lhs.kind  := Kind.Expr;  (*FINAL*)
          lhs.expr  := MethodExpr.New (t, name, v, t1);
        ELSE (* type that can't be qualified *)
          lhs.kind  := Kind.None;  (*FINAL*)
        END;
    | Kind.Value =&gt;
        CASE Value.ClassOf (lhs.value) OF
        | VC.Expr =&gt;
            lhs.kind  := Kind.Expr;
            lhs.expr  := Value.ToExpr (lhs.value);
            DoQualify (lhs, name);
        | VC.Type =&gt;
            lhs.kind  := Kind.Type;
            lhs.type  := Value.ToType (lhs.value);
            DoQualify (lhs, name);
        | VC.Module =&gt;
            s := Module.ExportScope (Value.Base (lhs.value));
            lhs.kind  := Kind.Value;   (*FINAL*)
            lhs.value := Scope.LookUp (s, name, TRUE);
        ELSE (* can't qualify this kind of value *)
            lhs.kind  := Kind.None;  (*FINAL*)
        END;
    END;
  END DoQualify;

PROCEDURE <A NAME="IsDesignator"><procedure>IsDesignator</procedure></A> (p: P): BOOLEAN =
  BEGIN
    CASE p.class OF
    | Class.cMODULE   =&gt; RETURN (Value.ClassOf (p.obj) = VC.Var);
    | Class.cENUM     =&gt; RETURN FALSE;
    | Class.cOBJTYPE  =&gt; RETURN FALSE;
    | Class.cFIELD    =&gt; RETURN Expr.IsDesignator (p.expr);
    | Class.cOBJFIELD =&gt; RETURN TRUE;
    | Class.cMETHOD   =&gt; RETURN FALSE;
    | Class.cUNKNOWN  =&gt; RETURN FALSE;
    END;
  END IsDesignator;

PROCEDURE <A NAME="IsWritable"><procedure>IsWritable</procedure></A> (p: P): BOOLEAN =
  BEGIN
    CASE p.class OF
    | Class.cMODULE   =&gt; RETURN Value.IsWritable (p.obj);
    | Class.cENUM     =&gt; RETURN FALSE;
    | Class.cOBJTYPE  =&gt; RETURN FALSE;
    | Class.cFIELD    =&gt; RETURN Expr.IsWritable (p.expr);
    | Class.cOBJFIELD =&gt; RETURN TRUE;
    | Class.cMETHOD   =&gt; RETURN FALSE;
    | Class.cUNKNOWN  =&gt; RETURN FALSE;
    END;
  END IsWritable;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (p: P): BOOLEAN =
  VAR lhs: LHS;  b: BOOLEAN;
  BEGIN
    IF (p.inIsZeroes) THEN Value.IllegalRecursion (p.obj); RETURN FALSE END;
    p.inIsZeroes := TRUE;

    (* evaluate the qualified expression *)
    lhs.kind := Kind.Expr;
    lhs.expr := p.expr;
    DoQualify (lhs, p.name);

    (* finally, simplify the result to an Expr.T if possible *)
    CASE lhs.kind OF
    | Kind.None =&gt;
        b := FALSE;
    | Kind.Expr =&gt;
        b := Expr.IsZeroes (lhs.expr);
    | Kind.Type =&gt;
        b := FALSE;
    | Kind.Value =&gt;
        b := (Value.ClassOf (lhs.value) = VC.Expr)
              AND Expr.IsZeroes (Value.ToExpr (lhs.value));
    END;

    p.inIsZeroes := FALSE;
    RETURN b;
  END IsZeroes;

PROCEDURE <A NAME="NoteWrites"><procedure>NoteWrites</procedure></A> (p: P) =
  BEGIN
    CASE p.class OF
    | Class.cENUM     =&gt; (*skip*)
    | Class.cOBJTYPE  =&gt; (*skip*)
    | Class.cMETHOD   =&gt; (*skip*)
    | Class.cUNKNOWN  =&gt; (*skip*)
    | Class.cFIELD    =&gt; Expr.NoteWrite (p.expr);
    | Class.cOBJFIELD =&gt; Expr.NoteWrite (p.expr);
    | Class.cMODULE   =&gt; IF (Value.ClassOf (p.obj) = VC.Var) THEN
                           Variable.ScheduleTrace (Value.Base (p.obj));
                         END;
    END;
  END NoteWrites;

BEGIN
END QualifyExpr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
