<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/RangeExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/RangeExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: RangeExpr.m3                                          

<P><PRE>MODULE <module><implements><A HREF="RangeExpr.i3">RangeExpr</A></implements></module>;

IMPORT <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../types/EnumType.i3">EnumType</A>;
IMPORT <A HREF="EnumExpr.i3">EnumExpr</A>, <A HREF="IntegerExpr.i3">IntegerExpr</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;

TYPE
  P = ExprRep.Tab BRANDED &quot;RangeExpr.P&quot; OBJECT
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := ExprRep.EqCheckAB;
        getBounds    := Bounder;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := IsZeroes;
	genFPLiteral := GenFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (a, b: Expr.T): Expr.T =
  VAR p := NEW (P);
  BEGIN
    ExprRep.Init (p);
    p.a    := a;
    p.b    := b;
    RETURN p;
  END New;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (e: Expr.T;  VAR min, max: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; min := p.a;  max := p.b;  RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Split;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (p: P): Type.T =
  BEGIN
    RETURN Type.Base (Expr.TypeOf (p.a));
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR ta, tb: Type.T;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    Expr.TypeCheck (p.b, cs);
    ta := Type.Base (Expr.TypeOf (p.a));
    tb := Type.Base (Expr.TypeOf (p.b));
    IF (ta = Int.T) AND (tb = Int.T) THEN (* ok *)
    ELSIF EnumType.Is (ta) AND Type.IsEqual (ta, tb, NIL) THEN (* ok *)
    ELSE  Error.Msg (&quot;incompatible types for \'..\'&quot;);
    END;
    p.type := ta;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  BEGIN
    Expr.Prep (p.a);
    Expr.Prep (p.b);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
    Error.Msg (&quot;INTERNAL ERROR: cannot compile a range expression&quot;);
    &lt;* ASSERT FALSE *&gt;
  END Compile;

PROCEDURE <A NAME="Bounder"><procedure>Bounder</procedure></A> (p: P;  VAR min, max: Target.Int) =
  VAR e: Expr.T;  i: Target.Int;  t: Type.T;
  BEGIN
    EVAL Type.GetBounds (p.type, min, max);
    e := Expr.ConstValue (p.a);
    IF (e = NIL) THEN (* can't improve lower bound *)
    ELSIF IntegerExpr.Split (e, i) THEN  min := i;
    ELSIF EnumExpr.Split (e, i, t) THEN  min := i;
    END;
    e := Expr.ConstValue (p.a);
    IF (e = NIL) THEN (* can't improve upper bound *)
    ELSIF IntegerExpr.Split (e, i) THEN  max := i;
    ELSIF EnumExpr.Split (e, i, t) THEN  max := i;
    END;
  END Bounder;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e1, e2: Expr.T;
  BEGIN
    e1 := Expr.ConstValue (p.a);
    IF (e1 = NIL) THEN RETURN NIL END;
    e2 := Expr.ConstValue (p.b);
    IF (e2 = NIL) THEN RETURN NIL END;
    IF (e1 = p.a) AND (e2 = p.b)
      THEN RETURN p;
      ELSE RETURN New (e1, e2);
    END;
  END Fold;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  BEGIN
    M3Buf.PutText (buf, &quot;RANGE&lt;&quot;);
    Expr.GenFPLiteral (p.a, buf);
    M3Buf.PutChar (buf, ',');
    Expr.GenFPLiteral (p.b, buf);
    M3Buf.PutChar (buf, '&gt;');
  END GenFPLiteral;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN Expr.IsZeroes (p.a) AND Expr.IsZeroes (p.b);
  END IsZeroes;

BEGIN
END RangeExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
