<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/RecordExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/RecordExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: RecordExpr.m3                                         

<P><PRE>MODULE <module><implements><A HREF="RecordExpr.i3">RecordExpr</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../types/RecordType.i3">RecordType</A>, <A HREF="../values/Module.i3">Module</A>;
IMPORT <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/Field.i3">Field</A>, <A HREF="KeywordExpr.i3">KeywordExpr</A>, <A HREF="RangeExpr.i3">RangeExpr</A>, <A HREF="../stmts/AssignStmt.i3">AssignStmt</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;

TYPE
  Info = RECORD
    field : Value.T;
    type  : Type.T;
    val   : Expr.T;
    name  : M3ID.T;
    done  : BOOLEAN;
  END;

TYPE
  P = Expr.T OBJECT
        tipe       : Type.T;
        args       : Expr.List;
        map        : REF ARRAY OF Info;
        tmp        : CG.Var;
        tmp_cnt    : INTEGER;
        tmp_offset : INTEGER;
        folded     : BOOLEAN;
        is_const   : BOOLEAN;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := PrepLV;
        compile      := CompileLV;
        prepLV       := PrepLV;
        compileLV    := CompileLV;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := IsZeroes;
	genFPLiteral := GenFPLiteral;
	prepLiteral  := PrepLiteral;
	genLiteral   := GenLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (type: Type.T;  args: Expr.List): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.type       := type;
    p.tipe       := type;
    p.args       := args;
    p.map        := NIL;
    p.tmp        := NIL;
    p.tmp_cnt    := 0;
    p.tmp_offset := 0;
    p.folded     := FALSE;
    p.is_const   := FALSE;
    RETURN p;
  END New;

PROCEDURE <A NAME="Is"><procedure>Is</procedure></A> (e: Expr.T): BOOLEAN =
  BEGIN
    RETURN (TYPECODE (e) = TYPECODE (P));
  END Is;

PROCEDURE <A NAME="Qualify"><procedure>Qualify</procedure></A> (e: Expr.T;  id: M3ID.T;  VAR result: Expr.T): BOOLEAN =
  VAR
    p      : P;
    val    : Value.T;
    field  : Field.Info;
    z      : Expr.T;
    key    : M3ID.T;
    value  : Expr.T;
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(x) =&gt; p := x;
    ELSE      RETURN FALSE;
    END;
    IF NOT RecordType.LookUp (p.tipe, id, val) THEN RETURN FALSE END;
    Field.Split (val, field);
    FOR i := 0 TO LAST (p.args^) DO
      z := p.args[i];
      IF (KeywordExpr.Split (z, key, value)) THEN
        IF (key = id) THEN result := value; RETURN TRUE END;
      ELSIF (i = field.index) THEN
        result := z;  RETURN TRUE;
      END;
    END;
    RETURN FALSE;
  END Qualify;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR
    n        : INTEGER;
    key      : M3ID.T;
    value, e : Expr.T;
    posOK    : BOOLEAN;
    offset   : INTEGER;
    dfault   : Expr.T;
    fields   : Value.T;
    v        : Value.T;
    field    : Field.Info;
  BEGIN
    p.tipe := Type.Check (p.tipe);
    FOR i := 0 TO LAST (p.args^) DO Expr.TypeCheck (p.args[i], cs) END;
    p.type := p.tipe;
    IF NOT RecordType.Split (p.tipe, fields) THEN
      Error.Msg (&quot;record constructor must specify a record type&quot;);
      RETURN;
    END;

    (* count the fields *)
    v := fields;  n := 0;
    WHILE (v # NIL) DO INC (n);  v := v.next END;

    (* build vectors to map the fields *)
    p.map := NEW (REF ARRAY OF Info, n);
    v := fields;  n := 0;
    WHILE (v # NIL) DO
      Field.Split (v, field);
      WITH z = p.map[n] DO
        z.field := v;
        z.name  := field.name;
        z.type  := field.type;
        z.val   := field.dfault;
        z.done  := FALSE;
      END;
      v := v.next;
      INC (n);
    END;
    posOK := TRUE;
    EVAL Fold (p);  (* make sure that the everything that can be folded is *)

    FOR i := 0 TO LAST (p.args^) DO
      e := p.args[i];
      IF RangeExpr.Split (e, value, dfault) THEN
        Error.Msg (&quot;range expressions not allowed in record constructors&quot;);
      END;

      IF KeywordExpr.Split (e, key, value) THEN
        posOK := FALSE;
        offset := 0;
        e := value;
        LOOP
          IF (offset &gt;= n) THEN
            Error.ID (key, &quot;unknown field&quot;);
            offset := i;
            EXIT;
          END;
          IF (p.map[offset].name = key) THEN EXIT END;
          INC (offset);
        END;
      ELSE (* positional parameter *)
        IF (NOT posOK) THEN
          Error.Msg (&quot;positional values must precede keyword values&quot;);
        END;
        IF (i &gt;= n)
	  THEN  Error.Msg (&quot;too many values&quot;);  offset := n - 1;
          ELSE  offset := i;
        END;
      END;

      IF (0 &lt;= offset) AND (offset &lt; n) THEN
        WITH z = p.map[offset] DO
          IF (z.done) THEN Error.ID (z.name, &quot;field already specified&quot;); END;
          z.done := TRUE;
          IF NOT Type.IsAssignable (z.type, Expr.TypeOf (e)) THEN
            Error.ID (z.name, &quot;expression is not assignable to field&quot;);
          ELSE
            AssignStmt.Check (z.type, e, cs);
            z.val := e;
          END;
        END;
      ELSE
        (* some other error, so don't even try *)
      END;
    END;

    FOR i := 0 TO n - 1 DO
      WITH z = p.map[i] DO
        IF (NOT z.done) AND (z.val = NIL) THEN
          Error.ID (z.name, &quot;no value specified for field&quot;);
        END;
      END;
    END;
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  VAR b: P;
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; b := p;
    ELSE      RETURN FALSE;
    END;
    IF (NOT Type.IsEqual (a.tipe, b.tipe, NIL))
      OR ((a.args = NIL) # (b.args = NIL))
      OR ((a.args # NIL) AND (NUMBER (a.args^) # NUMBER (b.args^))) THEN
      RETURN FALSE;
    END;
    FOR i := 0 TO LAST (a.args^) DO
      IF NOT Expr.IsEqual (a.args[i], b.args[i]) THEN RETURN FALSE END;
    END;
    RETURN TRUE;
  END EqCheck;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
    (* yep, all records get memory addresses *)
  END NeedsAddress;

PROCEDURE <A NAME="PrepLV"><procedure>PrepLV</procedure></A> (p: P) =
  VAR
    info: Type.Info;
    field: Field.Info;
  BEGIN
    IF (Fold (p) # NIL) THEN RETURN END;

    INC (p.tmp_cnt);
    IF (p.tmp # NIL) AND (p.tmp_cnt &gt; 1) THEN RETURN END;
    EVAL Type.CheckInfo (p.type, info);

    p.tmp := CG.Declare_temp (info.size, info.alignment,
                              CG.Type.Struct, in_memory := TRUE);

    FOR i := 0 TO LAST (p.map^) DO
      WITH z = p.map[i] DO
        Expr.Prep (z.val);
        Field.Split (z.field, field);
        CG.Load_addr_of (p.tmp, field.offset, info.alignment);
        AssignStmt.Emit (field.type, z.val);
      END;
    END;
  END PrepLV;

PROCEDURE <A NAME="CompileLV"><procedure>CompileLV</procedure></A> (p: P) =
  VAR info: Type.Info;  offset: INTEGER;
  BEGIN
    EVAL Type.CheckInfo (p.type, info);
    IF (p.is_const) THEN
      offset := Module.Allocate (info.size, info.alignment, &quot;*record*&quot;);
      PrepLiteral (p, p.tipe);
      GenLiteral (p, offset, p.tipe);
      CG.Load_addr_of (Module.GlobalData (NIL), offset, info.alignment);
    ELSE
      DEC (p.tmp_cnt);
      IF (p.tmp_cnt &lt;= 0) THEN
        CG.Load_addr_of_temp (p.tmp, 0, info.alignment);
        p.tmp := NIL;
      ELSE
        CG.Load_addr_of (p.tmp, 0, info.alignment);
      END;
    END;
  END CompileLV;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (p: P): Expr.T =
  VAR e: Expr.T;
  BEGIN
    IF (NOT p.folded) THEN
      p.folded   := TRUE;
      p.is_const := TRUE;
      FOR i := 0 TO LAST (p.args^) DO
        e := Expr.ConstValue (p.args[i]);
        IF (e = NIL) THEN p.is_const := FALSE; ELSE p.args[i] := e; END;
      END;
    END;
    IF p.is_const
      THEN RETURN p;
      ELSE RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (p: P): BOOLEAN =
  BEGIN
    &lt;* ASSERT p.map # NIL *&gt; (* must already be checked *)
    FOR i := 0 TO LAST (p.map^) DO
      IF NOT Expr.IsZeroes (p.map[i].val) THEN RETURN FALSE END;
    END;
    RETURN TRUE;
  END IsZeroes;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  BEGIN
    M3Buf.PutText (buf, &quot;RECORD&lt;&quot;);
    FOR i := 0 TO LAST (p.map^) DO
      IF (i &gt; 0) THEN M3Buf.PutChar (buf, ',') END;
      Expr.GenFPLiteral (p.map[i].val, buf);
    END;
    M3Buf.PutChar (buf, '&gt;');
  END GenFPLiteral;

PROCEDURE <A NAME="PrepLiteral"><procedure>PrepLiteral</procedure></A> (p: P;   &lt;*UNUSED*&gt; type: Type.T) =
  VAR e: Expr.T;  field: Field.Info;
  BEGIN
    &lt;* ASSERT p.map # NIL *&gt; (* must already be checked *)
    FOR i := 0 TO LAST (p.map^) DO
      WITH z = p.map[i] DO
        e := Expr.ConstValue (z.val);  &lt;* ASSERT e # NIL *&gt;
        IF NOT Expr.IsZeroes (e) THEN
          Field.Split (z.field, field);
          Expr.PrepLiteral (e, field.type);
        END;
      END;
    END;
  END PrepLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (p: P;  offset: INTEGER;  &lt;*UNUSED*&gt; type: Type.T) =
  VAR e: Expr.T;  field: Field.Info;
  BEGIN
    &lt;* ASSERT p.map # NIL *&gt; (* must already be checked *)
    FOR i := 0 TO LAST (p.map^) DO
      WITH z = p.map[i] DO
        e := Expr.ConstValue (z.val);  &lt;* ASSERT e # NIL *&gt;
        IF NOT Expr.IsZeroes (e) THEN
          Field.Split (z.field, field);
          Expr.GenLiteral (e, offset + field.offset, field.type);
        END;
      END;
    END;
  END GenLiteral;

BEGIN
END RecordExpr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
