<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/ReelExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/ReelExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ReelExpr.m3                                           

<P><PRE>MODULE <module><implements><A HREF="ReelExpr.i3">ReelExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TFloat.i3">TFloat</A>;
IMPORT <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../builtinTypes/Reel.i3">Reel</A>, <A HREF="../builtinTypes/LReel.i3">LReel</A>, <A HREF="../builtinTypes/EReel.i3">EReel</A>, <A HREF="IntegerExpr.i3">IntegerExpr</A>;

TYPE
  P = Expr.T OBJECT
        pre : Precision;
        val : Target.Float;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := ExprRep.NoCheck;
        need_addr    := ExprRep.NotAddressable;
        prep         := ExprRep.NoPrep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := ExprRep.Self;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := IsZeroes;
	genFPLiteral := GenFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := GenLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (READONLY value: Target.Float;  pre: Precision): Expr.T =
  VAR p := NEW (P);
  BEGIN
    ExprRep.Init (p);
    p.pre     := pre;
    p.val     := value;
    p.checked := TRUE;
    CASE pre OF
    | Precision.Short    =&gt; p.type := Reel.T;
    | Precision.Long     =&gt; p.type := LReel.T;
    | Precision.Extended =&gt; p.type := EReel.T;
    END;
    RETURN p;
  END New;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN (a.pre = b.pre) AND TFloat.EQ (a.val, b.val);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    CG.Load_float (p.val);
  END Compile;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A> (a, b: Expr.T;  VAR sign: INTEGER): BOOLEAN =
  VAR x, y: Target.Float;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF    TFloat.LT (x, y) THEN sign := -1
    ELSIF TFloat.LT (y, x) THEN sign := +1
    ELSE                          sign :=  0
    END;
    RETURN TRUE;
  END Compare;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Float;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF NOT TFloat.Add (x, y, res) THEN RETURN FALSE END;
    c := New (res, res.pre);
    RETURN TRUE;
  END Add;

PROCEDURE <A NAME="Subtract"><procedure>Subtract</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Float;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF NOT TFloat.Subtract (x, y, res) THEN RETURN FALSE END;
    c := New (res, res.pre);
    RETURN TRUE;
  END Subtract;

PROCEDURE <A NAME="Multiply"><procedure>Multiply</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Float;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF NOT TFloat.Multiply (x, y, res) THEN RETURN FALSE END;
    c := New (res, res.pre);
    RETURN TRUE;
  END Multiply;

PROCEDURE <A NAME="Divide"><procedure>Divide</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Float;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF NOT TFloat.Divide (x, y, res) THEN RETURN FALSE END;
    c := New (res, res.pre);
    RETURN TRUE;
  END Divide;

PROCEDURE <A NAME="Mod"><procedure>Mod</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y, res: Target.Float;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF NOT TFloat.Mod (x, y, res) THEN RETURN FALSE END;
    c := New (res, res.pre);
    RETURN TRUE;
  END Mod;

PROCEDURE <A NAME="Min"><procedure>Min</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y: Target.Float;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF TFloat.LT (x, y)
      THEN c := a;
      ELSE c := b;
    END;
    RETURN TRUE;
  END Min;

PROCEDURE <A NAME="Max"><procedure>Max</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, y: Target.Float;
  BEGIN
    IF NOT SplitPair (a, b, x, y) THEN RETURN FALSE END;
    IF TFloat.LT (x, y)
      THEN c := b;
      ELSE c := a;
    END;
    RETURN TRUE;
  END Max;

PROCEDURE <A NAME="Negate"><procedure>Negate</procedure></A> (a: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x, zero, res: Target.Float;
  BEGIN
    IF NOT Split (a, x) THEN RETURN FALSE END;
    IF    (x.pre = Precision.Short) THEN zero := TFloat.ZeroR;
    ELSIF (x.pre = Precision.Long) THEN  zero := TFloat.ZeroL;
    ELSE                                 zero := TFloat.ZeroX;
    END;
    IF NOT TFloat.Subtract (zero, x, res) THEN RETURN FALSE END;
    c := New (res, res.pre);
    RETURN TRUE;
  END Negate;

PROCEDURE <A NAME="Abs"><procedure>Abs</procedure></A> (a: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR  x, zero, res: Target.Float;
  BEGIN
    IF NOT Split (a, x) THEN RETURN FALSE END;
    IF    (x.pre = Precision.Short) THEN zero := TFloat.ZeroR;
    ELSIF (x.pre = Precision.Long) THEN  zero := TFloat.ZeroL;
    ELSE                                 zero := TFloat.ZeroX;
    END;
    IF NOT TFloat.LT (x, zero) THEN  c := a; RETURN TRUE  END;
    IF NOT TFloat.Subtract (zero, x, res) THEN RETURN FALSE END;
    c := New (res, res.pre);
    RETURN TRUE;
  END Abs;

PROCEDURE <A NAME="Floor"><procedure>Floor</procedure></A> (a: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x: Target.Float;  res: Target.Int;
  BEGIN
    IF NOT Split (a, x) THEN RETURN FALSE END;
    IF NOT TFloat.Floor (x, res) THEN RETURN FALSE END;
    c := IntegerExpr.New (res);
    RETURN TRUE;
  END Floor;

PROCEDURE <A NAME="Ceiling"><procedure>Ceiling</procedure></A> (a: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x: Target.Float;  res: Target.Int;
  BEGIN
    IF NOT Split (a, x) THEN RETURN FALSE END;
    IF NOT TFloat.Ceiling (x, res) THEN RETURN FALSE END;
    c := IntegerExpr.New (res);
    RETURN TRUE;
  END Ceiling;

PROCEDURE <A NAME="Trunc"><procedure>Trunc</procedure></A> (a: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x: Target.Float;  res: Target.Int;
  BEGIN
    IF NOT Split (a, x) THEN RETURN FALSE END;
    IF NOT TFloat.Trunc (x, res) THEN RETURN FALSE END;
    c := IntegerExpr.New (res);
    RETURN TRUE;
  END Trunc;

PROCEDURE <A NAME="Round"><procedure>Round</procedure></A> (a: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR x: Target.Float;  res: Target.Int;
  BEGIN
    IF NOT Split (a, x) THEN RETURN FALSE END;
    IF NOT TFloat.Round (x, res) THEN RETURN FALSE END;
    c := IntegerExpr.New (res);
    RETURN TRUE;
  END Round;

PROCEDURE <A NAME="Float"><procedure>Float</procedure></A> (a: Expr.T;  t: Type.T;  VAR c: Expr.T): BOOLEAN =
  VAR i: Target.Int;  x, res: Target.Float;  new_pre: Precision;
  BEGIN
    t := Type.Base (t);
    IF    (t = Reel.T)  THEN new_pre := Precision.Short;
    ELSIF (t = LReel.T) THEN new_pre := Precision.Long;
    ELSIF (t = EReel.T) THEN new_pre := Precision.Extended;
    ELSE  RETURN FALSE;
    END;

    IF Split (a, x) THEN
      IF NOT TFloat.FloatF (x, new_pre, res) THEN RETURN FALSE END;
    ELSIF IntegerExpr.Split (a, i) THEN
      IF NOT TFloat.FloatI (i, new_pre, res) THEN RETURN FALSE END;
    ELSE
      RETURN FALSE;
    END;
    c := New (res, new_pre);
    RETURN TRUE;
  END Float;

PROCEDURE <A NAME="SplitPair"><procedure>SplitPair</procedure></A> (a, b: Expr.T;  VAR x, y: Target.Float): BOOLEAN =
  BEGIN
    IF NOT Split (a, x) THEN RETURN FALSE END;
    IF NOT Split (b, y) THEN RETURN FALSE END;
    IF (x.pre # y.pre) THEN RETURN FALSE END;
    RETURN TRUE;
  END SplitPair;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (e: Expr.T;  VAR x: Target.Float): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; x := p.val;  RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Split;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN TFloat.EQ (TFloat.ZeroR, p.val)
        OR TFloat.EQ (TFloat.ZeroL, p.val)
        OR TFloat.EQ (TFloat.ZeroX, p.val);
  END IsZeroes;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  CONST mark = ARRAY Precision OF TEXT { &quot;REAL&lt;&quot;, &quot;LREAL&lt;&quot;, &quot;EREAL&lt;&quot; };
  BEGIN
    M3Buf.PutText  (buf, mark [p.pre]);
    M3Buf.PutFloat (buf, p.val);
    M3Buf.PutChar  (buf, '&gt;');
  END GenFPLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (p: P;  offset: INTEGER;  &lt;*UNUSED*&gt;type: Type.T) =
  BEGIN
    CG.Init_float (offset, p.val);
  END GenLiteral;

BEGIN
END ReelExpr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
