<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/SetExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/SetExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: SetExpr.m3                                            

<P><PRE>MODULE <module><implements><A HREF="SetExpr.i3">SetExpr</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="IntegerExpr.i3">IntegerExpr</A>, <A HREF="EnumExpr.i3">EnumExpr</A>;
IMPORT <A HREF="RangeExpr.i3">RangeExpr</A>, <A HREF="KeywordExpr.i3">KeywordExpr</A>, <A HREF="../types/SetType.i3">SetType</A>, <A HREF="../stmts/AssignStmt.i3">AssignStmt</A>, <A HREF="CheckExpr.i3">CheckExpr</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../../../m3middle/src/TWord.i3">TWord</A>, <A HREF="../builtinTypes/Bool.i3">Bool</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../values/Module.i3">Module</A>;

TYPE
  Node = REF RECORD
    next : Node;
    min  : INTEGER;
    max  : INTEGER;
  END;

TYPE
  P = Expr.T OBJECT
        tipe    : Type.T;
        args    : Expr.List;
        mapped  : BOOLEAN;
        tree    : Node;
        others  : Expr.List;
        nOthers : INTEGER;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := Prep;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := Fold;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
        isZeroes     := IsZeroes;
        genFPLiteral := GenFPLiteral;
        prepLiteral  := ExprRep.NoPrepLiteral;
        genLiteral   := GenLiteral;
        note_write   := ExprRep.NotWritable;
      END;

TYPE
  VisitState = RECORD
    a, b       : Node;    (* private to the iterator *)
    amin, amax : INTEGER; (* &quot; *)
    bmin, bmax : INTEGER; (* &quot; *)
    min, max   : INTEGER; (* resulting range *)
    inA, inB   : BOOLEAN; (* location of resulting range *)
  END;

VAR (*CONST*)
  Grain : CARDINAL;  (* allocation grain for set values *)
  full  : Target.Int;
  left  : ARRAY [0..64] OF Target.Int;
  right : ARRAY [0..64] OF Target.Int;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (type: Type.T;  args: Expr.List): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.type    := type;
    p.tipe    := type;
    p.args    := args;
    p.mapped  := FALSE;
    p.tree    := NIL;
    p.others  := NIL;
    p.nOthers := -1;
    RETURN p;
  END New;

PROCEDURE <A NAME="NewFromTree"><procedure>NewFromTree</procedure></A> (p: P;  node: Node): Expr.T =
  VAR c: P;
  BEGIN
    c := NEW (P);
    c.origin  := p.origin;
    c.type    := p.type;
    c.checked := p.checked;
    c.tipe    := p.tipe;
    c.args    := p.args;
    c.mapped  := TRUE;
    c.tree    := NormalizeTree (node);
    c.others  := NIL;
    p.nOthers := -1;
    RETURN c;
  END NewFromTree;

PROCEDURE <A NAME="Is"><procedure>Is</procedure></A> (e: Expr.T): BOOLEAN =
  BEGIN
    RETURN (TYPECODE (e) = TYPECODE (P));
  END Is;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A> (a, b: Expr.T;  VAR sign: INTEGER): BOOLEAN =
  VAR p, q: P;  le, eq, ge: BOOLEAN := TRUE;  s: VisitState;
  BEGIN
    IF NOT CheckPair (a, b, p, q) THEN RETURN FALSE END;
    SetupVisit (s, p.tree, q.tree);
    WHILE Visit (s) DO
      IF (s.min &lt;= s.max) THEN
        (* we got a non-empty range *)
        IF (s.inA) AND (NOT s.inB) THEN
          eq := FALSE;  le := FALSE;
        ELSIF (s.inB) AND (NOT s.inA) THEN
          eq := FALSE;  ge := FALSE;
        END;
      END;
    END;
    IF    (le AND NOT eq) THEN sign :=  -1
    ELSIF (ge AND NOT eq) THEN sign := 1
    ELSIF (eq)            THEN sign := 0
    ELSE                       sign :=  -99;
    END;
    RETURN TRUE;
  END Compare;

PROCEDURE <A NAME="Union"><procedure>Union</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR p, q: P;  n, x: Node;
  BEGIN
    IF NOT CheckPair (a, b, p, q) THEN RETURN FALSE END;
    n := NIL;
    x := p.tree;
    WHILE (x # NIL) DO
      n := AddNode (n, x.min, x.max);
      x := x.next;
    END;
    x := q.tree;
    WHILE (x # NIL) DO
      n := AddNode (n, x.min, x.max);
      x := x.next;
    END;
    c := NewFromTree (p, n);
    RETURN TRUE;
  END Union;

PROCEDURE <A NAME="Intersection"><procedure>Intersection</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR p, q: P;  n: Node;  s: VisitState;
  BEGIN
    IF NOT CheckPair (a, b, p, q) THEN RETURN FALSE END;
    n := NIL;
    SetupVisit (s, p.tree, q.tree);
    WHILE Visit (s) DO
      IF (s.min &lt;= s.max) AND (s.inA) AND (s.inB) THEN
        n := AddNode (n, s.min, s.max);
      END;
    END;
    c := NewFromTree (p, n);
    RETURN TRUE;
  END Intersection;

PROCEDURE <A NAME="Difference"><procedure>Difference</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR p, q: P;  n: Node;  s: VisitState;
  BEGIN
    IF NOT CheckPair (a, b, p, q) THEN RETURN FALSE END;
    n := NIL;
    SetupVisit (s, p.tree, q.tree);
    WHILE Visit (s) DO
      IF (s.min &lt;= s.max) AND (s.inA) AND (NOT s.inB) THEN
        n := AddNode (n, s.min, s.max);
      END;
    END;
    c := NewFromTree (p, n);
    RETURN TRUE;
  END Difference;

PROCEDURE <A NAME="SymDifference"><procedure>SymDifference</procedure></A> (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR p, q: P;  n: Node;  s: VisitState;
  BEGIN
    IF NOT CheckPair (a, b, p, q) THEN RETURN FALSE END;
    n := NIL;
    SetupVisit (s, p.tree, q.tree);
    WHILE Visit (s) DO
      IF (s.min &lt;= s.max) AND (s.inA # s.inB) THEN
        n := AddNode (n, s.min, s.max);
      END;
    END;
    c := NewFromTree (p, n);
    RETURN TRUE;
  END SymDifference;

PROCEDURE <A NAME="Include"><procedure>Include</procedure></A> (set, elt: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR p: P;  i: INTEGER;  n, x: Node;
  BEGIN
    IF NOT ConstElt (elt, i) THEN RETURN FALSE END;
    IF NOT BuildMap (set, p) THEN RETURN FALSE END;
    n := AddNode (NIL, i, i);
    x := p.tree;
    WHILE (x # NIL) DO
      n := AddNode (n, x.min, x.max);
      x := x.next;
    END;
    c := NewFromTree (p, n);
    RETURN TRUE;
  END Include;

PROCEDURE <A NAME="Exclude"><procedure>Exclude</procedure></A> (set, elt: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR p: P;  i: INTEGER;  n, x: Node;
  BEGIN
    IF NOT ConstElt (elt, i) THEN RETURN FALSE END;
    IF NOT BuildMap (set, p) THEN RETURN FALSE END;
    n := NIL;
    x := p.tree;
    WHILE (x # NIL) DO
      IF (x.min &lt;= i) AND (i &lt;= x.max) THEN
        n := AddNode (n, x.min, i - 1);
        n := AddNode (n, i + 1, x.max);
      ELSE
        n := AddNode (n, x.min, x.max);
      END;
      x := x.next;
    END;
    c := NewFromTree (p, n);
    RETURN TRUE;
  END Exclude;

PROCEDURE <A NAME="Member"><procedure>Member</procedure></A> (set, elt: Expr.T;  VAR c: Expr.T): BOOLEAN =
  VAR p: P;  i: INTEGER;  x: Node;
  BEGIN
    IF NOT ConstElt (elt, i) THEN RETURN FALSE END;
    IF NOT BuildMap (set, p) THEN RETURN FALSE END;
    x := p.tree;
    WHILE (x # NIL) DO
      IF (x.min &lt;= i) AND (i &lt;= x.max) THEN
        c := Bool.Map [TRUE];
        RETURN TRUE;
      END;
      x := x.next;
    END;
    c := Bool.Map [FALSE];
    RETURN TRUE;
  END Member;

PROCEDURE <A NAME="ConstElt"><procedure>ConstElt</procedure></A> (elt: Expr.T;  VAR i: INTEGER): BOOLEAN =
  VAR t: Type.T;  int: Target.Int;
  BEGIN
    elt := Expr.ConstValue (elt);
    IF (elt = NIL) THEN RETURN FALSE END;
    RETURN (IntegerExpr.Split (elt, int) OR EnumExpr.Split (elt, int, t))
       AND TInt.ToInt (int, i);
  END ConstElt;

PROCEDURE <A NAME="CheckPair"><procedure>CheckPair</procedure></A> (a, b: Expr.T;  VAR p, q: P): BOOLEAN =
  BEGIN
    RETURN BuildMap (a, p)
       AND BuildMap (b, q)
       AND Type.IsEqual (p.tipe, q.tipe, NIL);
  END CheckPair;

PROCEDURE <A NAME="SetupVisit"><procedure>SetupVisit</procedure></A> (VAR s: VisitState;  x, y: Node) =
  BEGIN
    s.a := x;
    s.b := y;
    IF (x # NIL) THEN s.amin := x.min;  s.amax := x.max END;
    IF (y # NIL) THEN s.bmin := y.min;  s.bmax := y.max END;
  END SetupVisit;

PROCEDURE <A NAME="Visit"><procedure>Visit</procedure></A> (VAR s: VisitState): BOOLEAN =
  BEGIN
    IF (s.a = NIL) AND (s.b = NIL) THEN
      (* both lists are empty *)
      RETURN FALSE;
    ELSIF (s.a = NIL) THEN
      (* A list is empty *)
      s.min := s.bmin;  s.max := s.bmax;  s.inA := FALSE;  s.inB := TRUE;
      s.bmin := s.bmax + 1;
    ELSIF (s.b = NIL) THEN
      (* B list is empty *)
      s.min := s.amin;  s.max := s.amax;  s.inA := TRUE;  s.inB := FALSE;
      s.amin := s.amax + 1;
    ELSE (* both lists are non-empty *)
      IF (s.amin &lt; s.bmin) THEN
        s.min := s.amin;    s.inA := TRUE;  s.inB := FALSE;
        IF (s.amax &lt; s.bmin) THEN
          s.max := s.amax; s.amin := s.amax + 1;
        ELSE (* s.amax &gt;= s.bmin *)
          s.max := s.bmin - 1;
          s.amin := s.bmin;  s.bmin := s.amin;
        END;
      ELSIF (s.amin = s.bmin) THEN
        s.min := s.amin;  s.inA := TRUE;  s.inB := TRUE;
        IF (s.bmax &lt; s.amax) THEN
          s.max := s.bmax;  s.amin := s.bmax + 1;
        ELSE (* s.amax &lt;= s.bmax *)
          s.max := s.amax;  s.amin := s.amax + 1;
        END;
        s.bmin := s.amin;
      ELSE (* s.amin &gt; s.bmin *)
        s.min := s.bmin;  s.inA := FALSE;   s.inB := TRUE;
        IF (s.bmax &lt; s.amin) THEN
          s.max := s.bmax;  s.bmin := s.bmax + 1;
        ELSE (* s.amin &lt;= s.bmax *)
          s.max := s.amin - 1;
          s.amin := s.amin;  s.bmin := s.amin;
        END;
      END;
    END;
    IF (s.amax &lt; s.amin) AND (s.a # NIL) THEN
      s.a := s.a.next;
      IF (s.a # NIL) THEN s.amin := s.a.min;  s.amax := s.a.max  END;
    END;
    IF (s.bmax &lt; s.bmin) AND (s.b # NIL) THEN
      s.b := s.b.next;
      IF (s.b # NIL) THEN s.bmin := s.b.min;  s.bmax := s.b.max  END;
    END;
    RETURN TRUE;
  END Visit;

PROCEDURE <A NAME="BuildMap"><procedure>BuildMap</procedure></A> (e: Expr.T;  VAR p: P): BOOLEAN =
  VAR
    t, range: Type.T;
    elt, eMin, eMax: Expr.T;
    from, to, min, max: Target.Int;
    iFrom, iTo: INTEGER;
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(x) =&gt; p := x;
    ELSE      RETURN FALSE;
    END;
    IF (p.mapped) THEN RETURN (p.others = NIL) END;
    p.mapped := TRUE;
    IF NOT SetType.Split (p.tipe, range) THEN RETURN FALSE END;
    EVAL Type.GetBounds (range, min, max);
    (* IF TInt.LT (max, min) THEN RETURN FALSE END; ?? -- 8/2/93 WKK -- *)
    FOR i := 0 TO LAST (p.args^) DO
      elt := Expr.ConstValue (p.args[i]);
      IF (elt = NIL) THEN
        (* not a constant *)
        AddOther (p, p.args[i]);
      ELSIF IntegerExpr.Split (elt, from) OR EnumExpr.Split (elt, from, t) THEN
        IF TInt.LT (from, min) OR TInt.LT (max, from) THEN
          Error.Warn (2, &quot;set element out of range&quot;);
          AddOther (p, elt);
        ELSIF TInt.ToInt (from, iFrom) THEN
          p.tree := AddNode (p.tree, iFrom, iFrom);
        ELSE (* treat big values as non-constants *)
          AddOther (p, elt);
        END;
      ELSIF (RangeExpr.Split (elt, eMin, eMax)) THEN
        eMin := Expr.ConstValue (eMin);
        eMax := Expr.ConstValue (eMax);
        IF (eMin # NIL) AND (eMax # NIL)
          AND (IntegerExpr.Split (eMin,from) OR EnumExpr.Split (eMin, from, t))
          AND (IntegerExpr.Split (eMax, to)  OR EnumExpr.Split (eMax, to, t))
          THEN
          IF TInt.LT (from, min) OR TInt.LT (max, from) THEN
            Error.Warn (2, &quot;set element out of range&quot;);
            AddOther (p, elt);
          ELSIF TInt.ToInt (from, iFrom) AND TInt.ToInt (to, iTo) THEN
            p.tree := AddNode (p.tree, iFrom, iTo);
          ELSE (* since the values are so big, treat them as non-constants *)
            AddOther (p, elt);
          END;
        ELSE (* not a constant range *)
          AddOther (p, elt);
        END;
      ELSE
        Error.Warn (2, &quot;set element is not an ordinal&quot;);
        AddOther (p, elt);
      END;
    END;
    p.tree := NormalizeTree (p.tree);
    RETURN (p.others = NIL);
  END BuildMap;

PROCEDURE <A NAME="AddOther"><procedure>AddOther</procedure></A> (p: P;  elt: Expr.T) =
  BEGIN
    IF (p.others = NIL) THEN
      p.others := NEW (Expr.List, NUMBER (p.args^));
      p.nOthers := 0;
    END;
    p.others[p.nOthers] := elt;
    INC (p.nOthers);
  END AddOther;

PROCEDURE <A NAME="AddNode"><procedure>AddNode</procedure></A> (n: Node;  min, max: INTEGER): Node =
  VAR x: Node;
  BEGIN
    IF (max &lt; min) THEN RETURN n END;
    x := n;
    LOOP
      IF (x = NIL) THEN
        x := NEW (Node);  x.next := n;  x.min := min;  x.max := max;
        RETURN x;
      END;
      IF ((x.min &lt;= min) AND (min &lt;= x.max))
      OR ((x.min &lt;= max) AND (max &lt;= x.min)) THEN
        IF (min &lt; x.min) THEN x.min := min END;
        IF (x.max &lt; max) THEN x.max := max END;
        RETURN n;
      END;
      x := x.next;
    END;
  END AddNode;

PROCEDURE <A NAME="NormalizeTree"><procedure>NormalizeTree</procedure></A> (n: Node): Node =
  VAR x1, x2, x3: Node;  done: BOOLEAN;
  BEGIN
    IF (n = NIL) THEN RETURN NIL END;

    (* destructively sort the input list *)
    done := FALSE;
    WHILE (NOT done) DO
      done := TRUE;
      x1 := n.next;  x2 := n;  x3 := NIL;
      WHILE (x1 # NIL) DO
        IF (x1.min &lt; x2.min) THEN
          (* swap x1 and x2 *)
          x2.next := x1.next;
          x1.next := x2;
          IF (x3 = NIL) THEN n := x1 ELSE x3.next := x1 END;
          x2 := x1;
          x1 := x2.next;
          done := FALSE;
        END;
        x3 := x2;  x2 := x1;  x1 := x1.next;
      END;
    END;

    (* merge adjacent nodes *)
    x1 := n.next;  x2 := n;
    WHILE (x1 # NIL) DO
      IF (x2.min &lt;= x1.min) AND (x1.min &lt;= x2.max) THEN
        IF (x2.max &lt; x1.max) THEN x2.max := x1.max END;
        x1 := x1.next;
        x2.next := x1;
      ELSE
        x2 := x1;  x1 := x1.next;
      END;
    END;

    RETURN n;
  END NormalizeTree;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  VAR
    t, range   : Type.T;
    minT, maxT : Target.Int;
    minE, maxE : Target.Int;
    min, max   : Expr.T;
    e, value   : Expr.T;
    key        : M3ID.T;
  BEGIN
    p.tipe := Type.Check (p.tipe);
    FOR i := 0 TO LAST (p.args^) DO Expr.TypeCheck (p.args[i], cs) END;
    p.type := p.tipe;
    IF NOT SetType.Split (p.tipe, range) THEN
      Error.Msg (&quot;set constructor must specify a set type&quot;);
      RETURN;
    END;
    EVAL Type.GetBounds (range, minT, maxT);
    FOR i := 0 TO LAST (p.args^) DO
      e := p.args[i];
      t := Expr.TypeOf (e);

      IF KeywordExpr.Split (e, key, value) THEN
        Error.Msg (&quot;keyword values not allowed in set constructors&quot;);
        e := value;
        p.args[i] := value;
      END;

      IF RangeExpr.Split (e, min, max) THEN
        AssignStmt.Check (range, min, cs);
        AssignStmt.Check (range, max, cs);
        min := Expr.ConstValue (min);
        max := Expr.ConstValue (max);
      ELSE (* single value *)
        AssignStmt.Check (range, e, cs);
        min := Expr.ConstValue (e);
        max := min;
      END;

      IF (min # NIL) AND (max # NIL)
        AND (IntegerExpr.Split (min, minE) OR EnumExpr.Split (min, minE, t))
        AND (IntegerExpr.Split (max, maxE) OR EnumExpr.Split (max, maxE, t))
        THEN
        IF TInt.LT (minE, minT) OR TInt.LT (maxT, maxE) THEN
          Error.Msg (&quot;illegal set value&quot;);
        END;
      END;

    END;
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  VAR b: P;  ax, bx: Expr.T;
  BEGIN
    TYPECASE e OF
    | NULL  =&gt; RETURN FALSE;
    | P(bb) =&gt; b := bb;
    ELSE       RETURN FALSE;
    END;

    IF (NOT Type.IsEqual (a.tipe, b.tipe, NIL))
      OR ((a.args = NIL) # (b.args = NIL))
      OR ((a.args # NIL) AND (NUMBER (a.args^) # NUMBER (b.args^))) THEN
      RETURN FALSE;
    END;

    FOR i := 0 TO LAST (a.args^) DO
      ax := Expr.ConstValue (a.args[i]);
      IF (ax = NIL) THEN ax := a.args[i] END;
      bx := Expr.ConstValue (b.args[i]);
      IF (bx = NIL) THEN bx := b.args[i] END;
      IF NOT Expr.IsEqual (ax, bx) THEN RETURN FALSE END;
    END;

    RETURN TRUE;
  END EqCheck;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
    (* yep, all sets get memory addresses *)
  END NeedsAddress;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (p: P) =
  BEGIN
    EVAL BuildMap (p, p);  (* evaluate the constants *)
    (* prep the non-constant elements *)
    FOR i := 0 TO p.nOthers-1 DO
      Expr.Prep (p.others[i]);
    END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  VAR info: Type.Info;  offset: INTEGER;
  BEGIN
    EVAL Type.CheckInfo (p.tipe, info);
    IF (info.size &lt;= Target.Integer.size) THEN
      CompileSmall (p, info);
    ELSIF (p.nOthers &lt;= 0) THEN
      (* large, constant set *)
      offset := Module.Allocate (info.size, info.alignment, &quot;*set*&quot;);
      GenLiteral (p, offset, p.tipe);
      CG.Load_addr_of (Module.GlobalData (NIL), offset, info.alignment);
    ELSE
      CompileBig (p, info);
    END;
  END Compile;

PROCEDURE <A NAME="CompileBig"><procedure>CompileBig</procedure></A> (p: P;  VAR info: Type.Info) =
  VAR
    range        : Type.T;
    w1, w2       : INTEGER;
    b1, b2       : INTEGER;
    minT, maxT   : INTEGER;
    min_T, max_T : Target.Int;
    min, max     : Expr.T;
    e            : Expr.T;
    t1           : CG.Var;
    nWords       : INTEGER;
    curWord      : INTEGER;
    curMask      : Target.Int;
    n            : Node;
    b            : BOOLEAN;
    tmp          : Target.Int;

  BEGIN
    b := SetType.Split (p.tipe, range); &lt;* ASSERT b *&gt;
    EVAL Type.GetBounds (range, min_T, max_T);
    IF NOT TInt.ToInt (min_T, minT)
      OR NOT TInt.ToInt (max_T, maxT) THEN
      Error.Msg (&quot;set domain too large&quot;);
      minT := FIRST (INTEGER);
      maxT := LAST (INTEGER);
    END;

    nWords := info.size DIV Grain;
    t1 := CG.Declare_temp (nWords * Grain, Target.Integer.align,
                           CG.Type.Struct, in_memory := TRUE);

    (* generate the constant words *)
    n := p.tree;  curWord := 0;   curMask := TInt.Zero;
    WHILE (n # NIL) DO
      w1 := (n.min - minT) DIV Grain;
      b1 := (n.min - minT) MOD Grain;
      w2 := (n.max - minT) DIV Grain;
      b2 := (n.max - minT) MOD Grain;
      IF (w1 # curWord) THEN
        EmitAssign (t1, curWord, curMask);
        FOR i := curWord+1 TO w1-1 DO  EmitAssign (t1, i, TInt.Zero) END;
        curWord := w1;
        curMask := TInt.Zero;
      END;
      IF (w1 # w2) THEN
        TWord.Or (curMask, left [b1], tmp);
        EmitAssign (t1, w1, tmp);
        FOR i := w1 + 1 TO w2 - 1 DO  EmitAssign (t1, i, full)  END;
        curWord := w2;
        curMask := right [b2];
      ELSE (* x = y *)
        TWord.And (left [b1], right[b2], tmp);
        TWord.Or (curMask, tmp, curMask);
      END;
      n := n.next;
    END; (* while *)

    (* write the last mask *)
    EmitAssign (t1, curWord, curMask);

    (* write zeros for the remainder of the set *)
    FOR i := curWord+1 TO nWords-1 DO EmitAssign (t1, i, TInt.Zero) END;

    (* finally, add the non-constant elements *)
    FOR i := 0 TO p.nOthers-1 DO
      e := p.others[i];
      IF RangeExpr.Split (e, min, max) THEN
        CG.Load_addr_of (t1, 0, Target.Integer.align);
        CG.Force ();
        GenElement (min, min_T, max_T);
        GenElement (max, min_T, max_T);
        CG.Set_range (info.size);
      ELSE (* single value *)
        CG.Load_addr_of (t1, 0, Target.Integer.align);
        GenElement (e, min_T, max_T);
        CG.Set_singleton (info.size);
      END;
    END;

    CG.Load_addr_of_temp (t1, 0, Target.Integer.align);
  END CompileBig;

PROCEDURE <A NAME="EmitAssign"><procedure>EmitAssign</procedure></A> (set: CG.Var;  index: INTEGER;
                      READONLY value: Target.Int) =
  BEGIN
    CG.Load_integer (value);
    CG.Store_int (set, index * Grain);
    &lt;* ASSERT Grain = Target.Integer.size *&gt;
  END EmitAssign;

PROCEDURE <A NAME="GenElement"><procedure>GenElement</procedure></A> (e: Expr.T;  READONLY min, max: Target.Int) =
  BEGIN
    CheckExpr.Emit (e, min, max);
    IF NOT TInt.EQ (min, TInt.Zero) THEN
      CG.Load_integer (min);
      CG.Subtract (CG.Type.Int);
    END;
  END GenElement;

PROCEDURE <A NAME="CompileSmall"><procedure>CompileSmall</procedure></A> (p: P;  VAR info: Type.Info) =
  VAR
    range        : Type.T;
    b1, b2       : INTEGER;
    minT, maxT   : INTEGER;
    min_T, max_T : Target.Int;
    min, max     : Expr.T;
    e            : Expr.T;
    nWords       : INTEGER;
    curMask      : Target.Int;
    n            : Node;
    b            : BOOLEAN;
    tmp          : Target.Int;
  BEGIN
    Type.Compile (p.tipe);
    nWords  := info.size DIV Grain;
    &lt;*ASSERT info.size &lt;= Target.Integer.size *&gt;
    &lt;*ASSERT nWords &lt;= 1 *&gt;

    b := SetType.Split (p.tipe, range); &lt;* ASSERT b *&gt;
    EVAL Type.GetBounds (range, min_T, max_T);
    IF NOT TInt.ToInt (min_T, minT)
      OR NOT TInt.ToInt (max_T, maxT) THEN
      Error.Msg (&quot;set domain too large&quot;);
      minT := FIRST (INTEGER);
      maxT := LAST (INTEGER);
    END;

    (* generate the constant words *)
    n := p.tree;  curMask := TInt.Zero;
    WHILE (n # NIL) DO
      b1 := (n.min - minT);
      b2 := (n.max - minT);
      TWord.And (left [b1], right[b2], tmp);
      TWord.Or (curMask, tmp, curMask);
      n := n.next;
    END; (* while *)

    (* push the mask *)
    CG.Load_integer (curMask);

    (* finally, add the non-constant elements *)
    FOR i := 0 TO p.nOthers-1 DO
      e := p.others[i];
      IF RangeExpr.Split (e, min, max) THEN
        GenElement (min, min_T, max_T);
        GenElement (max, min_T, max_T);
        CG.Set_range (info.size);
      ELSE (* single value *)
        GenElement (e, min_T, max_T);
        CG.Set_singleton (info.size);
      END;
    END;
  END CompileSmall;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (e: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    IF BuildMap (e, p)
      THEN RETURN e;
      ELSE RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="IsZeroes"><procedure>IsZeroes</procedure></A> (p: P): BOOLEAN =
  BEGIN
    RETURN (p.args = NIL) OR (NUMBER (p.args^) &lt;= 0);
  END IsZeroes;

PROCEDURE <A NAME="GenFPLiteral"><procedure>GenFPLiteral</procedure></A> (p: P;  buf: M3Buf.T) =
  BEGIN
    M3Buf.PutText (buf, &quot;SET&lt;&quot;);
    FOR i := 0 TO LAST (p.args^) DO
      IF (i &gt; 0) THEN M3Buf.PutChar (buf, ',') END;
      Expr.GenFPLiteral (p.args[i], buf);
    END;
    M3Buf.PutChar (buf, '&gt;');
  END GenFPLiteral;

PROCEDURE <A NAME="GenLiteral"><procedure>GenLiteral</procedure></A> (p: P;  offset: INTEGER;  type: Type.T) =
  VAR
    range        : Type.T;
    min_T, max_T : Target.Int;
    minT, maxT   : INTEGER;
    w1, w2       : INTEGER;
    b1, b2       : INTEGER;
    curWord      : INTEGER;
    curMask      : Target.Int;
    n            : Node;
    b            : BOOLEAN;
    tmp          : Target.Int;
  BEGIN
    &lt;*ASSERT Type.IsEqual (type, p.tipe, NIL) *&gt;
    b := SetType.Split (p.tipe, range);  &lt;*ASSERT b*&gt;
    EVAL Type.GetBounds (range, min_T, max_T);
    IF NOT TInt.ToInt (min_T, minT)
      OR NOT TInt.ToInt (max_T, maxT) THEN
      Error.Msg (&quot;set constant's domain is too large&quot;);
      minT := FIRST (INTEGER);
      maxT := LAST (INTEGER);
    END;

    EVAL BuildMap (p, p);
    &lt;* ASSERT p.others = NIL *&gt;

    n := p.tree;  curWord := 0;   curMask := TInt.Zero;
    WHILE (n # NIL) DO
      w1 := (n.min - minT) DIV Grain;
      b1 := (n.min - minT) MOD Grain;
      w2 := (n.max - minT) DIV Grain;
      b2 := (n.max - minT) MOD Grain;
      IF (w1 # curWord) THEN
        (* write the mask we've accumulated *)
        IF NOT TInt.EQ (curMask, TInt.Zero) THEN
          CG.Init_int (offset + curWord*Target.Integer.pack,
                        Target.Integer.size, curMask);
        END;
        curWord := w1;
        curMask := TInt.Zero;
      END;
      IF (w1 # w2) THEN
        (* write the full words [w1..w2-1] *)
        TWord.Or (curMask, left [b1], tmp);
        CG.Init_int (offset + w1 * Target.Integer.pack, Target.Integer.size,
                     tmp);
        FOR i := w1 + 1 TO w2 - 1 DO
          CG.Init_int (offset + i * Target.Integer.pack, Target.Integer.size,
                       full);
        END;
        curWord := w2;
        curMask := right [b2];
      ELSE
        TWord.And (left [b1], right[b2], tmp);
        TWord.Or (curMask, tmp, curMask);
      END;
      n := n.next;
    END;

    (* write the last mask *)
    IF NOT TInt.EQ (curMask, TInt.Zero) THEN
      CG.Init_int (offset + curWord * Target.Integer.pack,
                   Target.Integer.size, curMask);
    END;
  END GenLiteral;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  VAR b: BOOLEAN;  s: Target.Int;
  BEGIN
    Grain := MAX (Target.Integer.size, Target.Set_grain);
    TWord.Not (TInt.Zero, full);
    FOR i := 0 TO Grain - 1 DO
      b := TInt.FromInt (i + 1 - Grain, s);  &lt;*ASSERT b*&gt;
      TWord.Shift (full, s, right [i]);
      b := TInt.FromInt (i, s);  &lt;*ASSERT b*&gt;
      TWord.Shift (full, s, left [i]);
    END;
  END Init;

BEGIN
END SetExpr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
