<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/TypeExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/TypeExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: TypeExpr.m3                                           

<P><PRE>MODULE <module><implements><A HREF="TypeExpr.i3">TypeExpr</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="NamedExpr.i3">NamedExpr</A>, <A HREF="QualifyExpr.i3">QualifyExpr</A>;

TYPE
  P = Expr.T BRANDED &quot;TypeExpr.P&quot;OBJECT
        t: Type.T;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        need_addr    := ExprRep.NotAddressable;
        prep         := Compile;
        compile      := Compile;
        prepLV       := ExprRep.NotLValue;
        compileLV    := ExprRep.NotLValue;
        prepBR       := ExprRep.NotBoolean;
        compileBR    := ExprRep.NotBoolean;
        evaluate     := ExprRep.Self;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := ExprRep.NotWritable;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (t: Type.T): Expr.T =
  VAR p := NEW (P);
  BEGIN
    ExprRep.Init (p);
    p.t := t;
    p.type := NIL;
    RETURN p;
  END New;

PROCEDURE <A NAME="Split"><procedure>Split</procedure></A> (e: Expr.T;  VAR t: Type.T): BOOLEAN =
  VAR obj: Value.T;  name: M3ID.T;
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(p) =&gt; t := p.t;  RETURN TRUE;
    ELSE
      IF (NamedExpr.Split (e, name, obj) OR QualifyExpr.Split (e, obj))
        AND (Value.ClassOf (obj) = Value.Class.Type)
        THEN  t := Value.ToType (obj);  RETURN TRUE;
        ELSE  RETURN FALSE;
      END;
    END;
  END Split;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (&lt;*UNUSED*&gt; p: P): Type.T =
  BEGIN
    RETURN NIL;
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  &lt;*UNUSED*&gt; VAR cs: Expr.CheckState) =
  BEGIN
    p.t := Type.Check (p.t);
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN Type.IsEqual (a.t, b.t, NIL);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (&lt;*UNUSED*&gt; p: P) =
  BEGIN
    &lt;*ASSERT FALSE*&gt;
  END Compile;

BEGIN
END TypeExpr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
