<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/exprs/VarExpr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/exprs/VarExpr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: VarExpr.m3                                            

<P><PRE>MODULE <module><implements><A HREF="VarExpr.i3">VarExpr</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="Expr.i3">Expr</A>, <A HREF="ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="../values/Variable.i3">Variable</A>;

TYPE
  P = Expr.T OBJECT
        v : Variable.T;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        need_addr    := NeedsAddress;
        prep         := ExprRep.NoPrep;
        compile      := Compile;
        prepLV       := ExprRep.NoPrep;
        compileLV    := CompileLV;
        prepBR       := ExprRep.PrepNoBranch;
        compileBR    := ExprRep.NoBranch;
        evaluate     := ExprRep.NoValue;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsAlways;
        isDesignator := ExprRep.IsAlways;
	isZeroes     := ExprRep.IsNever;
	genFPLiteral := ExprRep.NoFPLiteral;
	prepLiteral  := ExprRep.NoPrepLiteral;
	genLiteral   := ExprRep.NoLiteral;
        note_write   := NoteWrites;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (t: Type.T;  name: M3ID.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.v := Variable.New (name, TRUE);
    p.type := Type.Base (t);
    Variable.BindType (p.v, t, indirect := FALSE, readonly := FALSE,
                       open_array_ok := FALSE,  needs_init := TRUE);
    RETURN p;
  END New;

PROCEDURE <A NAME="Obj"><procedure>Obj</procedure></A> (e: Expr.T): Variable.T =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN NIL;
    | P(p) =&gt; RETURN p.v;
    ELSE      RETURN NIL;
    END;
  END Obj;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (p: P;  VAR cs: Expr.CheckState) =
  BEGIN
    Value.TypeCheck (p.v, cs);
  END Check;

PROCEDURE <A NAME="EqCheck"><procedure>EqCheck</procedure></A> (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL =&gt; RETURN FALSE;
    | P(b) =&gt; RETURN (a.v = b.v);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (p: P) =
  BEGIN
    Variable.NeedsAddress (p.v);
  END NeedsAddress;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (p: P) =
  BEGIN
    Variable.Load (p.v);
  END Compile;

PROCEDURE <A NAME="CompileLV"><procedure>CompileLV</procedure></A> (p: P) =
  BEGIN
    Variable.LoadLValue (p.v);
  END CompileLV;

PROCEDURE <A NAME="NoteWrites"><procedure>NoteWrites</procedure></A> (p: P) =
  BEGIN
    Variable.ScheduleTrace (p.v);
  END NoteWrites;

BEGIN
END VarExpr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
