<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/CG.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/CG.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: CG.i3                                                 

<P><PRE>INTERFACE <interface><A HREF="CG.m3">CG</A></interface>;

IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/M3CG.i3">M3CG</A>, <A HREF="M3.i3">M3</A>;
</PRE><P>
This interface provides a single front-end specific veneer over
M3CG, M3CG_Ops and M3RT.


<P><PRE>TYPE (* see M3CG for the interpretation of these types *)
  Type        = M3CG.Type;
  MType       = M3CG.MType;
  IType       = M3CG.IType;
  RType       = M3CG.RType;
  AType       = M3CG.AType;
  ZType       = M3CG.ZType;
  Sign        = M3CG.Sign;
  Name        = M3CG.Name;
  Var         = M3CG.Var;
  Proc        = M3CG.Proc;
  Offset      = M3CG.BitOffset;
  Size        = M3CG.BitSize;
  Alignment   = M3CG.Alignment;
  TypeUID     = M3CG.TypeUID;
  Label       = M3CG.Label;
  Frequency   = M3CG.Frequency;
  CallingConvention = M3CG.CallingConvention;

CONST (* see M3CG for the interpretation of these values *)
  No_label  = M3CG.No_label;

CONST (* see M3CG for the interpretation of these values *)
  Never  : Frequency = M3CG.Never;
  Maybe  : Frequency = M3CG.Maybe;
  Likely : Frequency = M3CG.Likely;
  Always : Frequency = M3CG.Always;

VAR (* maximum possible machine alignment *)
  Max_alignment: CARDINAL;

PROCEDURE <A HREF="CG.m3#Init">Init</A> ();
</PRE><BLOCKQUOTE><EM> creates a fresh, initialized code generator </EM></BLOCKQUOTE><PRE>
</PRE>----------------------------------------------------------- ID counters ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Next_label">Next_label</A> (n_labels := 1): Label;
</PRE><BLOCKQUOTE><EM> allocates and returns the next 'n_labels' labels </EM></BLOCKQUOTE><PRE>
</PRE>----------------------------------------------------- compilation units ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Begin_unit">Begin_unit</A> (optimize: INTEGER := 0);
</PRE><BLOCKQUOTE><EM> called before any other procedures to initialize the compilation unit. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#End_unit">End_unit</A> ();
</PRE><BLOCKQUOTE><EM> called after all other procedures to finalize the unit and write the
   resulting object.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Import_unit">Import_unit</A> (n: Name);
PROCEDURE <A HREF="CG.m3#Export_unit">Export_unit</A> (n: Name);
</PRE><BLOCKQUOTE><EM> note that the current compilation unit imports/exports the interface 'n' </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------ debugging line numbers ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Gen_location">Gen_location</A> (here: INTEGER);
</PRE><BLOCKQUOTE><EM> generate the source file and line number info for 'here' </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------- debugging type declarations ---

<P> The debugging information for a type is identified by small a integer
   within a compilation unit.  The information is identified by a global
   uid (an INTEGER) across compilation units. The following procedures generate
   the symbol table entries needed to describe Modula-3 types to the
   debugger.  Note that Modula-3's builtin types have the fixed IDs
   listed above.  The 'hint' passed to 'import_type' is the name of
   the source file that generated the type declaration.  

<P><PRE>PROCEDURE <A HREF="CG.m3#Declare_typename">Declare_typename</A> (t: TypeUID;  n: Name);

PROCEDURE <A HREF="CG.m3#Declare_array">Declare_array</A> (t: TypeUID;  index, elt: TypeUID;  s: Size);
PROCEDURE <A HREF="CG.m3#Declare_open_array">Declare_open_array</A> (t: TypeUID;  elt: TypeUID;  s: Size);

PROCEDURE <A HREF="CG.m3#Declare_enum">Declare_enum</A> (t: TypeUID;  n_elts: INTEGER;  s: Size);
PROCEDURE <A HREF="CG.m3#Declare_enum_elt">Declare_enum_elt</A> (n: Name);

PROCEDURE <A HREF="CG.m3#Declare_packed">Declare_packed</A>  (t: TypeUID;  s: Size;  base: TypeUID);

PROCEDURE <A HREF="CG.m3#Declare_record">Declare_record</A> (t: TypeUID;  s: Size;  n_fields: INTEGER);
PROCEDURE <A HREF="CG.m3#Declare_field">Declare_field</A> (n: Name;  o: Offset;  s: Size;  t: TypeUID);

PROCEDURE <A HREF="CG.m3#Declare_global_field">Declare_global_field</A> (n: Name;  o: Offset;  s: Size;  t: TypeUID);
PROCEDURE <A HREF="CG.m3#Emit_global_record">Emit_global_record</A> (s: Size);

PROCEDURE <A HREF="CG.m3#Declare_set">Declare_set</A> (t, domain: TypeUID;  s: Size);

PROCEDURE <A HREF="CG.m3#Declare_subrange">Declare_subrange</A> (t, domain: TypeUID;  READONLY min, max: Target.Int;
                   s: Size);

PROCEDURE <A HREF="CG.m3#Declare_pointer">Declare_pointer</A> (t, target: TypeUID;  brand: TEXT;  traced: BOOLEAN);

PROCEDURE <A HREF="CG.m3#Declare_indirect">Declare_indirect</A> (target: TypeUID): TypeUID;
</PRE><BLOCKQUOTE><EM> an automatically dereferenced pointer! (WITH variables, VAR formals, ...) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Declare_proctype">Declare_proctype</A> (t: TypeUID; n_formals: INTEGER;
                            result: TypeUID;  n_raises: INTEGER;
                            cc: CallingConvention);
PROCEDURE <A HREF="CG.m3#Declare_formal">Declare_formal</A> (n: Name;  t: TypeUID);
PROCEDURE <A HREF="CG.m3#Declare_raises">Declare_raises</A> (n: Name);

PROCEDURE <A HREF="CG.m3#Declare_object">Declare_object</A> (t, super: TypeUID;  brand: TEXT;  traced: BOOLEAN;
                 n_fields, n_methods, n_overrides: INTEGER;  field_size: Size);
PROCEDURE <A HREF="CG.m3#Declare_method">Declare_method</A> (n: Name;  signature: TypeUID;  dfault: M3.Expr);
PROCEDURE <A HREF="CG.m3#Declare_override">Declare_override</A> (n: Name;  dfault: M3.Expr);
PROCEDURE <A HREF="CG.m3#Declare_opaque">Declare_opaque</A> (t, super: TypeUID);
PROCEDURE <A HREF="CG.m3#Reveal_opaque">Reveal_opaque</A> (lhs, rhs: TypeUID);

PROCEDURE <A HREF="CG.m3#Declare_exception">Declare_exception</A> (n: Name;  arg_type: TypeUID;  raise_proc: BOOLEAN;
                             base: Var;  offset: INTEGER);
</PRE><BLOCKQUOTE><EM> declares an exception named 'n' identified with the address 'base+offset'
   that carries an argument of type 'arg_type'.  If 'raise_proc', then
   'base+offset+BYTESIZE(ADDRESS)' is a pointer to the procedure that
   packages the argument and calls the runtime to raise the exception. </EM></BLOCKQUOTE><PRE>
</PRE>--------------------------------------------------------- runtime hooks ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Set_runtime_hook">Set_runtime_hook</A> (n: Name;  v: Var;  o: Offset);
</PRE><BLOCKQUOTE><EM> declares 'n' as a runtime symbol at location 'ADR(v)+o' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Get_runtime_hook">Get_runtime_hook</A> (n: Name;  VAR v: Var;  VAR o: Offset);
</PRE><BLOCKQUOTE><EM> returns the location of the runtime symbol 'n' </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------- variable declarations ---

<P> Clients must declare a variable before generating any statements or
   expressions that refer to it;  declarations of global variables and
   temps can be intermixed with generation of statements and expressions.
<P>
   In the declarations that follow:
<P>
<PRE>
         n: Name            is the name of the variable.  If it's NIL, the
                              the back-end is free to choose its own unique name.
         s: Size            is the size in bits of the declared variable
         a: Alignment       is the minimum required alignment of the variable
         t: Type            is the machine reprentation type of the variable
         m3t: TypeUID       is the UID of the Modula-3 type of the variable
         in_memory: BOOLEAN specifies whether the variable must have an address
         exported: BOOLEAN  specifies whether the variable must be visible in
                              other compilation units
         init: BOOLEAN      indicates whether an explicit static initialization
                              immediately follows this declaration.
         up_level: BOOLEAN  specifies whether the variable is accessed from
                              nested procedures.
         f: Frequency       is the front-end estimate of how frequently the
                              variable is accessed.
</PRE>


<P><PRE>PROCEDURE <A HREF="CG.m3#Import_global">Import_global</A> (n: Name;  s: Size;  a: Alignment;
                         t: Type;  m3t: TypeUID): Var;
</PRE><BLOCKQUOTE><EM> imports the specified global variable. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Declare_segment">Declare_segment</A> (n: Name;  m3t: TypeUID): Var;
PROCEDURE <A HREF="CG.m3#Bind_segment">Bind_segment</A> (seg: Var;  s: Size;  a: Alignment;  t: Type;
                        exported, init: BOOLEAN);
</PRE><BLOCKQUOTE><EM> Together Declare_segment and Bind_segment accomplish what
   Declare_global does, but Declare_segment gives the front-end a
   handle on the variable before its size, type, or initial values
   are known.  Every declared segment must be bound exactly once. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Declare_global">Declare_global</A> (n: Name;  s: Size;  a: Alignment;  t: Type;
                          m3t: TypeUID;  exported, init: BOOLEAN): Var;
</PRE><BLOCKQUOTE><EM> declares a global variable. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Declare_constant">Declare_constant</A> (n: Name;  s: Size;  a: Alignment;  t: Type;
                            m3t: TypeUID;  exported, init: BOOLEAN): Var;
</PRE><BLOCKQUOTE><EM> declares a read-only global variable </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Declare_local">Declare_local</A> (n: Name;  s: Size;  a: Alignment;  t: Type;
                         m3t: TypeUID;  in_memory, up_level: BOOLEAN;
                         f: Frequency): Var;
</PRE><BLOCKQUOTE><EM> declares a local variable.  Local variables must be declared in the
   procedure that contains them.  The lifetime of a local variable extends
   from the beginning to end of the closest enclosing begin_block/end_block. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Declare_param">Declare_param</A> (n: Name;  s: Size;  a: Alignment;  t: Type;
                         m3t: TypeUID;  in_memory, up_level: BOOLEAN;
                         f: Frequency): Var;
</PRE><BLOCKQUOTE><EM> declares a formal parameter.  Formals are declared in their lexical
   order immediately following the 'declare_procedure' or
   'import_procedure' that contains them.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Declare_temp">Declare_temp</A> (s: Size;  a: Alignment;  t: Type;
                        in_memory: BOOLEAN): Var;
</PRE><BLOCKQUOTE><EM> declares an anonymous local variable.  Temps are declared
   and freed between their containing procedure's begin_procedure and
   end_procedure calls.  Temps are never referenced by nested procedures. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Free_temp">Free_temp</A> (v: Var);
</PRE><BLOCKQUOTE><EM> releases the space occupied by temp 'v' so that it may be reused by
   other new temporaries. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Free_temps">Free_temps</A> ();
</PRE><BLOCKQUOTE><EM> free any temps that are marked busy. </EM></BLOCKQUOTE><PRE>
</PRE>--------------------------------------------- direct stack manipulation ---

<P><PRE>TYPE <A HREF="CG.m3#Val">Val</A> &lt;: REFANY; (* a stack value: R-value or L-value *)

PROCEDURE <A HREF="CG.m3#Pop">Pop</A> (): Val;
</PRE><BLOCKQUOTE><EM> return s0;  pop -- if necessary, create a temp and store s0 in it.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Pop_temp">Pop_temp</A> (): Val;
</PRE><BLOCKQUOTE><EM> return s0;  pop -- create a temp and store s0 in it.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Push">Push</A> (v: Val);
</PRE><BLOCKQUOTE><EM> push;  s0 := v </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Free">Free</A> (v: Val);
</PRE><BLOCKQUOTE><EM> free any temporaries that <CODE>v</CODE> created </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Store_temp">Store_temp</A> (v: Val);
</PRE><BLOCKQUOTE><EM> v := s0;  pop  -- v must have been created by <CODE>Pop_temp</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Force">Force</A> ();
</PRE><BLOCKQUOTE><EM> force s0 to be materialized on the M3CG stack.  If s0 is an L-value,
   a byte-aligned address is generated.  </EM></BLOCKQUOTE><PRE>
</PRE>---------------------------------------- static variable initialization ---

<P> Global variables may be initialized only once.  All of their init_*
   calls must be bracketed by begin_init and end_init.  Within a begin/end
   pair, init_* calls must be made in ascending offset order.  Begin/end
   pairs may not be nested.  Any space in a global variable that's not
   explicitly initialized is zeroed.  

<P><PRE>PROCEDURE <A HREF="CG.m3#Begin_init">Begin_init</A> (v: Var);
PROCEDURE <A HREF="CG.m3#End_init">End_init</A> (v: Var);
</PRE><BLOCKQUOTE><EM> must precede and follow any init calls </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Init_int">Init_int</A>  (o: Offset;  s: Size;  READONLY value: Target.Int);
PROCEDURE <A HREF="CG.m3#Init_intt">Init_intt</A> (o: Offset;  s: Size;  value: INTEGER);
</PRE><BLOCKQUOTE><EM> initializes the integer static variable at 'ADR(v)+offset' with
   the 's' low order bits of 'value' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Init_proc">Init_proc</A> (o: Offset;  value: Proc);
</PRE><BLOCKQUOTE><EM> initializes the static variable at 'ADR(v)+o' with the address
   of procedure 'value'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Init_label">Init_label</A> (o: Offset;  value: Label);
</PRE><BLOCKQUOTE><EM> initializes the static variable at 'ADR(v)+o' with the address
   of the label 'value'.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Init_var">Init_var</A> (o: Offset;  value: Var;  bias: Offset);
</PRE><BLOCKQUOTE><EM> initializes the static variable at 'ADR(v)+o' with the address
   of 'value+bias'.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Init_offset">Init_offset</A> (o: Offset;  var: Var);
</PRE><BLOCKQUOTE><EM> initializes the static variable at 'ADR(v)+o' with the integer
   frame offset of the local variable 'var'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Init_chars">Init_chars</A> (o: Offset;  value: TEXT);
</PRE><BLOCKQUOTE><EM> initializes the static variable at 'ADR(v)+offset' with the characters
   of 'value' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Init_float">Init_float</A> (o: Offset;  READONLY f: Target.Float);
</PRE><BLOCKQUOTE><EM> initializes the static variable at 'ADR(v)+offset' with the
   floating point value 'f' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#EmitText">EmitText</A> (t: TEXT): INTEGER;
</PRE><BLOCKQUOTE><EM> Emits the zero terminated string and returns its global offset. </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------------------ procedures ---

<P> Clients compile a procedure by doing:
<P>
      proc := Declare_procedure (...)
        ...declare formals...
        ...declare locals...
        ...generate nested procedures (IF nested_procs_first)...
      Begin_procedure (proc)
        ...generate statements of procedure...
      End_procedure (...)
        ...generate nested procedures (IF NOT nested_procs_first)...
<P>
  begin_/end_procedure should never be nested;  depending on the
  value of 'nested_procs_first', clients compile nested procedures
  either immediately before or after their enclosing procedure.


<P><PRE>PROCEDURE <A HREF="CG.m3#Import_procedure">Import_procedure</A> (n: Name;  n_params: INTEGER;  ret_type: Type;
                            cc: CallingConvention;
                            VAR(*OUT*) new: BOOLEAN): Proc;
</PRE><BLOCKQUOTE><EM> declare and import the external procedure with name 'n' and 'n_params'
   formal parameters.  It must be a top-level (=0) procedure that returns
   values of type 'ret_type'.  'cc' is the convention specified
   in the procedure's &lt;*EXTERNAL*&gt; declaration.  If 'new' is 'TRUE', the formal
   parameters must be specified by the subsequent 'declare_param' calls. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Declare_procedure">Declare_procedure</A> (n: Name;  n_params: INTEGER;  ret_type: Type;
                             lev: INTEGER;  cc: CallingConvention;
                             exported: BOOLEAN;  parent: Proc): Proc;
</PRE><BLOCKQUOTE><EM> declare a procedure named 'n' with 'n_params' formal parameters
   at static level 'lev'.  Sets <CODE>current procedure</CODE> to this procedure.
   If the name 'n' is NIL, a new unique name will be supplied by the back-end.
   The type of the procedure's result is specifed in 'ret_type'.  If the new
   procedure is a nested procedure (level &gt; 1) then 'parent' is
   the immediately enclosing procedure, otherwise 'parent' is NIL.
   The formal parameters are specified by the subsequent 'declare_param'
   calls. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Begin_procedure">Begin_procedure</A> (p: Proc);
</PRE><BLOCKQUOTE><EM> begin generating code for the procedure 'p'.  Sets <CODE>current procedure</CODE>
   to 'p'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#End_procedure">End_procedure</A> (p: Proc);
</PRE><BLOCKQUOTE><EM> marks the end of the code for procedure 'p'.  Sets <CODE>current procedure</CODE>
   to NIL. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Begin_block">Begin_block</A> ();
PROCEDURE <A HREF="CG.m3#End_block">End_block</A> ();
</PRE><BLOCKQUOTE><EM> marks the beginning and ending of nested anonymous blocks </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Note_procedure_origin">Note_procedure_origin</A> (p: Proc);
</PRE><BLOCKQUOTE><EM> note that nested procedure 'p's body occured at the current location
   in the source.  In particular, nested in whatever procedures,
   anonymous blocks, or exception scopes surround this point. </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------------------ statements ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Set_label">Set_label</A> (l: Label;  barrier: BOOLEAN := FALSE);
</PRE><BLOCKQUOTE><EM> define 'l' to be at the current pc, if 'barrier', 'l' bounds an exception
   scope and no code is allowed to migrate past it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Jump">Jump</A> (l: Label);
</PRE><BLOCKQUOTE><EM> GOTO l </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#If_true">If_true</A>  (l: Label;  f: Frequency);
</PRE><BLOCKQUOTE><EM> tmp := s0.I; pop; IF (tmp # 0) GOTO l </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#If_false">If_false</A> (l: Label;  f: Frequency);
</PRE><BLOCKQUOTE><EM> tmp := s0.I; pop; IF (tmp = 0) GOTO l </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#If_eq">If_eq</A> (l: Label;  t: ZType;  f: Frequency); (*== eq(t); if_true(l) *)
PROCEDURE <A HREF="CG.m3#If_ne">If_ne</A> (l: Label;  t: ZType;  f: Frequency); (*== ne(t); if_true(l) *)
PROCEDURE <A HREF="CG.m3#If_gt">If_gt</A> (l: Label;  t: ZType;  f: Frequency); (*== gt(t); if_true(l) *)
PROCEDURE <A HREF="CG.m3#If_ge">If_ge</A> (l: Label;  t: ZType;  f: Frequency); (*== ge(t); if_true(l) *)
PROCEDURE <A HREF="CG.m3#If_lt">If_lt</A> (l: Label;  t: ZType;  f: Frequency); (*== lt(t); if_true(l) *)
PROCEDURE <A HREF="CG.m3#If_le">If_le</A> (l: Label;  t: ZType;  f: Frequency); (*== le(t); if_true(l) *)

PROCEDURE <A HREF="CG.m3#Case_jump">Case_jump</A> (READONLY labels: ARRAY OF Label);
</PRE><BLOCKQUOTE><EM> tmp := s0.I; pop; GOTO labels[tmp]  (NOTE: no range checking on s0.I) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Exit_proc">Exit_proc</A> (t: Type);
</PRE><BLOCKQUOTE><EM> Returns s0.t if the stack is non-empty, otherwise returns no value. </EM></BLOCKQUOTE><PRE>
</PRE>----------------------------------------------------------- expressions ---

<P>  The code to evaluate expressions is generated by calling the
    procedures listed below.  Each procedure corresponds to an
    instruction for a simple stack machine.  Values in the stack
    have a type and a size.  Operations on the stack values are
    also typed.  Type mismatches may cause bad code to be generated.
    Explicit type conversions must be used.
<P>
    Integer values on the stack, regardless of how they are loaded,
    are sign-extended to full-width values.  Similarly, word values
    on the stack are always zero-extened to full-width values.
<P>
    The expression stack must be empty at each label, jump, call,
    or store operation.  The stack must contain exactly one value
    prior to a conditional or indexed jump.
<P>
    All addresses are bit addresses.  There is no boolean type;  boolean
    operators yield [0..1].
<P>
    Operations on word values are performed MOD the word size and are
    not checked for overflow.  Operations on integer values may or may not
    cause checked runtime errors depending on the particular code generator.
<P>
    The operators are declared below with a definition in terms of
    what they do to the execution stack.  For example,  ceiling(Reel)
    returns the ceiling, an integer, of the top value on the stack,
    a real:  s0.I := CEILING (s0.R).
<P>
    Unless otherwise indicated, operators have the same meaning as in
    the Modula-3 report.


<P>------------------------------------------------------------ load/store ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Load">Load</A> (v: Var;  o: Offset;  s: Size;  a: Alignment;  t: Type);
</PRE><BLOCKQUOTE><EM> push ; s0.t := Mem [ ADR(v) + o : s ] </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Load_addr_of">Load_addr_of</A> (v: Var;  o: Offset;  a: Alignment);
</PRE><BLOCKQUOTE><EM> push ; s0.A := ADR(v) + o </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Load_addr_of_temp">Load_addr_of_temp</A> (v: Var;  o: Offset;  a: Alignment);
</PRE><BLOCKQUOTE><EM> == Load_addr_of (v, o, a) ; free v when this L-value is consumed </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Load_indirect">Load_indirect</A> (t: Type;  o: Offset;  s: Size);
</PRE><BLOCKQUOTE><EM> s0.t := Mem [s0.A + o : s] </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Load_int">Load_int</A> (v: Var;  o: Offset := 0);
</PRE><BLOCKQUOTE><EM> == Load (v, o, Target.Integer.size, Target.Integer.align, Type.Int) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Load_int_temp">Load_int_temp</A> (v: Var;  o: Offset := 0);
</PRE><BLOCKQUOTE><EM> == Load_int (v, o); free v when this R-value is consumed </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Load_addr">Load_addr</A> (v: Var;  o: Offset := 0);
</PRE><BLOCKQUOTE><EM> == Load (v, o, Target.Address.size, Target.Address.align, Type.Addr) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Store">Store</A> (v: Var;  o: Offset;  s: Size;  a: Alignment;  t: Type);
</PRE><BLOCKQUOTE><EM> Mem [ ADR(v) + o : s ] := s0.t ; pop </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Store_ref">Store_ref</A> (v: Var;  o: Offset := 0);
</PRE><BLOCKQUOTE><EM> == store (v, o, Target.Address.size, Target.Address.align, Type.Addr),
          but also does reference counting </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Store_indirect">Store_indirect</A> (t: Type;  o: Offset;  s: Size);
</PRE><BLOCKQUOTE><EM> Mem [s1.A + o : s] := s0.t ; pop (2) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Store_ref_indirect">Store_ref_indirect</A> (o: Offset;  var: BOOLEAN);
  (* == store_indirect(Type.Addr, o, Target.Address.size);
     but also does reference counting.  If &quot;var&quot; is true, then reference
     counting depends on whether the effective address is in the heap or
     stack. *)

PROCEDURE <A HREF="CG.m3#Store_int">Store_int</A> (v: Var;  o: Offset := 0);
</PRE><BLOCKQUOTE><EM> == Store (v, o, Target.Integer.size, Target.Integer.align, Type.Int) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Store_addr">Store_addr</A> (v: Var;  o: Offset := 0);
</PRE><BLOCKQUOTE><EM> == Store (v, o, Target.Address.size, Target.Address.align, Type.Addr) </EM></BLOCKQUOTE><PRE>
</PRE>-------------------------------------------------------------- literals ---

<P>
<P><PRE>PROCEDURE <A HREF="CG.m3#Load_nil">Load_nil</A>     ();                         (*push ; s0.A := NIL*)
PROCEDURE <A HREF="CG.m3#Load_byte_address">Load_byte_address</A> (x: INTEGER);          (*push ; s0.A := x *)
PROCEDURE <A HREF="CG.m3#Load_intt">Load_intt</A>    (i: INTEGER);               (*push;  s0.I := i *)
PROCEDURE <A HREF="CG.m3#Load_integer">Load_integer</A> (READONLY i: Target.Int);   (*push ; s0.I := i *)
PROCEDURE <A HREF="CG.m3#Load_float">Load_float</A>   (READONLY f: Target.Float); (*push ; s0.t := f *)
</PRE>------------------------------------------------------------ arithmetic ---

<P> when any of these operators is passed t=Type.Word, the operator
   does the unsigned comparison or arithmetic, but the operators
   and the result are of type Integer 
   
<P><PRE>PROCEDURE <A HREF="CG.m3#Eq">Eq</A>        (t: ZType);  (* s1.I := (s1.t = s0.t)  ; pop *)
PROCEDURE <A HREF="CG.m3#Ne">Ne</A>        (t: ZType);  (* s1.I := (s1.t # s0.t)  ; pop *)
PROCEDURE <A HREF="CG.m3#Gt">Gt</A>        (t: ZType);  (* s1.I := (s1.t &gt; s0.t)  ; pop *)
PROCEDURE <A HREF="CG.m3#Ge">Ge</A>        (t: ZType);  (* s1.I := (s1.t &gt;= s0.t) ; pop *)
PROCEDURE <A HREF="CG.m3#Lt">Lt</A>        (t: ZType);  (* s1.I := (s1.t &lt; s0.t)  ; pop *)
PROCEDURE <A HREF="CG.m3#Le">Le</A>        (t: ZType);  (* s1.I := (s1.t &lt;= s0.t) ; pop *)
PROCEDURE <A HREF="CG.m3#Add">Add</A>       (t: AType);  (* s1.t := s1.t + s0.t ; pop *)
PROCEDURE <A HREF="CG.m3#Subtract">Subtract</A>  (t: AType);  (* s1.t := s1.t - s0.t ; pop *)
PROCEDURE <A HREF="CG.m3#Multiply">Multiply</A>  (t: AType);  (* s1.t := s1.t * s0.t ; pop *)
PROCEDURE <A HREF="CG.m3#Divide">Divide</A>    (t: RType);  (* s1.t := s1.t / s0.t ; pop *)
PROCEDURE <A HREF="CG.m3#Negate">Negate</A>    (t: AType);  (* s0.t := - s0.t *)
PROCEDURE <A HREF="CG.m3#Abs">Abs</A>       (t: AType);  (* s0.t := ABS (s0.t) (noop on Words) *)
PROCEDURE <A HREF="CG.m3#Max">Max</A>       (t: ZType);  (* s1.t := MAX (s1.t, s0.t) ; pop *)
PROCEDURE <A HREF="CG.m3#Min">Min</A>       (t: ZType);  (* s1.t := MIN (s1.t, s0.t) ; pop *)
PROCEDURE <A HREF="CG.m3#Round">Round</A>     (t: RType);  (* s0.I := ROUND (s0.t) *)
PROCEDURE <A HREF="CG.m3#Trunc">Trunc</A>     (t: RType);  (* s0.I := TRUNC (s0.t) *)
PROCEDURE <A HREF="CG.m3#Floor">Floor</A>     (t: RType);  (* s0.I := FLOOR (s0.t) *)
PROCEDURE <A HREF="CG.m3#Ceiling">Ceiling</A>   (t: RType);  (* s0.I := CEILING (s0.t) *)
PROCEDURE <A HREF="CG.m3#Cvt_float">Cvt_float</A> (t: AType;  u: RType);   (* s0.u := FLOAT (s0.t, u) *)
PROCEDURE <A HREF="CG.m3#Div">Div</A>       (t: IType;  a, b: Sign); (* s1.t := s1.t DIV s0.t;pop*)
PROCEDURE <A HREF="CG.m3#Mod">Mod</A>       (t: IType;  a, b: Sign); (* s1.t := s1.t MOD s0.t;pop*)
</PRE>------------------------------------------------------------------ sets ---

<P> Set sizes are in bits.  Sets not larger than an integer are
   represented on the stack as integers.  Other <CODE>large</CODE> sets are
   represented by their addresses.  The strict inequality operators
   (lt, gt) are *not* supported for small sets, the front-end
   must synthesize them from union, difference, eq, etc.  

<P><PRE>PROCEDURE <A HREF="CG.m3#Set_union">Set_union</A>          (s: Size);  (* s2.B := s1.B + s0.B ; pop(3) *)
PROCEDURE <A HREF="CG.m3#Set_difference">Set_difference</A>     (s: Size);  (* s2.B := s1.B - s0.B ; pop(3) *)
PROCEDURE <A HREF="CG.m3#Set_intersection">Set_intersection</A>   (s: Size);  (* s2.B := s1.B * s0.B ; pop(3) *)
PROCEDURE <A HREF="CG.m3#Set_sym_difference">Set_sym_difference</A> (s: Size);  (* s2.B := s1.B / s0.B ; pop(3) *)
PROCEDURE <A HREF="CG.m3#Set_member">Set_member</A>         (s: Size);  (* s1.I := (s0.I IN s1.B); pop *)
PROCEDURE <A HREF="CG.m3#Set_eq">Set_eq</A>             (s: Size);  (* s1.I := (s1.B = s0.B); pop *)
PROCEDURE <A HREF="CG.m3#Set_ne">Set_ne</A>             (s: Size);  (* s1.I := (s1.B # s0.B); pop *)
PROCEDURE <A HREF="CG.m3#Set_lt">Set_lt</A>             (s: Size);  (* s1.I := (s1.B &lt; s0.B); pop *)
PROCEDURE <A HREF="CG.m3#Set_le">Set_le</A>             (s: Size);  (* s1.I := (s1.B &lt;= s0.B); pop *)
PROCEDURE <A HREF="CG.m3#Set_gt">Set_gt</A>             (s: Size);  (* s1.I := (s1.B &gt; s0.B); pop *)
PROCEDURE <A HREF="CG.m3#Set_ge">Set_ge</A>             (s: Size);  (* s1.I := (s1.B &gt;= s0.B); pop *)
PROCEDURE <A HREF="CG.m3#Set_singleton">Set_singleton</A>      (s: Size);  (* s1.A [s0.I] := 1; pop(2) *)
PROCEDURE <A HREF="CG.m3#Set_range">Set_range</A>          (s: Size);  (* s2.A[s1.I..s0.I] := 1; pop(3)
                                             --- S2.A must be forced *)
</PRE>------------------------------------------------- Word.T bit operations ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Not">Not</A> ();  (* s0.I := Word.Not (s0.I) *)
PROCEDURE <A HREF="CG.m3#And">And</A> ();  (* s1.I := Word.And (s1.I, s0.I) ; pop *)
PROCEDURE <A HREF="CG.m3#Or">Or</A>  ();  (* s1.I := Word.Or  (s1.I, s0.I) ; pop *)
PROCEDURE <A HREF="CG.m3#Xor">Xor</A> ();  (* s1.I := Word.Xor (s1.I, s0.I) ; pop *)

PROCEDURE <A HREF="CG.m3#Shift">Shift</A>        ();  (* s1.I := Word.Shift  (s1.I, s0.I) ; pop *)
PROCEDURE <A HREF="CG.m3#Shift_left">Shift_left</A>   ();  (* s1.I := Word.Shift  (s1.I, s0.I) ; pop *)
PROCEDURE <A HREF="CG.m3#Shift_right">Shift_right</A>  ();  (* s1.I := Word.Shift  (s1.I, -s0.I) ; pop *)
PROCEDURE <A HREF="CG.m3#Rotate">Rotate</A>       ();  (* s1.I := Word.Rotate (s1.I, s0.I) ; pop *)
PROCEDURE <A HREF="CG.m3#Rotate_left">Rotate_left</A>  ();  (* s1.I := Word.Rotate (s1.I, s0.I) ; pop *)
PROCEDURE <A HREF="CG.m3#Rotate_right">Rotate_right</A> ();  (* s1.I := Word.Rotate (s1.I, -s0.I) ; pop *)

PROCEDURE <A HREF="CG.m3#Extract">Extract</A> (sign: BOOLEAN);
  (* s2.I := Word.Extract(s2.I, s1.I, s0.I);
     IF sign THEN SignExtend s2 ; pop(2) *)

PROCEDURE <A HREF="CG.m3#Extract_n">Extract_n</A> (sign: BOOLEAN;  n: INTEGER);
</PRE><BLOCKQUOTE><EM> s1.I := Word.Extract(s1.I, s0.I, n);
   IF sign THEN SignExtend s1; pop(1) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Extract_mn">Extract_mn</A> (sign: BOOLEAN;  m, n: INTEGER);
</PRE><BLOCKQUOTE><EM> s0.I := Word.Extract(s0.I, m, n);
   IF sign THEN SignExtend s0 </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Insert">Insert</A>  ();
  (* s3.I := Word.Insert (s3.I, s2.I, s1.I, s0.I) ; pop(3) *)

PROCEDURE <A HREF="CG.m3#Insert_n">Insert_n</A> (n: INTEGER);
</PRE><BLOCKQUOTE><EM> s2.I := Word.Insert (s2.I, s1.I, s0.I, n); pop(2) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Insert_mn">Insert_mn</A> (m, n: INTEGER);
</PRE><BLOCKQUOTE><EM> s1.I := Word.Insert (s1.I, s0.I, m, n); pop(1) </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------ misc. stack/memory ops ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Swap">Swap</A> ();           (* tmp := s1; s1 := s0; s0 := tmp *)
PROCEDURE <A HREF="CG.m3#Discard">Discard</A> (t: Type); (* pop(1) discard s0, not its side effects *)

PROCEDURE <A HREF="CG.m3#Copy_n">Copy_n</A> (s: Size;  overlap: BOOLEAN);
</PRE><BLOCKQUOTE><EM> Mem[s2.A:s0.I*s] := Mem[s1.A:s0.I*s]; pop(3) -- s2.A &amp;s1.A must be forced.
   'overlap' is true if the source and destination may partially overlap
   (ie. you need memmove, not just memcpy). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Copy">Copy</A> (s: Size;  overlap: BOOLEAN);
</PRE><BLOCKQUOTE><EM> Mem[s1.A:s] := Mem[s0.A:s]; pop(2).
   'overlap' is true if the source and destination may partially overlap
   (ie. you need memmove, not just memcpy). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Zero">Zero</A> (s: Size);
</PRE><BLOCKQUOTE><EM> Mem[s0.A:s] := 0; pop(1) </EM></BLOCKQUOTE><PRE>
</PRE>----------------------------------------------------------- conversions ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Loophole">Loophole</A> (from, two: Type);
</PRE><BLOCKQUOTE><EM> s0.to := LOOPHOLE(s0.from, to) </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------ traps &amp; runtime checks ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Assert_fault">Assert_fault</A>   ();
PROCEDURE <A HREF="CG.m3#Narrow_fault">Narrow_fault</A>   ();
PROCEDURE <A HREF="CG.m3#Return_fault">Return_fault</A>   ();
PROCEDURE <A HREF="CG.m3#Case_fault">Case_fault</A>     ();
PROCEDURE <A HREF="CG.m3#Typecase_fault">Typecase_fault</A> ();
</PRE><BLOCKQUOTE><EM> Abort </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Check_nil">Check_nil</A> ();
</PRE><BLOCKQUOTE><EM> IF (s0.A = NIL) THEN Abort </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Check_lo">Check_lo</A> (READONLY i: Target.Int);
</PRE><BLOCKQUOTE><EM> IF (s0.I &lt; i) THEN Abort </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Check_hi">Check_hi</A> (READONLY i: Target.Int);
</PRE><BLOCKQUOTE><EM> IF (i &lt; s0.I) THEN Abort </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Check_range">Check_range</A> (READONLY a, b: Target.Int);
</PRE><BLOCKQUOTE><EM> IF (s0.I &lt; a) OR (b &lt; s0.I) THEN Abort </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Check_index">Check_index</A> ();
</PRE><BLOCKQUOTE><EM> IF NOT (0 &lt;= s1.I &lt; s0.I) THEN Abort END; pop </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Check_eq">Check_eq</A> ();
</PRE><BLOCKQUOTE><EM> IF (s0.I # s1.I) THEN Abort;  Pop (2) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Check_byte_aligned">Check_byte_aligned</A> ();
</PRE><BLOCKQUOTE><EM> IF (s0.A is not byte-aligned) THEN Abort </EM></BLOCKQUOTE><PRE>
</PRE>---------------------------------------------------- address arithmetic ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Add_offset">Add_offset</A> (i: INTEGER);
</PRE><BLOCKQUOTE><EM> s0.A := s0.A + i </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Index_bytes">Index_bytes</A> (size: INTEGER);
</PRE><BLOCKQUOTE><EM> s1.A := s1.A + s0.I * size ; pop -- size must be a multiple of
   Target.Byte. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Index_bits">Index_bits</A> ();
</PRE><BLOCKQUOTE><EM> s1.A := s1.A + s0.I ; pop -- note that s0.I must be less than
  or equal to the alignment of s1.A, otherwise bad code will be generated. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Boost_alignment">Boost_alignment</A> (a: Alignment);
</PRE><BLOCKQUOTE><EM> note that s0.A has an alignment of at least 'a'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#GCD">GCD</A> (a, b: INTEGER): INTEGER;
</PRE><BLOCKQUOTE><EM> return the greatest x that divides both a and b. </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------------- procedure calls ---

<P> To generate a direct procedure call:
<P>
      Start_call_direct (proc, level, t);
    <P>
      for each actual parameter i
          &lt;generate value for parameter i&gt;
          Pop_param ();  -or-  Pop_struct();
        <P>
      Call_direct (proc, t);
<P>
   or to generate an indirect call:
<P>
      Start_call_indirect (t, cc);
<P>
      If the target is a nested procedure,
          &lt;evaluate the static link to be used&gt;
          Pop_static_link ();
    <P>
      for each actual parameter i
          &lt;generate value for parameter i&gt;
          Pop_param ();  -or-  Pop_struct();
<P>
      &lt;evaluate the address of the procedure to call&gt;
      Call_indirect (t, cc);


<P><PRE>PROCEDURE <A HREF="CG.m3#Start_call_direct">Start_call_direct</A> (p: Proc;  lev: INTEGER;  t: Type);
</PRE><BLOCKQUOTE><EM> begin a procedure call to procedure 'p' at static level 'lev'
   that will return a value of type 't'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Call_direct">Call_direct</A> (p: Proc;  t: Type);
</PRE><BLOCKQUOTE><EM> call the procedure 'p'.  It returns a value of type t. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Start_call_indirect">Start_call_indirect</A> (t: Type;  cc: CallingConvention);
</PRE><BLOCKQUOTE><EM> begin an indirect procedure call that will return a value of type 't'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Call_indirect">Call_indirect</A> (t: Type;  cc: CallingConvention);
</PRE><BLOCKQUOTE><EM> call the procedure whose address is in s0.A and pop s0.  The
   procedure returns a value of type t. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Pop_param">Pop_param</A> (t: Type);
</PRE><BLOCKQUOTE><EM> pop s0.t and make it the <CODE>next</CODE> parameter in the current call </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Pop_struct">Pop_struct</A> (s: Size;  a: Alignment);
</PRE><BLOCKQUOTE><EM> pop s0.A, it's a pointer to a structure occupying 's' bits that's
  'a' bit aligned; pass it by value as the <CODE>next</CODE> parameter in the current
  call. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Pop_static_link">Pop_static_link</A> ();
</PRE><BLOCKQUOTE><EM> pop s0.A and make it the static link for the current indirect procedure call </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------- procedure and closure types ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Load_procedure">Load_procedure</A> (p: Proc);
</PRE><BLOCKQUOTE><EM> push; s0.A := ADDR (p's body) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Load_static_link">Load_static_link</A> (p: Proc);
</PRE><BLOCKQUOTE><EM> push; s0.A := (static link need to call p, NIL for top-level procs) </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------ builtin type operations --

<P><PRE>PROCEDURE <A HREF="CG.m3#Ref_to_typecode">Ref_to_typecode</A> ();
</PRE><BLOCKQUOTE><EM> s0.I := TYPECODE (s0.A)  for non-NIL s0.A
   == Load_indirect (Type.Int, -Target.Address.pack,
                        Target.Address.align, Target.Address.size);
      Load_integer (1);
      Shift_right ();
</EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------------------ open arrays --

<P><PRE>PROCEDURE <A HREF="CG.m3#Open_elt_ptr">Open_elt_ptr</A> (a: Alignment);
</PRE><BLOCKQUOTE><EM> == Load_indirect (Type.Addr, M3RT.OA_elt_ptr, Target.Address.align,
                        Target.Address.size);  Boost_alignment (a) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Open_size">Open_size</A> (n: INTEGER);
</PRE><BLOCKQUOTE><EM> == Load_indirect (Type.Int, M3RT.OA_sizes + n * Target.Integer.pack,
                        Target.Integer.align, Target.Integer.size) </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------- procedure and closure types ---

<P><PRE>PROCEDURE <A HREF="CG.m3#If_closure">If_closure</A> (proc: Val;  true, false: Label;  freq: Frequency);
</PRE><BLOCKQUOTE><EM> x := (proc # NIL) AND ORD ((proc)^.CL_marker = CL_marker_value);
   IF (x) GOTO true ELSE goto FALSE;
 Note: either true or false must be No_label </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Closure_proc">Closure_proc</A> ();
</PRE><BLOCKQUOTE><EM> s0.A := (s0.A)^.CL_proc </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CG.m3#Closure_frame">Closure_frame</A> ();
</PRE><BLOCKQUOTE><EM> s0.A := (s0.A)^.CL_frame </EM></BLOCKQUOTE><PRE>
</PRE>----------------------------------------------------------------- misc. ---

<P><PRE>PROCEDURE <A HREF="CG.m3#Comment">Comment</A> (offset: INTEGER;  a, b, c, d: TEXT := NIL);
</PRE><BLOCKQUOTE><EM> annotate the output with a&amp;b&amp;c&amp;d as a comment </EM></BLOCKQUOTE><PRE>

END CG.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
