<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/Coverage.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/Coverage.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Coverage.m3                                           

<P><PRE>MODULE <module><implements><A HREF="Coverage.i3">Coverage</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="#x1">M3ID</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="Host.i3">Host</A>, <A HREF="Scanner.i3">Scanner</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="CG.i3">CG</A>;

TYPE
  ProcHead = REF RECORD
    next   : ProcHead;
    proc   : Value.T;
    name   : TEXT;
    offset : INTEGER;
  END;

CONST
  Header  = &quot;&lt;&lt;&lt;&lt;Coverage 1.0&quot;;
  Trailer = &quot;Coverage 1.0&gt;&gt;&gt;&gt;&quot;;
  MaxLine = 100000;

TYPE
  LineSeen = {no, yes, generated};

VAR
  minLine : INTEGER := LAST (INTEGER);
  maxLine : INTEGER := FIRST (INTEGER);
  used    : REF ARRAY OF LineSeen := NIL;
  procs   : ProcHead := NIL;
  nProcs  : INTEGER := 0;
  tbl     : CG.Var := NIL;
  lines_offset : INTEGER;

PROCEDURE <A NAME="NoteLine"><procedure>NoteLine</procedure></A> () =
  VAR line: INTEGER;  file: TEXT;
  BEGIN
    IF (NOT Host.coverage) THEN RETURN END;
    Scanner.Here (file, line);
    IF (line &gt; MaxLine) THEN RETURN END;
    IF NOT Text.Equal (file, Host.filename) THEN RETURN END;
    minLine := MIN (minLine, line);
    maxLine := MAX (maxLine, line);
    WHILE (used = NIL) OR (LAST (used^) &lt; line) DO Expand () END;
    used[line] := LineSeen.yes;
  END NoteLine;

PROCEDURE <A NAME="Expand"><procedure>Expand</procedure></A> () =
  BEGIN
    IF (used = NIL) THEN
      used := NEW (REF ARRAY OF LineSeen, 100);
    ELSE
      WITH new = NEW (REF ARRAY OF LineSeen, 2 * NUMBER (used^)) DO
        FOR i := 0 TO LAST (used^) DO new[i] := used[i] END;
	used := new;
      END;
    END;
  END Expand;

PROCEDURE <A NAME="NoteProcedure"><procedure>NoteProcedure</procedure></A> (v: Value.T) =
  BEGIN
    IF (NOT Host.coverage) THEN RETURN END;
    WITH p = NEW (ProcHead) DO
      p.next   := procs;
      p.proc   := v;
      p.offset := -1;
      procs := p;
    END;
    INC (nProcs);
  END NoteProcedure;

PROCEDURE <A NAME="GenerateTables"><procedure>GenerateTables</procedure></A> () =
  VAR
    nLines    := MAX (0, maxLine - minLine) + 1;
    fname     := Host.FileTail (Host.filename);
    l_header  := TLen (Header);
    l_fname   := TLen (fname);
    l_trailer := TLen (Trailer);
    size    : INTEGER;
    p       : ProcHead;
    i, len  : INTEGER;
  BEGIN
    IF (NOT Host.coverage) THEN RETURN END;

    (* compute the size of the coverrage tables *)
    size := 0;
    INC (size, l_header * Target.Char.size);     (*header*)
    INC (size, Target.Integer.size);             (*timestamp*)
    INC (size, Target.Integer.size);             (*fileLen*)
    INC (size, l_fname * Target.Char.size);      (*file*)
    INC (size, Target.Integer.size);             (*firstLine*)
    INC (size, Target.Integer.size);             (*nLines*)
    INC (size, nLines * Target.Integer.size);    (*lines*)
    INC (size, Target.Integer.size);             (*nProcs*)
    p := procs;  i := 0;
    WHILE (p # NIL) DO
      IF (p.proc # NIL) THEN
        p.name := M3ID.ToText (Value.CName (p.proc));
        len := TLen (p.name);
        INC (size, Target.Integer.size);         (*len[p]*)
        INC (size, len * Target.Char.size);      (*pname[p]*)
        INC (size, Target.Integer.size);         (*cnt[p]*)
        INC (i);
      END;
      p := p.next;
    END;
    INC (size, l_trailer * Target.Char.size);  (*trailer*)

    (* allocate the variable *)
    tbl := CG.Declare_global (M3ID.NoID, size, Target.Address.align, CG.Type.Addr, 0,
                              exported := FALSE, init := TRUE);

    (* initialize the coverage tables *)
    CG.Begin_init (tbl);
    size := 0;

    CG.Init_chars (size, Header);
    INC (size, l_header * Target.Char.size);     (*header*)

    (* CG.Init_int (size, Target.Integer.size, TInt.Zero); *)
    INC (size, Target.Integer.size);             (*timestamp*)

    CG.Init_intt (size, Target.Integer.size, Text.Length (fname));
    INC (size, Target.Integer.size);             (*fileLen*)

    CG.Init_chars (size, fname);
    INC (size, l_fname * Target.Char.size);      (*file*)

    CG.Init_intt (size, Target.Integer.size, minLine);
    INC (size, Target.Integer.size);             (*firstLine*)

    CG.Init_intt (size, Target.Integer.size, nLines);
    INC (size, Target.Integer.size);             (*nLines*)

    lines_offset := size;
    FOR x := 0 TO nLines-1 DO
      IF (used # NIL) AND (used [x+minLine] # LineSeen.no)
        THEN len := 0;
        ELSE len := -1;
      END;
      CG.Init_intt (size, Target.Integer.size, len);
      INC (size, Target.Integer.size);    (*lines[x]*)
    END;

    CG.Init_intt (size, Target.Integer.size, i);
    INC (size, Target.Integer.size);             (*nProcs*)

    p := procs;
    WHILE (p # NIL) DO
      IF (p.proc # NIL) THEN
        len := TLen (p.name);

        CG.Init_intt (size, Target.Integer.size, Text.Length (p.name));
        INC (size, Target.Integer.size);         (*len[p]*)

        CG.Init_chars (size, p.name);
        INC (size, len * Target.Char.size);      (*pname[p]*)

        (* CG.Init_int (size, Target.Integer.size, 0); *)
        p.offset := size;
        INC (size, Target.Integer.size);         (*cnt[p]*)
      END;
      p := p.next;
    END;

    CG.Init_chars (size, Trailer);
    INC (size, l_trailer * Target.Char.size);    (*trailer*)

    CG.End_init (tbl);
  END GenerateTables;

PROCEDURE <A NAME="TLen"><procedure>TLen</procedure></A> (t: TEXT): INTEGER =
  VAR Grain := Target.Integer.size DIV Target.Char.size;
  BEGIN
    RETURN (Text.Length (t) + Grain - 1) DIV Grain * Grain;
  END TLen;

PROCEDURE <A NAME="CountLine"><procedure>CountLine</procedure></A> () =
  VAR line, offset: INTEGER;  file: TEXT;
  BEGIN
    IF (NOT Host.coverage) THEN RETURN END;
    Scanner.Here (file, line);
    IF (line &gt; MaxLine) THEN RETURN END;
    IF NOT Text.Equal (file, Host.filename) THEN RETURN END;
    IF used [line] = LineSeen.generated THEN RETURN END;
    &lt;*ASSERT tbl # NIL*&gt;
    offset := lines_offset + (line - minLine) * Target.Integer.size;
    CG.Load_int (tbl, offset);
    CG.Load_integer (TInt.One);
    CG.Add (CG.Type.Word);
    CG.Store_int (tbl, offset);
    used [line] := LineSeen.generated;
  END CountLine;

PROCEDURE <A NAME="CountProcedure"><procedure>CountProcedure</procedure></A> (v: Value.T) =
  VAR p: ProcHead;
  BEGIN
    IF (NOT Host.coverage) THEN RETURN END;
    &lt;*ASSERT tbl # NIL*&gt;

    (* find the corresponding Proc *)
    p := procs;
    WHILE (p # NIL) DO
      IF (p.proc = v) THEN EXIT END;
      p := p.next;
    END;
    &lt;*ASSERT p # NIL *&gt;

    CG.Load_int (tbl, p.offset);
    CG.Load_integer (TInt.One);
    CG.Add (CG.Type.Word);
    CG.Store_int (tbl, p.offset);
  END CountProcedure;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    minLine := LAST (INTEGER);
    maxLine := FIRST (INTEGER);
    used    := NIL;
    procs   := NIL;
    nProcs  := 0;
    tbl     := NIL;
  END Reset;

BEGIN
END Coverage.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
