<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/misc/ESet.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/misc/ESet.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ESet.m3                                               

<P><PRE>MODULE <module><implements><A HREF="ESet.i3">ESet</A></implements></module>;

IMPORT <A HREF="M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="CG.i3">CG</A>, <A HREF="../values/Value.i3">Value</A>, <A HREF="Token.i3">Token</A>, <A HREF="Scope.i3">Scope</A>, <A HREF="Scanner.i3">Scanner</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>;
IMPORT <A HREF="Error.i3">Error</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../values/Exceptionz.i3">Exceptionz</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../values/Module.i3">Module</A>;
FROM <A HREF="Scanner.i3">Scanner</A> IMPORT Match, MatchID, GetToken, cur;

TYPE TList = M3.ExSetList;
REVEAL
  M3.<A NAME="ExSetList">ExSetList</A> = BRANDED &quot;ESet.List&quot; REF RECORD
    set : T     := NIL;
    next: TList := NIL;
  END;

REVEAL
  M3.<A NAME="ExSet">ExSet</A> = M3.Node BRANDED &quot;ESet.T&quot; OBJECT
    elts     : Elt     := NIL;
    env      : Scope.T := NIL;
    any      : BOOLEAN := FALSE;
    resolved : BOOLEAN := FALSE;
    used_any : BOOLEAN := FALSE;
    hash     : INTEGER := 0;
    age      : INTEGER := 0;
    offset   : INTEGER := 0;
  END;

TYPE
  Elt = BRANDED &quot;ESet.Elt&quot; REF RECORD
    origin : INTEGER;
    name   : M3.QID;
    except : Value.T;
    next   : Elt;
    used   : BOOLEAN;
  END;

VAR AnySet     := NEW (T, any := TRUE,  resolved := TRUE);
VAR NoneSet    := NEW (T, any := FALSE, resolved := TRUE);
VAR DefaultSet := NoneSet;

TYPE HashTable = REF ARRAY OF T;

VAR thisAge  : INTEGER   := 1;
VAR hashTbl  : HashTable := NIL;
VAR n_hashed : INTEGER   := 0;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    INC (thisAge);
    hashTbl := NIL;
  END Reset;

PROCEDURE <A NAME="ParseRaises"><procedure>ParseRaises</procedure></A> (): T =
  TYPE  TK = Token.T;
  VAR t: T;  elt: Elt;  here := Scanner.offset;
  BEGIN
    Match (TK.tRAISES);
    IF cur.token = TK.tANY THEN
      GetToken (); (* ANY *)
      t := AnySet;
    ELSE
      elt := NIL;
      Match (TK.tLBRACE);
      WHILE (cur.token = TK.tIDENT) DO
        elt := NEW (Elt, next := elt);
        elt.origin      := Scanner.offset;
        elt.name.module := M3ID.NoID;
        elt.name.item   := MatchID ();
        elt.except      := NIL;
        IF (cur.token = TK.tDOT) THEN
          GetToken (); (* . *)
          elt.name.module := elt.name.item;
          elt.name.item   := MatchID ();
        END;
        IF (cur.token # TK.tCOMMA) THEN EXIT END;
        GetToken (); (* , *)
      END;
      Match (TK.tRBRACE);
      IF (elt = NIL)
        THEN t := NoneSet;
        ELSE t := NEW (T, origin := here, env := Scope.Top (), elts := elt);
      END;
    END;
    RETURN t;
  END ParseRaises;

PROCEDURE <A NAME="ParseFails"><procedure>ParseFails</procedure></A>  (existing: T): T =
  TYPE  TK = Token.T;
  VAR t: T := existing;  elt: Elt;
  BEGIN
    IF (t = NIL) THEN  t := NEW (T);  t.origin := Scanner.offset;  END;
    Match (TK.tFATAL);
    LOOP
      IF (cur.token = TK.tANY) THEN
        GetToken (); (* ANY *)
        t.any := TRUE;
      ELSIF (cur.token = TK.tIDENT) THEN
        IF (t.env = NIL) THEN t.env := Scope.Top () END;
        elt := NEW (Elt, next := t.elts);  t.elts := elt;
        elt.origin      := Scanner.offset;
        elt.name.module := M3ID.NoID;
        elt.name.item   := MatchID ();
        elt.except      := NIL;
        IF (cur.token = TK.tDOT) THEN
          GetToken (); (* . *)
          elt.name.module := elt.name.item;
          elt.name.item   := MatchID ();
        END;
      ELSE
        EXIT;
      END;
      IF (cur.token # TK.tCOMMA) THEN EXIT END;
      GetToken (); (* , *)
    END;
    Match (TK.tENDPRAGMA);
    RETURN t;
  END ParseFails;

PROCEDURE <A NAME="Hash"><procedure>Hash</procedure></A> (t: T): INTEGER =
  VAR hash := 691;  e: Elt;  o: Value.T;  oname: M3ID.T;
  BEGIN
    IF (t # NIL) THEN
      IF (t.hash = 0) THEN
        &lt;*ASSERT t.resolved*&gt;
        e := t.elts;
        WHILE (e # NIL) DO
          o := e.except;
          IF (o # NIL) THEN
            oname := Value.CName (o);
            hash := Word.Plus (Word.Times (hash, 89), M3ID.Hash (oname));
          END;
          e := e.next;
        END;
        t.hash := hash;
      END;
      hash := t.hash;
    END;
    RETURN hash;
  END Hash;

PROCEDURE <A NAME="LookUp"><procedure>LookUp</procedure></A> (t: T): T =
  VAR hx := Hash (t);   i: INTEGER;   x: T;
  BEGIN
    &lt;*ASSERT t.resolved*&gt;
    IF (hashTbl = NIL) THEN hashTbl := NEW (HashTable, 100) END;
    i := hx MOD NUMBER (hashTbl^);
    LOOP
      x := hashTbl[i];
      IF (x = NIL) THEN (* a new entry! *)
        hashTbl[i] := t;
        INC (n_hashed);
        IF (2 * n_hashed &gt; NUMBER (hashTbl^)) THEN ExpandHashTable () END;
        RETURN t;
      END;
      IF (x = t) OR IsEqual (x, t) THEN RETURN x END;
      INC (i);
      IF (i &gt; LAST (hashTbl^)) THEN i := 0 END;
    END;
  END LookUp;

PROCEDURE <A NAME="ExpandHashTable"><procedure>ExpandHashTable</procedure></A> () =
  VAR old := hashTbl;  t: T;
  BEGIN
    hashTbl  := NEW (HashTable, 2 * NUMBER (old^));
    n_hashed := 0;
    FOR i := FIRST (old^) TO LAST (old^) DO
      t := old[i];
      IF (t # NIL) THEN EVAL LookUp (t) END;
    END;
  END ExpandHashTable;

PROCEDURE <A NAME="Declare"><procedure>Declare</procedure></A> (t: T) =
  VAR e: Elt;  n: INTEGER;
  BEGIN
    IF (t = NIL) OR (t.any) OR (t.elts = NIL) THEN RETURN END;
    t := LookUp (t);
    IF (t.age &gt;= thisAge) THEN RETURN END;

    (* declare each of the exceptions and size the list *)
    e := t.elts; n := 1;
    WHILE (e # NIL) DO
      IF (e.except # NIL) THEN
        Value.Declare (e.except);
        INC (n);
      END;
      e := e.next;
    END;

    (* allocate the space *)
    t.offset := Module.Allocate (n * Target.Address.pack, Target.Address.align,
                                 &quot;*exception list*&quot;);
    (********************************
    type := CG.Declare_vector (n, CG.Builtin_ADDRESS, Target.Address.pack);
    CG.Declare_global_field (&quot;_eset&quot;, t.offset, n * Target.Address.pack, type);
    **********************************)

    (* initialize the list *)
    e := t.elts;  n := t.offset;
    WHILE (e # NIL) DO
      IF (e.except # NIL) THEN
        CG.Init_var (n, Scope.ToUnit (e.except),
                      Exceptionz.CGOffset (e.except));
        INC (n, Target.Address.pack);
      END;
      e := e.next;
    END;

    t.age := thisAge;
  END Declare;

PROCEDURE <A NAME="GetAddress"><procedure>GetAddress</procedure></A> (t: T;  VAR base: CG.Var;  VAR offset: INTEGER) =
  BEGIN
    IF (t = NIL) THEN
      base := NIL;
      offset := 0;
    ELSIF (t.any) THEN
      Error.Msg (&quot;INTERNAL ERROR: need address of RAISES ANY list&quot;);
      base := NIL;
      offset := 0;
    ELSIF (t.elts = NIL) THEN
      base := NIL;
      offset := 0;
    ELSE
      t := LookUp (t);
      Declare (t);
      base := Module.GlobalData (NIL);
      offset := t.offset;
    END;
  END GetAddress;

PROCEDURE <A NAME="RaisesAny"><procedure>RaisesAny</procedure></A> (t: T): BOOLEAN =
  BEGIN
    RETURN (t # NIL) AND (t.any);
  END RaisesAny;

PROCEDURE <A NAME="RaisesNone"><procedure>RaisesNone</procedure></A> (t: T): BOOLEAN =
  BEGIN
    RETURN (t = NIL) OR ((NOT t.any) AND (t.elts = NIL));
  END RaisesNone;

PROCEDURE <A NAME="NewAny"><procedure>NewAny</procedure></A> (): T =
  BEGIN
    RETURN NEW (T, any := TRUE, origin := Scanner.offset);
  END NewAny;

PROCEDURE <A NAME="NewEmpty"><procedure>NewEmpty</procedure></A> (env: Scope.T): T =
  BEGIN
    RETURN NEW (T, env := env, origin := Scanner.offset);
  END NewEmpty;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (t: T;  READONLY name: M3.QID;   ex: Value.T) =
  VAR e: Elt;
  BEGIN
    ex := Value.Base (ex);

    (* check for a duplicate *)
    e := t.elts;
    WHILE (e # NIL) DO
      IF (e.except = ex) AND (ex # NIL) THEN
        Error.QID (name, &quot;repeated exception in handler list&quot;);
        RETURN;
      END;
      e := e.next;
    END;

    t.elts := NEW (Elt, origin := Scanner.offset, next := t.elts,
                   name := name, except := ex);
  END Add;

PROCEDURE <A NAME="IsEqual"><procedure>IsEqual</procedure></A> (a, b: T): BOOLEAN =
  BEGIN
    IF (a = NIL) THEN a := DefaultSet END;
    IF (b = NIL) THEN b := DefaultSet END;
    IF (a.any # b.any) THEN RETURN FALSE END;
    Resolve (a);
    Resolve (b);
    RETURN EltSubset (a.elts, b.elts) AND EltSubset (b.elts, a.elts);
  END IsEqual;

PROCEDURE <A NAME="IsSubset"><procedure>IsSubset</procedure></A> (a, b: T): BOOLEAN =
</PRE><BLOCKQUOTE><EM> TRUE iff a is a subset of b </EM></BLOCKQUOTE><PRE>
  BEGIN
    IF (a = NIL) THEN a := DefaultSet END;
    IF (b = NIL) THEN b := DefaultSet END;
    IF (b.any) THEN RETURN TRUE END;
    IF (a.any) THEN RETURN FALSE END;
    Resolve (a);
    Resolve (b);
    RETURN EltSubset (a.elts, b.elts);
  END IsSubset;

PROCEDURE <A NAME="TypeCheck"><procedure>TypeCheck</procedure></A> (t: T) =
  BEGIN
    IF (t # NIL) THEN Resolve (t) END;
  END TypeCheck;

PROCEDURE <A NAME="Push"><procedure>Push</procedure></A> (VAR cs: M3.CheckState;  ok_to_raise, no_error: T;
                                                               stop: BOOLEAN) =
  VAR x: TList;
  BEGIN
    IF (stop) THEN
      (* this is a nested procedure =&gt; truncate the &quot;ok_to_raise&quot; list *)
      cs.ok_to_raise := NEW (TList, set := NIL, next := cs.ok_to_raise);
    END;

    IF (ok_to_raise # NIL) THEN
      ResetUsed (ok_to_raise);
      x := NEW (TList, set := ok_to_raise);
      x.next := cs.ok_to_raise;
      cs.ok_to_raise := x;
    END;
    IF (no_error # NIL) THEN
      ResetUsed (no_error);
      x := NEW (TList, set := no_error);
      x.next := cs.no_error;
      cs.no_error := x;
    END;
  END Push;

PROCEDURE <A NAME="ResetUsed"><procedure>ResetUsed</procedure></A> (t: T) =
  VAR e := t.elts;
  BEGIN
    t.used_any := FALSE;
    WHILE (e # NIL) DO e.used := FALSE;  e := e.next; END;
  END ResetUsed;

PROCEDURE <A NAME="Pop"><procedure>Pop</procedure></A> (VAR cs: M3.CheckState;  ok_to_raise, no_error: T;
                                                               stop: BOOLEAN) =
  VAR u: TList;
  BEGIN
    IF (ok_to_raise # NIL) THEN
      &lt;*ASSERT ok_to_raise = cs.ok_to_raise.set *&gt;
      CheckUnused (ok_to_raise);
      cs.ok_to_raise := cs.ok_to_raise.next;
    END;
    IF (no_error # NIL) THEN
      &lt;*ASSERT no_error = cs.no_error.set *&gt;
      CheckUnused (no_error);
      cs.no_error := cs.no_error.next;
    END;
    IF (stop) THEN
      u := cs.ok_to_raise;
      cs.ok_to_raise := u.next;
      &lt;* ASSERT u.set = NIL *&gt;
    END;
  END Pop;

PROCEDURE <A NAME="CheckUnused"><procedure>CheckUnused</procedure></A> (t: T) =
  VAR save := Scanner.offset;  e := t.elts;
  BEGIN
    WHILE (e # NIL) DO
      IF (e.except # NIL) AND (NOT e.used) THEN
        Scanner.offset := e.origin;
        Error.Warn (1, &quot;exception is never raised: &quot;
          &amp; Value.GlobalName (e.except, dots := TRUE, with_module := TRUE));
      END;
      e := e.next;
    END;
    IF (t.any) AND (NOT t.used_any) THEN
      IF (t.origin = 0)
        THEN Scanner.offset := save;
        ELSE Scanner.offset := t.origin;
      END;
      Error.Warn (1, &quot;exception is never raised: &lt;ANY&gt;&quot;);
    END;
    Scanner.offset := save;
  END CheckUnused;

PROCEDURE <A NAME="MarkEverythingUsed"><procedure>MarkEverythingUsed</procedure></A> (u: TList;  handler: BOOLEAN) =
  VAR t: T;  e: Elt;
  BEGIN
    WHILE (u # NIL) DO
      t := u.set;
      IF (t = NIL) THEN EXIT END;
      IF (t.any) THEN
        t.used_any := TRUE;
        IF (handler) THEN EXIT END;
      END;
      e := t.elts;
      WHILE (e # NIL) DO
        e.used := TRUE;
        e := e.next;
      END;
      u := u.next;
    END;
  END MarkEverythingUsed;

PROCEDURE <A NAME="NoteExceptions"><procedure>NoteExceptions</procedure></A> (VAR cs: M3.CheckState;  t: T) =
  VAR u: TList;  e: Elt;  n_bad: INTEGER;  name, bad: TEXT;
  BEGIN
    IF (t = NIL) THEN RETURN END;

    IF (t.any) THEN
      MarkEverythingUsed (cs.ok_to_raise, TRUE);
      MarkEverythingUsed (cs.no_error, FALSE);
      u := cs.ok_to_raise;
      WHILE (u # NIL) AND (u.set # NIL) DO
        IF (u.set.any) THEN u.set.used_any := TRUE;  RETURN END;
        u := u.next;
      END;
      cs.raises_others := TRUE;
      u := cs.no_error;
      WHILE (u # NIL) DO
        IF (u.set.any) THEN u.set.used_any := TRUE;  RETURN END;
        u := u.next;
      END;
      Error.Warn (1, &quot;potentially unhandled exception: &lt;ANY&gt;&quot;);
      RETURN;
    END;

    e := t.elts;  n_bad := 0;
    WHILE (e # NIL) DO
      name := CheckRaise (cs, e.except);
      IF (name # NIL) THEN
        IF (n_bad = 0)
          THEN bad := name;
          ELSE bad := bad &amp; &quot;, &quot; &amp; name;
        END;
        INC (n_bad);
      END;
      e := e.next;
    END;

    IF (n_bad &gt; 0) THEN
      IF (n_bad = 1)
        THEN Error.Warn (1, &quot;potentially unhandled exception: &quot; &amp; bad);
        ELSE Error.Warn (1, &quot;potentially unhandled exceptions: &quot; &amp; bad );
      END;
    END;

  END NoteExceptions;

PROCEDURE <A NAME="NoteException"><procedure>NoteException</procedure></A> (VAR cs: M3.CheckState;  v: Value.T) =
  VAR name := CheckRaise (cs, v);
  BEGIN
    IF (name # NIL) THEN
      Error.Warn (1, &quot;potentially unhandled exception: &quot; &amp; name);
    END;
  END NoteException;

PROCEDURE <A NAME="CheckRaise"><procedure>CheckRaise</procedure></A> (VAR cs: M3.CheckState;  v: Value.T): TEXT =
</PRE><BLOCKQUOTE><EM> Returns NIL if it's ok to raise the exception 'v', otherwise
   returns the fully qualified name of the exception. </EM></BLOCKQUOTE><PRE>
  BEGIN
    IF (v = NIL) THEN (* there's already been an error *) RETURN NIL END;
    v := Value.Base (v);
    IF CheckTList (cs.ok_to_raise, v) THEN RETURN NIL END;
    cs.raises_others := TRUE;
    IF CheckTList (cs.no_error, v) THEN RETURN NIL END;
    RETURN Value.GlobalName (v, dots := TRUE, with_module := TRUE);
  END CheckRaise;

PROCEDURE <A NAME="CheckTList"><procedure>CheckTList</procedure></A> (u: TList;  v: Value.T): BOOLEAN =
</PRE><BLOCKQUOTE><EM> Return TRUE if exception 'v' occurs in the list of sets 'u'. </EM></BLOCKQUOTE><PRE>
  VAR e: Elt;  t: T;
  BEGIN
    WHILE (u # NIL) AND (u.set # NIL) DO
      t := u.set;
      e := t.elts;
      WHILE (e # NIL) DO
        IF ExceptionEQ (e.except, v) THEN e.used := TRUE; RETURN TRUE END;
        e := e.next;
      END;
      IF (t.any) THEN t.used_any := TRUE; RETURN TRUE END;
      u := u.next;
    END;
    RETURN FALSE;
  END CheckTList;
</PRE>------------------------------------------------------------- debugging ---

<P><PRE>PROCEDURE <A NAME="EmitTypes"><procedure>EmitTypes</procedure></A> (t: T): INTEGER =
  VAR e: Elt;  n: INTEGER;
  BEGIN
    IF (t = NIL) THEN RETURN 0 END;
    t := LookUp (t);
    IF (t.any) THEN RETURN -1 END;

    e := t.elts;  n := 0;
    WHILE (e # NIL) DO
      IF (e.except # NIL) THEN
        Value.Declare (e.except);
        INC (n);
      END;
      e := e.next;
    END;

    RETURN n;
  END EmitTypes;

PROCEDURE <A NAME="EmitNames"><procedure>EmitNames</procedure></A> (t: T) =
  VAR e: Elt;
  BEGIN
    IF (t = NIL) THEN RETURN END;
    t := LookUp (t);
    IF (t.any) THEN RETURN END;
    e := t.elts;
    WHILE (e # NIL) DO
      IF (e.except # NIL) THEN
        CG.Declare_raises (M3ID.Add (Value.GlobalName (e.except, dots := TRUE,
                                                       with_module := TRUE)));
      END;
      e := e.next;
    END;
  END EmitNames;
</PRE>---------------------------------------------------------- fingerprints ---

<P><PRE>PROCEDURE <A NAME="AddFPTag"><procedure>AddFPTag</procedure></A> (t: T;  VAR x: M3.FPInfo): CARDINAL =
  VAR e: Elt;  n: INTEGER;
  BEGIN
    IF (t = NIL) THEN RETURN 0 END;
    t := LookUp (t);
    IF (t.any) THEN
      M3Buf.PutText (x.buf, &quot;RAISES-ANY&quot;);
      RETURN 0;
    ELSIF (t.elts = NIL) THEN
      RETURN 0;
    ELSE
      &lt;*ASSERT t.resolved*&gt;
      M3Buf.PutText (x.buf, &quot;RAISES{&quot;);
      e := t.elts;  n := 0;
      WHILE (e # NIL) DO
        INC (n, Exceptionz.AddFPSetTag (e.except, x));
        e := e.next;
      END;
      M3Buf.PutChar (x.buf, '}');
      RETURN n;
    END;
  END AddFPTag;

PROCEDURE <A NAME="AddFPEdges"><procedure>AddFPEdges</procedure></A> (t: T;  VAR x: M3.FPInfo;  n: CARDINAL): CARDINAL =
  VAR e: Elt;
  BEGIN
    IF (t = NIL) THEN t := DefaultSet END;
    t := LookUp (t);
    IF (NOT t.any) THEN
      e := t.elts;
      WHILE (e # NIL) DO
        n := Value.AddFPEdges (e.except, x, n);
        e := e.next;
      END;
    END;
    RETURN n;
  END AddFPEdges;
</PRE>-------------------------------------------------------------- internal ---

<P><PRE>PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (t: T) =
  (* look up each of the named exceptions *)
  VAR e: Elt;  o: Value.T;  save: INTEGER;
  BEGIN
    IF (t.resolved) THEN RETURN END;
    save := Scanner.offset;
    Scanner.offset := t.origin;
    e := t.elts;
    WHILE (e # NIL) DO
      IF (e.except = NIL)
        THEN o := Scope.LookUpQID (t.env, e.name);
        ELSE o := e.except;
      END;
      IF (o = NIL) THEN
        Error.QID (e.name, &quot;undefined&quot;);
      ELSIF (Value.ClassOf (o) # Value.Class.Exception) THEN
        Error.QID (e.name, &quot;not an exception&quot;);
      ELSE
        e.except := Value.Base (o);
      END;
      e := e.next;
    END;
    Scanner.offset := save;
    t.elts := SortElts (t.elts);
    t.resolved := TRUE;
  END Resolve;
</PRE>************ assume the lists are sorted **************************
<PRE>PROCEDURE <A NAME="EltSubset"><procedure>EltSubset</procedure></A> (a, b: Elt): BOOLEAN =
  BEGIN
    WHILE (a # NIL) DO
      LOOP
        IF (b = NIL) THEN RETURN FALSE END;
        IF ExceptionEQ (b.except, a.except) THEN EXIT END;
        b := b.next;
      END;
      (* this element of a is in b *)
      a := a.next;
    END;
    RETURN TRUE;
  END EltSubset;
</PRE>**** assumes that the lists are not sorted *************************
PROCEDURE EltSubset (a, b: Elt): BOOLEAN =
  VAR ar, br: Elt;
  BEGIN
    ar := a;
    WHILE (ar # NIL) DO
      br := b;
      LOOP
        IF (br = NIL) THEN RETURN FALSE END;
        IF ExceptionEQ (br.except, ar.except) THEN EXIT END;
        br := br.next;
      END;
      (* this element of a is in b 
      <PRE>ar := ar.next;
    END;
    RETURN TRUE;
  END EltSubset;
*********************************************************************)

PROCEDURE <A NAME="SortElts"><procedure>SortElts</procedure></A> (e: Elt): Elt =
  VAR i: INTEGER;  x: Elt;  tmp: ARRAY [0..9] OF Elt;
  BEGIN
    IF (e = NIL) THEN RETURN NIL END;
    IF (e.next = NIL) THEN RETURN e END;

    (* unpack the list *)
    i := 0;  x := e;
    WHILE (x # NIL) DO
      IF (i &lt;= LAST (tmp)) THEN tmp[i] := x END;
      x := x.next;
      INC (i);
    END;

    IF (i &lt;= NUMBER (tmp)) THEN
      RETURN DoSort (tmp, i);
    ELSE
      WITH ref = NEW (REF ARRAY OF Elt, i) DO
        i := 0;  x := e;
        WHILE (x # NIL) DO  ref[i] := x;  x := x.next; INC (i)  END;
        RETURN DoSort (ref^, i);
      END;
    END;
  END SortElts;

PROCEDURE <A NAME="DoSort"><procedure>DoSort</procedure></A> (VAR e: ARRAY OF Elt;  n: INTEGER): Elt =
  VAR x: Elt;  j: INTEGER;
  BEGIN
    (* insertion sort the list *)
    FOR i := 1 TO n-1 DO
      x := e[i];
      j := i-1;
      WHILE (j &gt;= 0) AND EltLT (x, e[j]) DO  e[j+1] := e[j]; DEC (j)  END;
      e[j+1] := x;
    END;

    (* build the new linked list *)
    FOR i := 0 TO n-2 DO  e[i].next := e[i+1]  END;
    e[n-1].next := NIL;

    RETURN e[0];
  END DoSort;

PROCEDURE <A NAME="EltLT"><procedure>EltLT</procedure></A> (a, b: Elt): BOOLEAN =
  VAR aName, bName: Scope.IDStack;
  BEGIN
    IF (a = b)               THEN RETURN FALSE END;
    IF (a = NIL)             THEN RETURN TRUE  END;
    IF (b = NIL)             THEN RETURN FALSE END;
    IF (a.except = b.except) THEN RETURN FALSE END;
    IF (a.except = NIL)      THEN RETURN TRUE  END;
    IF (b.except = NIL)      THEN RETURN FALSE END;
    aName.top := 0;  bName.top := 0;
    Scope.NameToPrefix (a.except, aName);
    Scope.NameToPrefix (b.except, bName);
    FOR i := 0 TO MIN (aName.top, bName.top) - 1 DO
      WITH ax = aName.stk[i], bx = bName.stk[i] DO
        IF (ax # bx) THEN RETURN M3ID.IsLT (ax, bx) END;
      END;
    END;
    RETURN (aName.top &lt; bName.top);
  END EltLT;

PROCEDURE <A NAME="ExceptionEQ"><procedure>ExceptionEQ</procedure></A> (a, b: Value.T): BOOLEAN =
  VAR aName, bName: Scope.IDStack;
  BEGIN
    IF (a = b)                THEN RETURN TRUE  END;
    IF (a = NIL) OR (b = NIL) THEN RETURN FALSE END;

    aName.top := 0;  bName.top := 0;
    Scope.NameToPrefix (a, aName);
    Scope.NameToPrefix (b, bName);
    IF (aName.top # bName.top) THEN RETURN FALSE END;
    FOR i := 0 TO aName.top - 1 DO
      IF (aName.stk[i] # bName.stk[i]) THEN RETURN FALSE END;
    END;

    RETURN TRUE;
  END ExceptionEQ;

BEGIN
END ESet.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
